/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.ref.WeakReference;
import org.h2.engine.Database;
import org.h2.message.Trace;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DelayedDatabaseCloser
extends Thread {
    private final Trace trace;
    private volatile WeakReference<Database> databaseRef;
    private int delayInMillis;

    DelayedDatabaseCloser(Database db, int delayInMillis) {
        this.databaseRef = new WeakReference<Database>(db);
        this.delayInMillis = delayInMillis;
        this.trace = db.getTrace(2);
        this.setName("H2 Close Delay " + db.getShortName());
        this.setDaemon(true);
        this.start();
    }

    void reset() {
        this.databaseRef = null;
    }

    @Override
    public void run() {
        Database database;
        while (this.delayInMillis > 0) {
            try {
                int step = 100;
                Thread.sleep(step);
                this.delayInMillis -= step;
            }
            catch (Exception step) {
                // empty catch block
            }
            WeakReference<Database> ref = this.databaseRef;
            if (ref != null && ref.get() != null) continue;
            return;
        }
        WeakReference<Database> ref = this.databaseRef;
        if (ref != null && (database = (Database)ref.get()) != null) {
            try {
                database.close();
            }
            catch (RuntimeException e) {
                try {
                    this.trace.error(e, "could not close the database");
                }
                catch (Throwable e2) {
                    e.addSuppressed(e2);
                    throw e;
                }
            }
        }
    }
}

