/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.h2.command.Command;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.DbSettings;
import org.h2.engine.RightOwner;
import org.h2.engine.SessionLocal;
import org.h2.engine.SysProperties;
import org.h2.engine.User;
import org.h2.message.DbException;
import org.h2.security.auth.AuthenticationException;
import org.h2.security.auth.AuthenticationInfo;
import org.h2.security.auth.Authenticator;
import org.h2.store.fs.FileUtils;
import org.h2.util.MathUtils;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.util.ThreadDeadlockDetector;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Engine {
    private static final Map<String, DatabaseHolder> DATABASES = new HashMap<String, DatabaseHolder>();
    private static volatile long WRONG_PASSWORD_DELAY = SysProperties.DELAY_WRONG_PASSWORD_MIN;
    private static boolean JMX;

    static {
        if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
            ThreadDeadlockDetector.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SessionLocal openSession(ConnectionInfo ci, boolean ifExists, boolean forbidCreation, String cipher) {
        Database database;
        DatabaseHolder databaseHolder;
        Object object;
        String name = ci.getName();
        ci.removeProperty("NO_UPGRADE", false);
        boolean openNew = ci.getProperty("OPEN_NEW", false);
        boolean opened = false;
        User user = null;
        if (!ci.isUnnamedInMemory()) {
            object = DATABASES;
            synchronized (object) {
                databaseHolder = DATABASES.computeIfAbsent(name, key -> new DatabaseHolder());
            }
        } else {
            databaseHolder = new DatabaseHolder();
        }
        object = databaseHolder;
        synchronized (object) {
            database = databaseHolder.database;
            if (database == null || openNew) {
                if (ci.isPersistent()) {
                    String fileName;
                    String p = ci.getProperty("MV_STORE");
                    if (p == null) {
                        fileName = name + ".mv.db";
                        if (!FileUtils.exists(fileName)) {
                            Engine.throwNotFound(ifExists, forbidCreation, name);
                            fileName = name + ".data.db";
                            if (FileUtils.exists(fileName)) {
                                throw DbException.getFileVersionError(fileName);
                            }
                            fileName = null;
                        }
                    } else {
                        fileName = name + ".mv.db";
                        if (!FileUtils.exists(fileName)) {
                            Engine.throwNotFound(ifExists, forbidCreation, name);
                            fileName = null;
                        }
                    }
                    if (fileName != null && !FileUtils.canWrite(fileName)) {
                        ci.setProperty("ACCESS_MODE_DATA", "r");
                    }
                } else {
                    Engine.throwNotFound(ifExists, forbidCreation, name);
                }
                database = new Database(ci, cipher);
                opened = true;
                boolean found = false;
                for (RightOwner rightOwner : database.getAllUsersAndRoles()) {
                    if (!(rightOwner instanceof User)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    user = new User(database, database.allocateObjectId(), ci.getUserName(), false);
                    user.setAdmin(true);
                    user.setUserPasswordHash(ci.getUserPasswordHash());
                    database.setMasterUser(user);
                }
                databaseHolder.database = database;
            }
        }
        if (opened) {
            database.opened();
        }
        if (database.isClosing()) {
            return null;
        }
        if (user == null) {
            if (database.validateFilePasswordHash(cipher, ci.getFilePasswordHash())) {
                if (ci.getProperty("AUTHREALM") == null) {
                    user = database.findUser(ci.getUserName());
                    if (user != null && !user.validateUserPasswordHash(ci.getUserPasswordHash())) {
                        user = null;
                    }
                } else {
                    Authenticator authenticator = database.getAuthenticator();
                    if (authenticator == null) {
                        throw DbException.get(90144, name);
                    }
                    try {
                        AuthenticationInfo authenticationInfo = new AuthenticationInfo(ci);
                        user = database.getAuthenticator().authenticate(authenticationInfo, database);
                    }
                    catch (AuthenticationException authenticationError) {
                        database.getTrace(2).error(authenticationError, "an error occurred during authentication; user: \"" + ci.getUserName() + "\"");
                    }
                }
            }
            if (opened && (user == null || !user.isAdmin())) {
                database.setEventListener(null);
            }
        }
        if (user == null) {
            DbException er = DbException.get(28000);
            database.getTrace(2).error(er, "wrong user or password; user: \"" + ci.getUserName() + "\"");
            database.removeSession(null);
            throw er;
        }
        ci.cleanAuthenticationInfo();
        Engine.checkClustering(ci, database);
        SessionLocal session = database.createSession(user, ci.getNetworkConnectionInfo());
        if (session == null) {
            return null;
        }
        if (ci.getProperty("OLD_INFORMATION_SCHEMA", false)) {
            session.setOldInformationSchema(true);
        }
        if (ci.getProperty("JMX", false)) {
            try {
                Utils.callStaticMethod("org.h2.jmx.DatabaseInfo.registerMBean", ci, database);
            }
            catch (Exception e) {
                database.removeSession(session);
                throw DbException.get(50100, e, "JMX");
            }
            JMX = true;
        }
        return session;
    }

    private static void throwNotFound(boolean ifExists, boolean forbidCreation, String name) {
        if (ifExists) {
            throw DbException.get(90146, name);
        }
        if (forbidCreation) {
            throw DbException.get(90149, name);
        }
    }

    public static SessionLocal createSession(ConnectionInfo ci) {
        try {
            SessionLocal session = Engine.openSession(ci);
            Engine.validateUserAndPassword(true);
            return session;
        }
        catch (DbException e) {
            if (e.getErrorCode() == 28000) {
                Engine.validateUserAndPassword(false);
            }
            throw e;
        }
    }

    private static SessionLocal openSession(ConnectionInfo ci) {
        SessionLocal session;
        boolean ifExists = ci.removeProperty("IFEXISTS", false);
        boolean forbidCreation = ci.removeProperty("FORBID_CREATION", false);
        boolean ignoreUnknownSetting = ci.removeProperty("IGNORE_UNKNOWN_SETTINGS", false);
        String cipher = ci.removeProperty("CIPHER", null);
        String init = ci.removeProperty("INIT", null);
        long start = System.nanoTime();
        while ((session = Engine.openSession(ci, ifExists, forbidCreation, cipher)) == null) {
            if (System.nanoTime() - start > 60000000000L) {
                throw DbException.get(90020, "Waited for database closing longer than 1 minute");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw DbException.get(90121);
            }
        }
        session.lock();
        try {
            block21: {
                session.setAllowLiterals(true);
                DbSettings defaultSettings = DbSettings.DEFAULT;
                String[] stringArray = ci.getKeys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block20: {
                        String setting = stringArray[n2];
                        if (!defaultSettings.containsKey(setting)) {
                            String value = ci.getProperty(setting);
                            StringBuilder builder = new StringBuilder("SET ").append(setting).append(' ');
                            if (!ParserUtil.isSimpleIdentifier(setting, false, false)) {
                                if (!setting.equalsIgnoreCase("TIME ZONE")) {
                                    throw DbException.get(90113, setting);
                                }
                                StringUtils.quoteStringSQL(builder, value);
                            } else {
                                builder.append(value);
                            }
                            try {
                                Command command = session.prepareLocal(builder.toString());
                                command.executeUpdate(null);
                            }
                            catch (DbException e) {
                                if (e.getErrorCode() == 90040) {
                                    session.getTrace().error(e, "admin rights required; user: \"" + ci.getUserName() + "\"");
                                } else {
                                    session.getTrace().error(e, "");
                                }
                                if (ignoreUnknownSetting) break block20;
                                session.close();
                                throw e;
                            }
                        }
                    }
                    ++n2;
                }
                TimeZoneProvider timeZone = ci.getTimeZone();
                if (timeZone != null) {
                    session.setTimeZone(timeZone);
                }
                if (init != null) {
                    try {
                        Command command = session.prepareLocal(init);
                        command.executeUpdate(null);
                    }
                    catch (DbException e) {
                        if (ignoreUnknownSetting) break block21;
                        session.close();
                        throw e;
                    }
                }
            }
            session.setAllowLiterals(false);
            session.commit(true);
        }
        finally {
            session.unlock();
        }
        return session;
    }

    private static void checkClustering(ConnectionInfo ci, Database database) {
        String clusterSession = ci.getProperty(12, null);
        if ("''".equals(clusterSession)) {
            return;
        }
        String clusterDb = database.getCluster();
        if (!("''".equals(clusterDb) || "TRUE".equals(clusterSession) || Objects.equals(clusterSession, clusterDb))) {
            if (clusterDb.equals("''")) {
                throw DbException.get(90093);
            }
            throw DbException.get(90094, clusterDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void close(String name) {
        if (JMX) {
            try {
                Utils.callStaticMethod("org.h2.jmx.DatabaseInfo.unregisterMBean", name);
            }
            catch (Exception e) {
                throw DbException.get(50100, e, "JMX");
            }
        }
        Map<String, DatabaseHolder> map = DATABASES;
        synchronized (map) {
            DATABASES.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateUserAndPassword(boolean correct) {
        int min = SysProperties.DELAY_WRONG_PASSWORD_MIN;
        if (correct) {
            long delay = WRONG_PASSWORD_DELAY;
            if (delay > (long)min && delay > 0L) {
                Class<Engine> clazz = Engine.class;
                synchronized (Engine.class) {
                    delay = MathUtils.secureRandomInt((int)delay);
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    WRONG_PASSWORD_DELAY = min;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                }
            }
        } else {
            Class<Engine> clazz = Engine.class;
            synchronized (Engine.class) {
                long delay = WRONG_PASSWORD_DELAY;
                int max = SysProperties.DELAY_WRONG_PASSWORD_MAX;
                if (max <= 0) {
                    max = Integer.MAX_VALUE;
                }
                if ((WRONG_PASSWORD_DELAY += WRONG_PASSWORD_DELAY) > (long)max || WRONG_PASSWORD_DELAY < 0L) {
                    WRONG_PASSWORD_DELAY = max;
                }
                if (min > 0) {
                    delay += Math.abs(MathUtils.secureRandomLong() % 100L);
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw DbException.get(28000);
            }
        }
    }

    private Engine() {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class DatabaseHolder {
        volatile Database database;

        DatabaseHolder() {
        }
    }
}

