/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.message.DbException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum IsolationLevel {
    READ_UNCOMMITTED(1, 0),
    READ_COMMITTED(2, 3),
    REPEATABLE_READ(4, 1),
    SNAPSHOT(6, 1),
    SERIALIZABLE(8, 1);

    private final String sql = this.name().replace('_', ' ').intern();
    private final int jdbc;
    private final int lockMode;

    public static IsolationLevel fromJdbc(int level) {
        switch (level) {
            case 1: {
                return READ_UNCOMMITTED;
            }
            case 2: {
                return READ_COMMITTED;
            }
            case 4: {
                return REPEATABLE_READ;
            }
            case 6: {
                return SNAPSHOT;
            }
            case 8: {
                return SERIALIZABLE;
            }
        }
        throw DbException.getInvalidValueException("isolation level", level);
    }

    public static IsolationLevel fromLockMode(int lockMode) {
        switch (lockMode) {
            case 0: {
                return READ_UNCOMMITTED;
            }
            default: {
                return READ_COMMITTED;
            }
            case 1: 
            case 2: 
        }
        return SERIALIZABLE;
    }

    public static IsolationLevel fromSql(String sql) {
        switch (sql) {
            case "READ UNCOMMITTED": {
                return READ_UNCOMMITTED;
            }
            case "READ COMMITTED": {
                return READ_COMMITTED;
            }
            case "REPEATABLE READ": {
                return REPEATABLE_READ;
            }
            case "SNAPSHOT": {
                return SNAPSHOT;
            }
            case "SERIALIZABLE": {
                return SERIALIZABLE;
            }
        }
        throw DbException.getInvalidValueException("isolation level", sql);
    }

    private IsolationLevel(int jdbc, int lockMode) {
        this.jdbc = jdbc;
        this.lockMode = lockMode;
    }

    public String getSQL() {
        return this.sql;
    }

    public int getJdbc() {
        return this.jdbc;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public boolean allowNonRepeatableRead() {
        return this.ordinal() < REPEATABLE_READ.ordinal();
    }
}

