/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.WeakHashMap;
import org.h2.engine.Database;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class OnExitDatabaseCloser
extends Thread {
    private static final WeakHashMap<Database, Void> DATABASES = new WeakHashMap();
    private static final Thread INSTANCE = new OnExitDatabaseCloser();
    private static boolean registered;
    private static boolean terminated;

    static synchronized void register(Database db) {
        if (terminated) {
            return;
        }
        DATABASES.put(db, null);
        if (!registered) {
            registered = true;
            try {
                Runtime.getRuntime().addShutdownHook(INSTANCE);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    static synchronized void unregister(Database db) {
        if (terminated) {
            return;
        }
        DATABASES.remove(db);
        if (DATABASES.isEmpty() && registered) {
            try {
                Runtime.getRuntime().removeShutdownHook(INSTANCE);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            registered = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onShutdown() {
        Class<OnExitDatabaseCloser> clazz = OnExitDatabaseCloser.class;
        synchronized (OnExitDatabaseCloser.class) {
            terminated = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            RuntimeException root = null;
            for (Database database : DATABASES.keySet()) {
                try {
                    database.onShutdown();
                }
                catch (RuntimeException e) {
                    try {
                        database.getTrace(2).error(e, "could not close the database");
                    }
                    catch (Throwable e2) {
                        e.addSuppressed(e2);
                        if (root == null) {
                            root = e;
                            continue;
                        }
                        root.addSuppressed(e);
                    }
                }
            }
            if (root != null) {
                throw root;
            }
            return;
        }
    }

    private OnExitDatabaseCloser() {
    }

    @Override
    public void run() {
        OnExitDatabaseCloser.onShutdown();
    }
}

