/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.h2.message.DbException;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SettingsBase {
    private final HashMap<String, String> settings;

    protected SettingsBase(HashMap<String, String> s) {
        this.settings = s;
    }

    protected boolean get(String key, boolean defaultValue) {
        String s = this.get(key, Boolean.toString(defaultValue));
        try {
            return Utils.parseBoolean(s, defaultValue, true);
        }
        catch (IllegalArgumentException e) {
            throw DbException.get(22018, e, "key:" + key + " value:" + s);
        }
    }

    void set(String key, boolean value) {
        this.settings.put(key, Boolean.toString(value));
    }

    protected int get(String key, int defaultValue) {
        String s = this.get(key, Integer.toString(defaultValue));
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            throw DbException.get(22018, e, "key:" + key + " value:" + s);
        }
    }

    protected String get(String key, String defaultValue) {
        String v = this.settings.get(key);
        if (v != null) {
            return v;
        }
        StringBuilder buff = new StringBuilder("h2.");
        boolean nextUpper = false;
        int i = 0;
        int l = key.length();
        while (i < l) {
            char c = key.charAt(i);
            if (c == '_') {
                nextUpper = true;
            } else {
                buff.append(nextUpper ? Character.toUpperCase(c) : Character.toLowerCase(c));
                nextUpper = false;
            }
            ++i;
        }
        String sysProperty = buff.toString();
        v = Utils.getProperty(sysProperty, defaultValue);
        this.settings.put(key, v);
        return v;
    }

    protected boolean containsKey(String k) {
        return this.settings.containsKey(k);
    }

    public HashMap<String, String> getSettings() {
        return this.settings;
    }

    public Map.Entry<String, String>[] getSortedSettings() {
        Map.Entry[] entries = this.settings.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entries, Comparator.comparing(Map.Entry::getKey));
        return entries;
    }
}

