/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.Arrays;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.security.SHA256;
import org.h2.table.DualTable;
import org.h2.table.MetaTable;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class User
extends RightOwner {
    private final boolean systemUser;
    private byte[] salt;
    private byte[] passwordHash;
    private boolean admin;

    public User(Database database, int id, String userName, boolean systemUser) {
        super(database, id, userName, 13);
        this.systemUser = systemUser;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setSaltAndHash(byte[] salt, byte[] hash) {
        this.salt = salt;
        this.passwordHash = hash;
    }

    public void setUserPasswordHash(byte[] userPasswordHash) {
        if (userPasswordHash != null) {
            if (userPasswordHash.length == 0) {
                this.passwordHash = userPasswordHash;
                this.salt = userPasswordHash;
            } else {
                this.salt = new byte[8];
                MathUtils.randomBytes(this.salt);
                this.passwordHash = SHA256.getHashWithSalt(userPasswordHash, this.salt);
            }
        }
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(true);
    }

    public String getCreateSQL(boolean password) {
        StringBuilder buff = new StringBuilder("CREATE USER IF NOT EXISTS ");
        this.getSQL(buff, 0);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            StringUtils.quoteStringSQL(buff, this.comment);
        }
        if (password) {
            buff.append(" SALT '");
            StringUtils.convertBytesToHex(buff, this.salt).append("' HASH '");
            StringUtils.convertBytesToHex(buff, this.passwordHash).append('\'');
        } else {
            buff.append(" PASSWORD ''");
        }
        if (this.admin) {
            buff.append(" ADMIN");
        }
        return buff.toString();
    }

    boolean validateUserPasswordHash(byte[] userPasswordHash) {
        if (userPasswordHash.length == 0 && this.passwordHash.length == 0) {
            return true;
        }
        if (userPasswordHash.length == 0) {
            userPasswordHash = SHA256.getKeyPasswordHash(this.getName(), new char[0]);
        }
        byte[] hash = SHA256.getHashWithSalt(userPasswordHash, this.salt);
        return Utils.compareSecure(hash, this.passwordHash);
    }

    public void checkAdmin() {
        if (!this.admin) {
            throw DbException.get(90040);
        }
    }

    public void checkSchemaAdmin() {
        if (!this.hasSchemaRight(null)) {
            throw DbException.get(90040);
        }
    }

    public void checkSchemaOwner(Schema schema) {
        if (!this.hasSchemaRight(schema)) {
            throw DbException.get(90096, schema.getTraceSQL());
        }
    }

    private boolean hasSchemaRight(Schema schema) {
        if (this.admin) {
            return true;
        }
        Role publicRole = this.database.getPublicRole();
        if (publicRole.isSchemaRightGrantedRecursive(schema)) {
            return true;
        }
        return this.isSchemaRightGrantedRecursive(schema);
    }

    public void checkTableRight(Table table, int rightMask) {
        if (!this.hasTableRight(table, rightMask)) {
            throw DbException.get(90096, table.getTraceSQL());
        }
    }

    public boolean hasTableRight(Table table, int rightMask) {
        if (rightMask != 1 && !this.systemUser) {
            table.checkWritingAllowed();
        }
        if (this.admin) {
            return true;
        }
        Role publicRole = this.database.getPublicRole();
        if (publicRole.isTableRightGrantedRecursive(table, rightMask)) {
            return true;
        }
        if (table instanceof MetaTable || table instanceof DualTable || table instanceof RangeTable) {
            return true;
        }
        TableType tableType = table.getTableType();
        if (tableType == null) {
            return true;
        }
        if (table.isTemporary() && !table.isGlobalTemporary()) {
            return true;
        }
        return this.isTableRightGrantedRecursive(table, rightMask);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> children = new ArrayList<DbObject>();
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantee() != this) continue;
            children.add(right);
        }
        for (Schema schema : this.database.getAllSchemas()) {
            if (schema.getOwner() != this) continue;
            children.add(schema);
        }
        return children;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantee() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        this.salt = null;
        Arrays.fill(this.passwordHash, (byte)0);
        this.passwordHash = null;
        this.invalidate();
    }
}

