/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.constraint.DomainColumnResolver;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Operation0;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.util.ParserUtil;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DomainValueExpression
extends Operation0 {
    private DomainColumnResolver columnResolver;

    @Override
    public Value getValue(SessionLocal session) {
        return this.columnResolver.getValue(null);
    }

    @Override
    public TypeInfo getType() {
        return this.columnResolver.getValueType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        if (resolver instanceof DomainColumnResolver) {
            this.columnResolver = (DomainColumnResolver)resolver;
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        if (this.columnResolver == null) {
            throw DbException.get(42122, "VALUE");
        }
        return this;
    }

    @Override
    public boolean isValueSet() {
        return this.columnResolver.getValue(null) != null;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        String name;
        if (this.columnResolver != null && (name = this.columnResolver.getColumnName()) != null) {
            return ParserUtil.quoteIdentifier(builder, name, sqlFlags);
        }
        return builder.append("VALUE");
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return true;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

