/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.command.query.Select;
import org.h2.command.query.SelectGroups;
import org.h2.command.query.SelectListColumnResolver;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.mode.ModeFunction;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTinyint;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ExpressionColumn
extends Expression {
    private final Database database;
    private final String schemaName;
    private final String tableAlias;
    private final String columnName;
    private final boolean rowId;
    private final boolean quotedName;
    private ColumnResolver columnResolver;
    private int queryLevel;
    private Column column;

    public ExpressionColumn(Database database, Column column) {
        this.database = database;
        this.column = column;
        this.schemaName = null;
        this.tableAlias = null;
        this.columnName = null;
        this.rowId = column.isRowId();
        this.quotedName = true;
    }

    public ExpressionColumn(Database database, String schemaName, String tableAlias, String columnName) {
        this(database, schemaName, tableAlias, columnName, true);
    }

    public ExpressionColumn(Database database, String schemaName, String tableAlias, String columnName, boolean quotedName) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableAlias = tableAlias;
        this.columnName = columnName;
        this.rowId = false;
        this.quotedName = quotedName;
    }

    public ExpressionColumn(Database database, String schemaName, String tableAlias) {
        this.database = database;
        this.schemaName = schemaName;
        this.tableAlias = tableAlias;
        this.columnName = "_ROWID_";
        this.rowId = true;
        this.quotedName = true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        if (this.schemaName != null) {
            ParserUtil.quoteIdentifier(builder, this.schemaName, sqlFlags).append('.');
        }
        if (this.tableAlias != null) {
            ParserUtil.quoteIdentifier(builder, this.tableAlias, sqlFlags).append('.');
        }
        if (this.column != null) {
            if (this.columnResolver != null && this.columnResolver.hasDerivedColumnList()) {
                ParserUtil.quoteIdentifier(builder, this.columnResolver.getColumnName(this.column), sqlFlags);
            } else {
                this.column.getSQL(builder, sqlFlags);
            }
        } else if (this.rowId) {
            builder.append(this.columnName);
        } else {
            ParserUtil.quoteIdentifier(builder, this.columnName, sqlFlags);
        }
        return builder;
    }

    public TableFilter getTableFilter() {
        return this.columnResolver == null ? null : this.columnResolver.getTableFilter();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        if (this.tableAlias != null && !this.database.equalsIdentifiers(this.tableAlias, resolver.getTableAlias())) {
            return;
        }
        if (this.schemaName != null && !this.database.equalsIdentifiers(this.schemaName, resolver.getSchemaName())) {
            return;
        }
        if (this.rowId) {
            Column col = resolver.getRowIdColumn();
            if (col != null) {
                this.mapColumn(resolver, col, level);
            }
            return;
        }
        Column col = resolver.findColumn(this.columnName);
        if (col != null) {
            this.mapColumn(resolver, col, level);
            return;
        }
        Column[] columns = resolver.getSystemColumns();
        int i = 0;
        while (columns != null && i < columns.length) {
            col = columns[i];
            if (this.database.equalsIdentifiers(this.columnName, col.getName())) {
                this.mapColumn(resolver, col, level);
                return;
            }
            ++i;
        }
    }

    private void mapColumn(ColumnResolver resolver, Column col, int level) {
        if (this.columnResolver == null) {
            this.queryLevel = level;
            this.column = col;
            this.columnResolver = resolver;
        } else if (this.queryLevel == level && this.columnResolver != resolver && !(resolver instanceof SelectListColumnResolver)) {
            throw DbException.get(90059, this.columnName);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        if (this.columnResolver == null) {
            Constant constant;
            Schema schema = session.getDatabase().findSchema(this.tableAlias == null ? session.getCurrentSchemaName() : this.tableAlias);
            if (schema != null && (constant = schema.findConstant(this.columnName)) != null) {
                return constant.getValue();
            }
            return this.optimizeOther();
        }
        return this.columnResolver.optimize(this, this.column);
    }

    private Expression optimizeOther() {
        Expression e;
        if (this.tableAlias == null && !this.quotedName && (e = ModeFunction.getCompatibilityDateTimeValueFunction(this.database, StringUtils.toUpperEnglish(this.columnName), -1)) != null) {
            return e;
        }
        throw this.getColumnException(42122);
    }

    public DbException getColumnException(int code) {
        Object name = this.columnName;
        if (this.tableAlias != null) {
            name = this.schemaName != null ? this.schemaName + "." + this.tableAlias + "." + (String)name : this.tableAlias + "." + (String)name;
        }
        return DbException.get(code, (String)name);
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        Select select = this.columnResolver.getSelect();
        if (select == null) {
            throw DbException.get(90016, this.getTraceSQL());
        }
        if (stage == 0) {
            return;
        }
        SelectGroups groupData = select.getGroupDataIfCurrent(false);
        if (groupData == null) {
            return;
        }
        Value v = (Value)groupData.getCurrentGroupExprData(this);
        if (v == null) {
            groupData.setCurrentGroupExprData(this, this.columnResolver.getValue(this.column));
        } else if (!select.isGroupWindowStage2() && !session.areEqual(this.columnResolver.getValue(this.column), v)) {
            throw DbException.get(90016, this.getTraceSQL());
        }
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value value;
        SelectGroups groupData;
        Select select = this.columnResolver.getSelect();
        if (select != null && (groupData = select.getGroupDataIfCurrent(false)) != null) {
            Value v = (Value)groupData.getCurrentGroupExprData(this);
            if (v != null) {
                return v;
            }
            if (select.isGroupWindowStage2()) {
                throw DbException.get(90016, this.getTraceSQL());
            }
        }
        if ((value = this.columnResolver.getValue(this.column)) == null) {
            if (select == null) {
                throw DbException.get(23502, this.getTraceSQL());
            }
            throw DbException.get(90016, this.getTraceSQL());
        }
        return value;
    }

    @Override
    public TypeInfo getType() {
        return this.column != null ? this.column.getType() : (this.rowId ? TypeInfo.TYPE_BIGINT : TypeInfo.TYPE_UNKNOWN);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
    }

    public Column getColumn() {
        return this.column;
    }

    public String getOriginalColumnName() {
        return this.columnName;
    }

    public String getOriginalTableAliasName() {
        return this.tableAlias;
    }

    @Override
    public String getColumnName(SessionLocal session, int columnIndex) {
        if (this.column != null) {
            if (this.columnResolver != null) {
                return this.columnResolver.getColumnName(this.column);
            }
            return this.column.getName();
        }
        return this.columnName;
    }

    @Override
    public String getSchemaName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getSchema().getName();
    }

    @Override
    public String getTableName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getName();
    }

    @Override
    public String getAlias(SessionLocal session, int columnIndex) {
        if (this.column != null) {
            if (this.columnResolver != null) {
                return this.columnResolver.getColumnName(this.column);
            }
            return this.column.getName();
        }
        if (this.tableAlias != null) {
            return this.tableAlias + "." + this.columnName;
        }
        return this.columnName;
    }

    @Override
    public String getColumnNameForView(SessionLocal session, int columnIndex) {
        return this.getAlias(session, columnIndex);
    }

    @Override
    public boolean isIdentity() {
        return this.column.isIdentity();
    }

    @Override
    public int getNullable() {
        return this.column.isNullable() ? 1 : 0;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 1: {
                return false;
            }
            case 0: {
                return this.queryLevel < visitor.getQueryLevel();
            }
            case 3: {
                if (visitor.getQueryLevel() < this.queryLevel) {
                    return true;
                }
                if (this.getTableFilter() == null) {
                    return false;
                }
                return this.getTableFilter().isEvaluatable();
            }
            case 4: {
                visitor.addDataModificationId(this.column.getTable().getMaxDataModificationId());
                return true;
            }
            case 6: {
                return this.columnResolver != visitor.getResolver();
            }
            case 7: {
                if (this.column != null) {
                    visitor.addDependency(this.column.getTable());
                }
                return true;
            }
            case 9: {
                if (this.column == null) {
                    throw DbException.get(42122, this.getTraceSQL());
                }
                visitor.addColumn1(this.column);
                return true;
            }
            case 10: {
                if (this.column == null) {
                    throw DbException.get(42122, this.getTraceSQL());
                }
                visitor.addColumn2(this.column);
                return true;
            }
            case 11: {
                if (this.column == null) {
                    throw DbException.get(42122, this.getTraceSQL());
                }
                if (!visitor.getColumnResolvers().contains(this.columnResolver)) break;
                int decrement = visitor.getQueryLevel();
                if (decrement > 0) {
                    if (this.queryLevel > 0) {
                        --this.queryLevel;
                        return true;
                    }
                    throw DbException.getInternalError("queryLevel=0");
                }
                return this.queryLevel > 0;
            }
        }
        return true;
    }

    @Override
    public int getCost() {
        return 2;
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        TableFilter tf = this.getTableFilter();
        if (filter == tf && this.column.getType().getValueType() == 8) {
            filter.addIndexCondition(IndexCondition.get(0, this, ValueExpression.TRUE));
        }
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        Value v;
        Expression o = this.optimize(session);
        if (o != this) {
            return o.getNotIfPossible(session);
        }
        switch (this.column.getType().getValueType()) {
            case 8: {
                v = ValueBoolean.FALSE;
                break;
            }
            case 9: {
                v = ValueTinyint.get((byte)0);
                break;
            }
            case 10: {
                v = ValueSmallint.get((short)0);
                break;
            }
            case 11: {
                v = ValueInteger.get(0);
                break;
            }
            case 12: {
                v = ValueBigint.get(0L);
                break;
            }
            case 13: {
                v = ValueNumeric.ZERO;
                break;
            }
            case 14: {
                v = ValueReal.ZERO;
                break;
            }
            case 15: {
                v = ValueDouble.ZERO;
                break;
            }
            case 16: {
                v = ValueDecfloat.ZERO;
                break;
            }
            default: {
                return null;
            }
        }
        return new Comparison(0, this, ValueExpression.get(v), false);
    }
}

