/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Operation2;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.DateTimeFunction;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.IntervalUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueInterval;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestampTimeZone;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IntervalOperation
extends Operation2 {
    private static final int INTERVAL_YEAR_DIGITS = 20;
    private static final int INTERVAL_DAY_DIGITS = 32;
    private static final TypeInfo INTERVAL_DIVIDE_INTERVAL_YEAR_TYPE = TypeInfo.getTypeInfo(13, 60L, 40, null);
    private static final TypeInfo INTERVAL_DIVIDE_INTERVAL_DAY_TYPE = TypeInfo.getTypeInfo(13, 96L, 64, null);
    private final IntervalOpType opType;
    private TypeInfo forcedType;

    private static BigInteger nanosFromValue(SessionLocal session, Value v) {
        long[] a = DateTimeUtils.dateAndTimeFromValue(v, session);
        return BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(a[0])).multiply(IntervalUtils.NANOS_PER_DAY_BI).add(BigInteger.valueOf(a[1]));
    }

    public IntervalOperation(IntervalOpType opType, Expression left, Expression right, TypeInfo forcedType) {
        this(opType, left, right);
        this.forcedType = forcedType;
    }

    public IntervalOperation(IntervalOpType opType, Expression left, Expression right) {
        super(left, right);
        this.opType = opType;
        int l = left.getType().getValueType();
        int r = right.getType().getValueType();
        switch (opType) {
            case INTERVAL_PLUS_INTERVAL: 
            case INTERVAL_MINUS_INTERVAL: {
                this.type = TypeInfo.getTypeInfo(Value.getHigherOrder(l, r));
                break;
            }
            case INTERVAL_DIVIDE_INTERVAL: {
                this.type = DataType.isYearMonthIntervalType(l) ? INTERVAL_DIVIDE_INTERVAL_YEAR_TYPE : INTERVAL_DIVIDE_INTERVAL_DAY_TYPE;
                break;
            }
            case DATETIME_PLUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: 
            case INTERVAL_MULTIPLY_NUMERIC: 
            case INTERVAL_DIVIDE_NUMERIC: {
                this.type = left.getType();
                break;
            }
            case DATETIME_MINUS_DATETIME: {
                this.type = this.forcedType != null ? this.forcedType : (!(l != 18 && l != 19 || r != 18 && r != 19) ? TypeInfo.TYPE_INTERVAL_HOUR_TO_SECOND : (l == 17 && r == 17 ? TypeInfo.TYPE_INTERVAL_DAY : TypeInfo.TYPE_INTERVAL_DAY_TO_SECOND));
            }
        }
    }

    @Override
    public boolean needParentheses() {
        return this.forcedType == null;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        if (this.forcedType != null) {
            this.getInnerSQL2(builder.append('('), sqlFlags);
            IntervalOperation.getForcedTypeSQL(builder.append(") "), this.forcedType);
        } else {
            this.getInnerSQL2(builder, sqlFlags);
        }
        return builder;
    }

    private void getInnerSQL2(StringBuilder builder, int sqlFlags) {
        this.left.getSQL(builder, sqlFlags, 0).append(' ').append(this.getOperationToken()).append(' ');
        this.right.getSQL(builder, sqlFlags, 0);
    }

    static StringBuilder getForcedTypeSQL(StringBuilder builder, TypeInfo forcedType) {
        int precision = (int)forcedType.getPrecision();
        int scale = forcedType.getScale();
        return IntervalQualifier.valueOf(forcedType.getValueType() - 22).getTypeName(builder, precision == 2 ? -1 : precision, scale == 6 ? -1 : scale, true);
    }

    private char getOperationToken() {
        switch (this.opType) {
            case INTERVAL_PLUS_INTERVAL: 
            case DATETIME_PLUS_INTERVAL: {
                return '+';
            }
            case INTERVAL_MINUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: 
            case DATETIME_MINUS_DATETIME: {
                return '-';
            }
            case INTERVAL_MULTIPLY_NUMERIC: {
                return '*';
            }
            case INTERVAL_DIVIDE_INTERVAL: 
            case INTERVAL_DIVIDE_NUMERIC: {
                return '/';
            }
        }
        throw DbException.getInternalError("opType=" + String.valueOf((Object)this.opType));
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.left.getValue(session);
        Value r = this.right.getValue(session);
        if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        int lType = l.getValueType();
        int rType = r.getValueType();
        switch (this.opType) {
            case INTERVAL_PLUS_INTERVAL: 
            case INTERVAL_MINUS_INTERVAL: {
                BigInteger a1 = IntervalUtils.intervalToAbsolute((ValueInterval)l);
                BigInteger a2 = IntervalUtils.intervalToAbsolute((ValueInterval)r);
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(Value.getHigherOrder(lType, rType) - 22), this.opType == IntervalOpType.INTERVAL_PLUS_INTERVAL ? a1.add(a2) : a1.subtract(a2));
            }
            case INTERVAL_DIVIDE_INTERVAL: {
                return ValueNumeric.get(IntervalUtils.intervalToAbsolute((ValueInterval)l)).divide(ValueNumeric.get(IntervalUtils.intervalToAbsolute((ValueInterval)r)), this.type);
            }
            case DATETIME_PLUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: {
                return this.getDateTimeWithInterval(session, l, r, lType, rType);
            }
            case INTERVAL_MULTIPLY_NUMERIC: 
            case INTERVAL_DIVIDE_NUMERIC: {
                BigDecimal a1 = new BigDecimal(IntervalUtils.intervalToAbsolute((ValueInterval)l));
                BigDecimal a2 = r.getBigDecimal();
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(lType - 22), (this.opType == IntervalOpType.INTERVAL_MULTIPLY_NUMERIC ? a1.multiply(a2) : a1.divide(a2)).toBigInteger());
            }
            case DATETIME_MINUS_DATETIME: {
                Value result;
                if (!(lType != 18 && lType != 19 || rType != 18 && rType != 19)) {
                    boolean negative;
                    long diff;
                    if (lType == 18 && rType == 18) {
                        diff = ((ValueTime)l).getNanos() - ((ValueTime)r).getNanos();
                    } else {
                        ValueTimeTimeZone left = (ValueTimeTimeZone)l.convertTo(TypeInfo.TYPE_TIME_TZ, (CastDataProvider)session);
                        ValueTimeTimeZone right = (ValueTimeTimeZone)r.convertTo(TypeInfo.TYPE_TIME_TZ, (CastDataProvider)session);
                        diff = left.getNanos() - right.getNanos() + (long)(right.getTimeZoneOffsetSeconds() - left.getTimeZoneOffsetSeconds()) * 1000000000L;
                    }
                    boolean bl = negative = diff < 0L;
                    if (negative) {
                        diff = -diff;
                    }
                    result = ValueInterval.from(IntervalQualifier.HOUR_TO_SECOND, negative, diff / 3600000000000L, diff % 3600000000000L);
                } else if (this.forcedType != null && DataType.isYearMonthIntervalType(this.forcedType.getValueType())) {
                    boolean negative;
                    long[] dt1 = DateTimeUtils.dateAndTimeFromValue(l, session);
                    long[] dt2 = DateTimeUtils.dateAndTimeFromValue(r, session);
                    long dateValue1 = lType == 18 || lType == 19 ? session.currentTimestamp().getDateValue() : dt1[0];
                    long dateValue2 = rType == 18 || rType == 19 ? session.currentTimestamp().getDateValue() : dt2[0];
                    long leading = 12L * (long)(DateTimeUtils.yearFromDateValue(dateValue1) - DateTimeUtils.yearFromDateValue(dateValue2)) + (long)DateTimeUtils.monthFromDateValue(dateValue1) - (long)DateTimeUtils.monthFromDateValue(dateValue2);
                    int d1 = DateTimeUtils.dayFromDateValue(dateValue1);
                    int d2 = DateTimeUtils.dayFromDateValue(dateValue2);
                    if (leading >= 0L) {
                        if (d1 < d2 || d1 == d2 && dt1[1] < dt2[1]) {
                            --leading;
                        }
                    } else if (d1 > d2 || d1 == d2 && dt1[1] > dt2[1]) {
                        ++leading;
                    }
                    if (leading < 0L) {
                        negative = true;
                        leading = -leading;
                    } else {
                        negative = false;
                    }
                    result = ValueInterval.from(IntervalQualifier.MONTH, negative, leading, 0L);
                } else if (lType == 17 && rType == 17) {
                    boolean negative;
                    long diff = DateTimeUtils.absoluteDayFromDateValue(((ValueDate)l).getDateValue()) - DateTimeUtils.absoluteDayFromDateValue(((ValueDate)r).getDateValue());
                    boolean bl = negative = diff < 0L;
                    if (negative) {
                        diff = -diff;
                    }
                    result = ValueInterval.from(IntervalQualifier.DAY, negative, diff, 0L);
                } else {
                    BigInteger diff = IntervalOperation.nanosFromValue(session, l).subtract(IntervalOperation.nanosFromValue(session, r));
                    if (lType == 21 || rType == 21) {
                        l = l.convertTo(TypeInfo.TYPE_TIMESTAMP_TZ, (CastDataProvider)session);
                        r = r.convertTo(TypeInfo.TYPE_TIMESTAMP_TZ, (CastDataProvider)session);
                        diff = diff.add(BigInteger.valueOf((long)(((ValueTimestampTimeZone)r).getTimeZoneOffsetSeconds() - ((ValueTimestampTimeZone)l).getTimeZoneOffsetSeconds()) * 1000000000L));
                    }
                    result = IntervalUtils.intervalFromAbsolute(IntervalQualifier.DAY_TO_SECOND, diff);
                }
                if (this.forcedType != null) {
                    result = result.castTo(this.forcedType, session);
                }
                return result;
            }
        }
        throw DbException.getInternalError("type=" + String.valueOf((Object)this.opType));
    }

    private Value getDateTimeWithInterval(SessionLocal session, Value l, Value r, int lType, int rType) {
        switch (lType) {
            case 18: {
                if (DataType.isYearMonthIntervalType(rType)) {
                    throw DbException.getInternalError("type=" + rType);
                }
                return ValueTime.fromNanos(this.getTimeWithInterval(r, ((ValueTime)l).getNanos()));
            }
            case 19: {
                if (DataType.isYearMonthIntervalType(rType)) {
                    throw DbException.getInternalError("type=" + rType);
                }
                ValueTimeTimeZone t = (ValueTimeTimeZone)l;
                return ValueTimeTimeZone.fromNanos(this.getTimeWithInterval(r, t.getNanos()), t.getTimeZoneOffsetSeconds());
            }
            case 17: 
            case 20: 
            case 21: {
                if (DataType.isYearMonthIntervalType(rType)) {
                    long m = IntervalUtils.intervalToAbsolute((ValueInterval)r).longValue();
                    if (this.opType == IntervalOpType.DATETIME_MINUS_INTERVAL) {
                        m = -m;
                    }
                    return DateTimeFunction.dateadd(session, 1, m, l);
                }
                BigInteger a2 = IntervalUtils.intervalToAbsolute((ValueInterval)r);
                if (lType == 17) {
                    BigInteger a1 = BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(((ValueDate)l).getDateValue()));
                    a2 = a2.divide(IntervalUtils.NANOS_PER_DAY_BI);
                    BigInteger n = this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL ? a1.add(a2) : a1.subtract(a2);
                    return ValueDate.fromDateValue(DateTimeUtils.dateValueFromAbsoluteDay(n.longValue()));
                }
                long[] a = DateTimeUtils.dateAndTimeFromValue(l, session);
                long absoluteDay = DateTimeUtils.absoluteDayFromDateValue(a[0]);
                long timeNanos = a[1];
                BigInteger[] dr = a2.divideAndRemainder(IntervalUtils.NANOS_PER_DAY_BI);
                if (this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL) {
                    absoluteDay += dr[0].longValue();
                    timeNanos += dr[1].longValue();
                } else {
                    absoluteDay -= dr[0].longValue();
                    timeNanos -= dr[1].longValue();
                }
                if (timeNanos >= 86400000000000L) {
                    timeNanos -= 86400000000000L;
                    ++absoluteDay;
                } else if (timeNanos < 0L) {
                    timeNanos += 86400000000000L;
                    --absoluteDay;
                }
                return DateTimeUtils.dateTimeToValue(l, DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), timeNanos);
            }
        }
        throw DbException.getInternalError("type=" + String.valueOf((Object)this.opType));
    }

    private long getTimeWithInterval(Value r, long nanos) {
        BigInteger n;
        BigInteger a1 = BigInteger.valueOf(nanos);
        BigInteger a2 = IntervalUtils.intervalToAbsolute((ValueInterval)r);
        BigInteger bigInteger = n = this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL ? a1.add(a2) : a1.subtract(a2);
        if (n.signum() < 0 || n.compareTo(IntervalUtils.NANOS_PER_DAY_BI) >= 0) {
            throw DbException.get(22003, n.toString());
        }
        nanos = n.longValue();
        return nanos;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum IntervalOpType {
        INTERVAL_PLUS_INTERVAL,
        INTERVAL_MINUS_INTERVAL,
        INTERVAL_DIVIDE_INTERVAL,
        DATETIME_PLUS_INTERVAL,
        DATETIME_MINUS_INTERVAL,
        INTERVAL_MULTIPLY_NUMERIC,
        INTERVAL_DIVIDE_NUMERIC,
        DATETIME_MINUS_DATETIME;

    }
}

