/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Arrays;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ExpressionWithVariableParameters;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class OperationN
extends Expression
implements ExpressionWithVariableParameters {
    protected Expression[] args;
    protected int argsCount;
    protected TypeInfo type;

    protected OperationN(Expression[] args) {
        this.args = args;
    }

    @Override
    public void addParameter(Expression param) {
        int capacity = this.args.length;
        if (this.argsCount >= capacity) {
            this.args = Arrays.copyOf(this.args, capacity * 2);
        }
        this.args[this.argsCount++] = param;
    }

    @Override
    public void doneWithParameters() throws DbException {
        if (this.args.length != this.argsCount) {
            this.args = Arrays.copyOf(this.args, this.argsCount);
        }
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            e.mapColumns(resolver, level, state);
            ++n2;
        }
    }

    protected boolean optimizeArguments(SessionLocal session, boolean allConst) {
        int i = 0;
        int l = this.args.length;
        while (i < l) {
            Expression e;
            this.args[i] = e = this.args[i].optimize(session);
            if (allConst && !e.isConstant()) {
                allConst = false;
            }
            ++i;
        }
        return allConst;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean value) {
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            e.setEvaluatable(tableFilter, value);
            ++n2;
        }
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            e.updateAggregate(session, stage);
            ++n2;
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (!e.isEverything(visitor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = this.args.length + 1;
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            cost += e.getCost();
            ++n2;
        }
        return cost;
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.args[index];
    }
}

