/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.OperationN;
import org.h2.expression.SimpleCase;
import org.h2.expression.ValueExpression;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SearchedCase
extends OperationN {
    public SearchedCase() {
        super(new Expression[4]);
    }

    public SearchedCase(Expression[] args) {
        super(args);
    }

    @Override
    public Value getValue(SessionLocal session) {
        int len = this.args.length - 1;
        int i = 0;
        while (i < len) {
            if (this.args[i].getBooleanValue(session)) {
                return this.args[i + 1].getValue(session).convertTo(this.type, (CastDataProvider)session);
            }
            i += 2;
        }
        if ((len & 1) == 0) {
            return this.args[len].getValue(session).convertTo(this.type, (CastDataProvider)session);
        }
        return ValueNull.INSTANCE;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        TypeInfo typeInfo = TypeInfo.TYPE_UNKNOWN;
        int len = this.args.length - 1;
        boolean allConst = true;
        int i = 0;
        while (i < len) {
            Expression condition = this.args[i].optimize(session);
            Expression result = this.args[i + 1].optimize(session);
            if (allConst) {
                if (condition.isConstant()) {
                    if (condition.getBooleanValue(session)) {
                        return result;
                    }
                } else {
                    allConst = false;
                }
            }
            this.args[i] = condition;
            this.args[i + 1] = result;
            typeInfo = SimpleCase.combineTypes(typeInfo, result);
            i += 2;
        }
        if ((len & 1) == 0) {
            Expression result = this.args[len].optimize(session);
            if (allConst) {
                return result;
            }
            this.args[len] = result;
            typeInfo = SimpleCase.combineTypes(typeInfo, result);
        } else if (allConst) {
            return ValueExpression.NULL;
        }
        if (typeInfo.getValueType() == -1) {
            typeInfo = TypeInfo.TYPE_VARCHAR;
        }
        this.type = typeInfo;
        return this;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        builder.append("CASE");
        int len = this.args.length - 1;
        int i = 0;
        while (i < len) {
            builder.append(" WHEN ");
            this.args[i].getUnenclosedSQL(builder, sqlFlags);
            builder.append(" THEN ");
            this.args[i + 1].getUnenclosedSQL(builder, sqlFlags);
            i += 2;
        }
        if ((len & 1) == 0) {
            builder.append(" ELSE ");
            this.args[len].getUnenclosedSQL(builder, sqlFlags);
        }
        return builder.append(" END");
    }
}

