/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.util.ArrayList;
import java.util.Random;
import org.h2.engine.SessionLocal;
import org.h2.expression.aggregate.AggregateData;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AggregateDataAnyValue
extends AggregateData {
    private static final int MAX_VALUES = 256;
    ArrayList<Value> values = new ArrayList();
    private long filter = -1L;

    AggregateDataAnyValue() {
    }

    @Override
    void add(SessionLocal session, Value v) {
        if (v == ValueNull.INSTANCE) {
            return;
        }
        long filter = this.filter;
        if (filter == Long.MIN_VALUE || (session.getRandom().nextLong() | filter) == filter) {
            this.values.add(v);
            if (this.values.size() == 256) {
                this.compact(session);
            }
        }
    }

    private void compact(SessionLocal session) {
        this.filter <<= 1;
        Random random = session.getRandom();
        int s = 0;
        int t = 0;
        while (t < 128) {
            int idx = s;
            if (random.nextBoolean()) {
                ++idx;
            }
            this.values.set(t, this.values.get(idx));
            s += 2;
            ++t;
        }
        this.values.subList(128, 256).clear();
    }

    @Override
    Value getValue(SessionLocal session) {
        int count = this.values.size();
        if (count == 0) {
            return ValueNull.INSTANCE;
        }
        return this.values.get(session.getRandom().nextInt(count));
    }
}

