/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.h2.api.IntervalQualifier;
import org.h2.engine.SessionLocal;
import org.h2.expression.aggregate.AggregateData;
import org.h2.util.IntervalUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInterval;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AggregateDataAvg
extends AggregateData {
    private final TypeInfo dataType;
    private long count;
    private double doubleValue;
    private BigDecimal decimalValue;
    private BigInteger integerValue;

    AggregateDataAvg(TypeInfo dataType) {
        this.dataType = dataType;
    }

    @Override
    void add(SessionLocal session, Value v) {
        if (v == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        switch (this.dataType.getValueType()) {
            case 15: {
                this.doubleValue += v.getDouble();
                break;
            }
            case 13: 
            case 16: {
                BigDecimal bd = v.getBigDecimal();
                this.decimalValue = this.decimalValue == null ? bd : this.decimalValue.add(bd);
                break;
            }
            default: {
                BigInteger bi = IntervalUtils.intervalToAbsolute((ValueInterval)v);
                this.integerValue = this.integerValue == null ? bi : this.integerValue.add(bi);
            }
        }
    }

    @Override
    Value getValue(SessionLocal session) {
        Value v;
        if (this.count == 0L) {
            return ValueNull.INSTANCE;
        }
        int valueType = this.dataType.getValueType();
        switch (valueType) {
            case 15: {
                v = ValueDouble.get(this.doubleValue / (double)this.count);
                break;
            }
            case 13: {
                v = ValueNumeric.get(this.decimalValue.divide(BigDecimal.valueOf(this.count), this.dataType.getScale(), RoundingMode.HALF_DOWN));
                break;
            }
            case 16: {
                v = ValueDecfloat.divide(this.decimalValue, BigDecimal.valueOf(this.count), this.dataType);
                break;
            }
            default: {
                v = IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(valueType - 22), this.integerValue.divide(BigInteger.valueOf(this.count)));
            }
        }
        return v.castTo(this.dataType, session);
    }
}

