/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.h2.engine.SessionLocal;
import org.h2.expression.aggregate.AggregateData;
import org.h2.message.DbException;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AggregateDataCollecting
extends AggregateData
implements Iterable<Value> {
    private final boolean distinct;
    private final boolean orderedWithOrder;
    private final NullCollectionMode nullCollectionMode;
    Collection<Value> values;
    private Value shared;

    AggregateDataCollecting(boolean distinct, boolean orderedWithOrder, NullCollectionMode nullCollectionMode) {
        this.distinct = distinct;
        this.orderedWithOrder = orderedWithOrder;
        this.nullCollectionMode = nullCollectionMode;
    }

    @Override
    void add(SessionLocal session, Value v) {
        if (this.nullCollectionMode == NullCollectionMode.IGNORED && this.isNull(v)) {
            return;
        }
        Collection<Value> c = this.values;
        if (c == null) {
            if (this.distinct) {
                Comparator<Value> comparator = session.getDatabase().getCompareMode();
                if (this.orderedWithOrder) {
                    comparator = Comparator.comparing(t -> ((ValueRow)t).getList()[0], comparator);
                }
                c = new TreeSet<Value>(comparator);
            } else {
                c = new ArrayList<Value>();
            }
            this.values = c;
        }
        if (this.nullCollectionMode == NullCollectionMode.EXCLUDED && this.isNull(v)) {
            return;
        }
        c.add(v);
    }

    private boolean isNull(Value v) {
        return (this.orderedWithOrder ? ((ValueRow)v).getList()[0] : v) == ValueNull.INSTANCE;
    }

    @Override
    Value getValue(SessionLocal session) {
        return null;
    }

    int getCount() {
        return this.values != null ? this.values.size() : 0;
    }

    Value[] getArray() {
        Collection<Value> values = this.values;
        if (values == null) {
            return null;
        }
        return values.toArray(Value.EMPTY_VALUES);
    }

    @Override
    public Iterator<Value> iterator() {
        return this.values != null ? this.values.iterator() : Collections.emptyIterator();
    }

    void setSharedArgument(Value shared) {
        if (this.shared == null) {
            this.shared = shared;
        } else if (!this.shared.equals(shared)) {
            throw DbException.get(90008, "Inverse distribution function argument", this.shared.getTraceSQL() + "<>" + shared.getTraceSQL());
        }
    }

    Value getSharedArgument() {
        return this.shared;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum NullCollectionMode {
        IGNORED,
        EXCLUDED,
        USED_OR_IMPOSSIBLE;

    }
}

