/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import org.h2.engine.SessionLocal;
import org.h2.expression.aggregate.AggregateData;
import org.h2.expression.aggregate.AggregateType;
import org.h2.expression.function.BitFunction;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AggregateDataDefault
extends AggregateData {
    private final AggregateType aggregateType;
    private final TypeInfo dataType;
    private Value value;

    AggregateDataDefault(AggregateType aggregateType, TypeInfo dataType) {
        this.aggregateType = aggregateType;
        this.dataType = dataType;
    }

    @Override
    void add(SessionLocal session, Value v) {
        if (v == ValueNull.INSTANCE) {
            return;
        }
        switch (this.aggregateType) {
            case SUM: {
                if (this.value == null) {
                    this.value = v.convertTo(this.dataType.getValueType());
                    break;
                }
                v = v.convertTo(this.value.getValueType());
                this.value = this.value.add(v);
                break;
            }
            case MIN: {
                if (this.value != null && session.compare(v, this.value) >= 0) break;
                this.value = v;
                break;
            }
            case MAX: {
                if (this.value != null && session.compare(v, this.value) <= 0) break;
                this.value = v;
                break;
            }
            case EVERY: {
                v = v.convertToBoolean();
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() && v.getBoolean());
                break;
            }
            case ANY: {
                v = v.convertToBoolean();
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() || v.getBoolean());
                break;
            }
            case BIT_AND_AGG: 
            case BIT_NAND_AGG: {
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = BitFunction.getBitwise(0, this.dataType, this.value, v);
                break;
            }
            case BIT_OR_AGG: 
            case BIT_NOR_AGG: {
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = BitFunction.getBitwise(1, this.dataType, this.value, v);
                break;
            }
            case BIT_XOR_AGG: 
            case BIT_XNOR_AGG: {
                if (this.value == null) {
                    this.value = v;
                    break;
                }
                this.value = BitFunction.getBitwise(2, this.dataType, this.value, v);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + String.valueOf((Object)this.aggregateType));
            }
        }
    }

    @Override
    Value getValue(SessionLocal session) {
        Value v = this.value;
        if (v == null) {
            return ValueNull.INSTANCE;
        }
        switch (this.aggregateType) {
            case BIT_NAND_AGG: 
            case BIT_NOR_AGG: 
            case BIT_XNOR_AGG: {
                v = BitFunction.getBitwise(3, this.dataType, v, null);
            }
        }
        return v.convertTo(this.dataType);
    }
}

