/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.util.TreeMap;
import org.h2.engine.SessionLocal;
import org.h2.expression.aggregate.AggregateData;
import org.h2.expression.aggregate.LongDataCounter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AggregateDataDistinctWithCounts
extends AggregateData {
    private final boolean ignoreNulls;
    private final int maxDistinctCount;
    private TreeMap<Value, LongDataCounter> values;

    AggregateDataDistinctWithCounts(boolean ignoreNulls, int maxDistinctCount) {
        this.ignoreNulls = ignoreNulls;
        this.maxDistinctCount = maxDistinctCount;
    }

    @Override
    void add(SessionLocal session, Value v) {
        LongDataCounter a;
        if (this.ignoreNulls && v == ValueNull.INSTANCE) {
            return;
        }
        if (this.values == null) {
            this.values = new TreeMap(session.getDatabase().getCompareMode());
        }
        if ((a = this.values.get(v)) == null) {
            if (this.values.size() >= this.maxDistinctCount) {
                return;
            }
            a = new LongDataCounter();
            this.values.put(v, a);
        }
        ++a.count;
    }

    @Override
    Value getValue(SessionLocal session) {
        return null;
    }

    TreeMap<Value, LongDataCounter> getValues() {
        return this.values;
    }
}

