/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CoalesceFunction
extends FunctionN {
    public static final int COALESCE = 0;
    public static final int GREATEST = 1;
    public static final int LEAST = 2;
    private static final String[] NAMES = new String[]{"COALESCE", "GREATEST", "LEAST"};
    private final int function;
    private boolean ignoreNulls;

    public CoalesceFunction(int function) {
        this(function, new Expression[4]);
    }

    public CoalesceFunction(int function, Expression ... args) {
        super(args);
        this.function = function;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v;
        block0 : switch (this.function) {
            case 0: {
                v = ValueNull.INSTANCE;
                int i = 0;
                int l = this.args.length;
                while (i < l) {
                    Value v2 = this.args[i].getValue(session);
                    if (v2 != ValueNull.INSTANCE) {
                        v = v2.convertTo(this.type, (CastDataProvider)session);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 1: 
            case 2: {
                v = this.greatestOrLeast(session);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v;
    }

    private Value greatestOrLeast(SessionLocal session) {
        Value v = ValueNull.INSTANCE;
        Value x = null;
        int i = 0;
        int l = this.args.length;
        while (i < l) {
            Value v2 = this.args[i].getValue(session);
            if (v2 != ValueNull.INSTANCE) {
                int comp;
                v2 = v2.convertTo(this.type, (CastDataProvider)session);
                if (v == ValueNull.INSTANCE) {
                    if (x == null) {
                        v = v2;
                    } else {
                        comp = session.compareWithNull(x, v2, false);
                        if (comp == Integer.MIN_VALUE) {
                            x = CoalesceFunction.getWithNull(x, v2);
                        } else if (this.test(comp)) {
                            v = v2;
                            x = null;
                        }
                    }
                } else {
                    comp = session.compareWithNull(v, v2, false);
                    if (comp == Integer.MIN_VALUE) {
                        if (i + 1 == l) {
                            return ValueNull.INSTANCE;
                        }
                        x = CoalesceFunction.getWithNull(v, v2);
                        v = ValueNull.INSTANCE;
                    } else if (this.test(comp)) {
                        v = v2;
                    }
                }
            } else if (!this.ignoreNulls) {
                return ValueNull.INSTANCE;
            }
            ++i;
        }
        return v;
    }

    private static Value getWithNull(Value v, Value v2) {
        Value x = v.getValueWithFirstNull(v2);
        return x != null ? x : v;
    }

    private boolean test(int comp) {
        return this.function == 1 ? comp < 0 : comp > 0;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        this.type = TypeInfo.getHigherType(this.args);
        if (this.type.getValueType() <= 0) {
            this.type = TypeInfo.TYPE_VARCHAR;
        }
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        super.getUnenclosedSQL(builder, sqlFlags);
        if (this.function == 1 || this.function == 2) {
            builder.append(this.ignoreNulls ? " IGNORE NULLS" : " RESPECT NULLS");
        }
        return builder;
    }
}

