/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ConcatFunction
extends FunctionN {
    public static final int CONCAT = 0;
    public static final int CONCAT_WS = 1;
    private static final String[] NAMES = new String[]{"CONCAT", "CONCAT_WS"};
    private final int function;

    public ConcatFunction(int function) {
        this(function, new Expression[4]);
    }

    public ConcatFunction(int function, Expression ... args) {
        super(args);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        int i = 0;
        String separator = null;
        if (this.function == 1) {
            i = 1;
            separator = this.args[0].getValue(session).getString();
        }
        StringBuilder builder = new StringBuilder();
        boolean f = false;
        int l = this.args.length;
        while (i < l) {
            Value v = this.args[i].getValue(session);
            if (v != ValueNull.INSTANCE) {
                if (separator != null) {
                    if (f) {
                        builder.append(separator);
                    }
                    f = true;
                }
                builder.append(v.getString());
            }
            ++i;
        }
        return ValueVarchar.get(builder.toString(), session);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        int i = 0;
        long extra = 0L;
        if (this.function == 1) {
            i = 1;
            extra = this.getPrecision(0);
        }
        long precision = 0L;
        int l = this.args.length;
        boolean f = false;
        while (i < l) {
            if (!this.args[i].isNullConstant()) {
                precision = DataType.addPrecision(precision, this.getPrecision(i));
                if (extra != 0L && f) {
                    precision = DataType.addPrecision(precision, extra);
                }
                f = true;
            }
            ++i;
        }
        this.type = TypeInfo.getTypeInfo(2, precision, 0, null);
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    private long getPrecision(int i) {
        TypeInfo t = this.args[i].getType();
        int valueType = t.getValueType();
        if (valueType == 0) {
            return 0L;
        }
        if (DataType.isCharacterStringType(valueType)) {
            return t.getPrecision();
        }
        return Long.MAX_VALUE;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

