/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.schema.Constant;
import org.h2.schema.Domain;
import org.h2.schema.FunctionAlias;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueToObjectConverter2;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DataTypeSQLFunction
extends FunctionN {
    public DataTypeSQLFunction(Expression objectSchema, Expression objectName, Expression objectType, Expression typeIdentifier) {
        super(new Expression[]{objectSchema, objectName, objectType, typeIdentifier});
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2, Value v3) {
        TypeInfo t;
        Schema schema = session.getDatabase().findSchema(v1.getString());
        if (schema == null) {
            return ValueNull.INSTANCE;
        }
        String objectName = v2.getString();
        String objectType = v3.getString();
        String typeIdentifier = this.args[3].getValue(session).getString();
        if (typeIdentifier == null) {
            return ValueNull.INSTANCE;
        }
        switch (objectType) {
            case "CONSTANT": {
                Constant constant = schema.findConstant(objectName);
                if (constant == null || !typeIdentifier.equals("TYPE")) {
                    return ValueNull.INSTANCE;
                }
                t = constant.getValue().getType();
                break;
            }
            case "DOMAIN": {
                Domain domain = schema.findDomain(objectName);
                if (domain == null || !typeIdentifier.equals("TYPE")) {
                    return ValueNull.INSTANCE;
                }
                t = domain.getDataType();
                break;
            }
            case "ROUTINE": {
                Class<?>[] columnList;
                FunctionAlias.JavaMethod[] methods;
                int ordinal;
                int idx = objectName.lastIndexOf(95);
                if (idx < 0) {
                    return ValueNull.INSTANCE;
                }
                FunctionAlias function = schema.findFunction(objectName.substring(0, idx));
                if (function == null) {
                    return ValueNull.INSTANCE;
                }
                try {
                    ordinal = Integer.parseInt(objectName.substring(idx + 1));
                }
                catch (NumberFormatException e) {
                    return ValueNull.INSTANCE;
                }
                try {
                    methods = function.getJavaMethods();
                }
                catch (DbException e) {
                    return ValueNull.INSTANCE;
                }
                if (ordinal < 1 || ordinal > methods.length) {
                    return ValueNull.INSTANCE;
                }
                FunctionAlias.JavaMethod method = methods[ordinal - 1];
                if (typeIdentifier.equals("RESULT")) {
                    t = method.getDataType();
                    break;
                }
                try {
                    ordinal = Integer.parseInt(typeIdentifier);
                }
                catch (NumberFormatException e) {
                    return ValueNull.INSTANCE;
                }
                if (ordinal < 1) {
                    return ValueNull.INSTANCE;
                }
                if (!method.hasConnectionParam()) {
                    --ordinal;
                }
                if (ordinal >= (columnList = method.getColumnClasses()).length) {
                    return ValueNull.INSTANCE;
                }
                t = ValueToObjectConverter2.classToType(columnList[ordinal]);
                break;
            }
            case "TABLE": {
                int ordinal;
                Table table = schema.findTableOrView(session, objectName);
                if (table == null) {
                    return ValueNull.INSTANCE;
                }
                try {
                    ordinal = Integer.parseInt(typeIdentifier);
                }
                catch (NumberFormatException e) {
                    return ValueNull.INSTANCE;
                }
                Column[] columns = table.getColumns();
                if (ordinal < 1 || ordinal > columns.length) {
                    return ValueNull.INSTANCE;
                }
                t = columns[ordinal - 1].getType();
                break;
            }
            default: {
                return ValueNull.INSTANCE;
            }
        }
        return ValueVarchar.get(t.getSQL(0));
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.optimizeArguments(session, false);
        this.type = TypeInfo.TYPE_VARCHAR;
        return this;
    }

    @Override
    public String getName() {
        return "DATA_TYPE_SQL";
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                return false;
            }
        }
        return true;
    }
}

