/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.Function1_2;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBlob;
import org.h2.value.ValueClob;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FileFunction
extends Function1_2 {
    public static final int FILE_READ = 0;
    public static final int FILE_WRITE = 1;
    private static final String[] NAMES = new String[]{"FILE_READ", "FILE_WRITE"};
    private final int function;

    public FileFunction(Expression arg1, Expression arg2, int function) {
        super(arg1, arg2);
        this.function = function;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value getValue(SessionLocal session) {
        session.getUser().checkAdmin();
        Value v1 = this.left.getValue(session);
        if (v1 == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        switch (this.function) {
            case 0: {
                String fileName = v1.getString();
                Database database = session.getDatabase();
                try {
                    long fileLength = FileUtils.size(fileName);
                    Throwable throwable = null;
                    Object var9_15 = null;
                    try (InputStream in = FileUtils.newInputStream(fileName);){
                        void var7_20;
                        if (this.right == null) {
                            ValueBlob valueBlob = database.getLobStorage().createBlob(in, fileLength);
                            return session.addTemporaryLob((ValueLob)var7_20);
                        } else {
                            Value v2 = this.right.getValue(session);
                            InputStreamReader reader = v2 == ValueNull.INSTANCE ? new InputStreamReader(in) : new InputStreamReader(in, v2.getString());
                            ValueClob valueClob = database.getLobStorage().createClob(reader, fileLength);
                        }
                        return session.addTemporaryLob((ValueLob)var7_20);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        } else {
                            if (throwable == throwable2) throw throwable;
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, fileName);
                }
            }
            case 1: {
                Value v2 = this.right.getValue(session);
                if (v2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                String fileName = v2.getString();
                try {
                    Throwable e = null;
                    Object var6_24 = null;
                    try {
                        OutputStream outputStream = Files.newOutputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
                        try {
                            try (InputStream in = v1.getInputStream();){
                                v1 = ValueBigint.get(IOUtils.copy(in, outputStream));
                            }
                            if (outputStream == null) return v1;
                        }
                        catch (Throwable throwable) {
                            if (e == null) {
                                e = throwable;
                            } else if (e != throwable) {
                                e.addSuppressed(throwable);
                            }
                            if (outputStream == null) throw e;
                            outputStream.close();
                            throw e;
                        }
                        outputStream.close();
                        return v1;
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                            throw e;
                        } else {
                            if (e == throwable) throw e;
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, fileName);
                }
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        switch (this.function) {
            case 0: {
                this.type = this.right == null ? TypeInfo.getTypeInfo(7, Integer.MAX_VALUE, 0, null) : TypeInfo.getTypeInfo(3, Integer.MAX_VALUE, 0, null);
                break;
            }
            case 1: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: 
            case 8: {
                return false;
            }
            case 5: {
                if (this.function != 1) break;
                return false;
            }
        }
        return super.isEverything(visitor);
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

