/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.security.SHA3;
import org.h2.util.Bits;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarbinary;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class HashFunction
extends FunctionN {
    public static final int HASH = 0;
    public static final int ORA_HASH = 1;
    private static final String[] NAMES = new String[]{"HASH", "ORA_HASH"};
    private final int function;

    public HashFunction(Expression arg, int function) {
        super(new Expression[]{arg});
        this.function = function;
    }

    public HashFunction(Expression arg1, Expression arg2, Expression arg3, int function) {
        Expression[] expressionArray;
        if (arg3 == null) {
            Expression[] expressionArray2 = new Expression[2];
            expressionArray2[0] = arg1;
            expressionArray = expressionArray2;
            expressionArray2[1] = arg2;
        } else {
            Expression[] expressionArray3 = new Expression[3];
            expressionArray3[0] = arg1;
            expressionArray3[1] = arg2;
            expressionArray = expressionArray3;
            expressionArray3[2] = arg3;
        }
        super(expressionArray);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2, Value v3) {
        switch (this.function) {
            case 0: {
                v1 = HashFunction.getHash(v1.getString(), v2, v3 == null ? 1 : v3.getInt());
                break;
            }
            case 1: {
                v1 = HashFunction.oraHash(v1, v2 == null ? 0xFFFFFFFFL : v2.getLong(), v3 == null ? 0L : v3.getLong());
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    private static Value getHash(String algorithm, Value value, int iterations) {
        MessageDigest md;
        if (iterations <= 0) {
            throw DbException.getInvalidValueException("iterations", iterations);
        }
        switch (StringUtils.toUpperEnglish(algorithm)) {
            case "SHA-224": 
            case "SHA-256": 
            case "SHA-384": 
            case "SHA-512": 
            case "MD5": 
            case "SHA-1": {
                md = HashFunction.hashImpl(value, algorithm);
                break;
            }
            case "SHA256": {
                md = HashFunction.hashImpl(value, "SHA-256");
                break;
            }
            case "SHA3-224": {
                md = HashFunction.hashImpl(value, SHA3.getSha3_224());
                break;
            }
            case "SHA3-256": {
                md = HashFunction.hashImpl(value, SHA3.getSha3_256());
                break;
            }
            case "SHA3-384": {
                md = HashFunction.hashImpl(value, SHA3.getSha3_384());
                break;
            }
            case "SHA3-512": {
                md = HashFunction.hashImpl(value, SHA3.getSha3_512());
                break;
            }
            default: {
                throw DbException.getInvalidValueException("algorithm", algorithm);
            }
        }
        byte[] b = md.digest();
        int i = 1;
        while (i < iterations) {
            b = md.digest(b);
            ++i;
        }
        return ValueVarbinary.getNoCopy(b);
    }

    private static Value oraHash(Value value, long bucket, long seed) {
        if ((bucket & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("bucket", bucket);
        }
        if ((seed & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("seed", seed);
        }
        MessageDigest md = HashFunction.hashImpl(value, "SHA-1");
        if (md == null) {
            return ValueNull.INSTANCE;
        }
        if (seed != 0L) {
            byte[] b = new byte[4];
            Bits.INT_VH_BE.set(b, 0, (int)seed);
            md.update(b);
        }
        long hc = Bits.LONG_VH_BE.get(md.digest(), 0);
        return ValueBigint.get((hc & Long.MAX_VALUE) % (bucket + 1L));
    }

    private static MessageDigest hashImpl(Value value, String algorithm) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception ex) {
            throw DbException.convert(ex);
        }
        return HashFunction.hashImpl(value, md);
    }

    private static MessageDigest hashImpl(Value value, MessageDigest md) {
        try {
            switch (value.getValueType()) {
                case 1: 
                case 2: 
                case 4: {
                    md.update(value.getString().getBytes(StandardCharsets.UTF_8));
                    break;
                }
                case 3: 
                case 7: {
                    byte[] buf = new byte[4096];
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream is = value.getInputStream();){
                        int r;
                        while ((r = is.read(buf)) > 0) {
                            md.update(buf, 0, r);
                        }
                        break;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                default: {
                    md.update(value.getBytesNoCopy());
                }
            }
            return md;
        }
        catch (Exception ex) {
            throw DbException.convert(ex);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        switch (this.function) {
            case 0: {
                this.type = TypeInfo.TYPE_VARBINARY;
                break;
            }
            case 1: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

