/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.Function1;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class LengthFunction
extends Function1 {
    public static final int CHAR_LENGTH = 0;
    public static final int OCTET_LENGTH = 1;
    public static final int BIT_LENGTH = 2;
    private static final String[] NAMES = new String[]{"CHAR_LENGTH", "OCTET_LENGTH", "BIT_LENGTH"};
    private final int function;

    public LengthFunction(Expression arg, int function) {
        super(arg);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        long l;
        Value v = this.arg.getValue(session);
        if (v == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        switch (this.function) {
            case 0: {
                l = v.charLength();
                break;
            }
            case 1: {
                l = v.octetLength();
                break;
            }
            case 2: {
                l = v.octetLength() * 8L;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return ValueBigint.get(l);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.arg = this.arg.optimize(session);
        this.type = TypeInfo.TYPE_BIGINT;
        if (this.arg.isConstant()) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

