/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.util.Random;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.Function0_1;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDouble;
import org.h2.value.ValueNull;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class RandFunction
extends Function0_1 {
    public static final int RAND = 0;
    public static final int SECURE_RAND = 1;
    public static final int RANDOM_UUID = 2;
    private static final String[] NAMES = new String[]{"RAND", "SECURE_RAND", "RANDOM_UUID"};
    private final int function;

    public RandFunction(Expression arg, int function) {
        super(arg);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v;
        if (this.arg != null) {
            v = this.arg.getValue(session);
            if (v == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
        } else {
            v = null;
        }
        switch (this.function) {
            case 0: {
                Random random = session.getRandom();
                if (v != null) {
                    random.setSeed(v.getInt());
                }
                v = ValueDouble.get(random.nextDouble());
                break;
            }
            case 1: {
                v = ValueVarbinary.getNoCopy(MathUtils.secureRandomBytes(v.getInt()));
                break;
            }
            case 2: {
                v = ValueUuid.getNewRandom();
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        if (this.arg != null) {
            this.arg = this.arg.optimize(session);
        }
        switch (this.function) {
            case 0: {
                this.type = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case 1: {
                Value v;
                this.type = this.arg.isConstant() && (v = this.arg.getValue(session)) != ValueNull.INSTANCE ? TypeInfo.getTypeInfo(6, Math.max(v.getInt(), 1), 0, null) : TypeInfo.TYPE_VARBINARY;
                break;
            }
            case 2: {
                this.type = TypeInfo.TYPE_UUID;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                return false;
            }
        }
        return super.isEverything(visitor);
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

