/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class RegexpFunction
extends FunctionN {
    public static final int REGEXP_LIKE = 0;
    public static final int REGEXP_REPLACE = 1;
    public static final int REGEXP_SUBSTR = 2;
    private static final String[] NAMES = new String[]{"REGEXP_LIKE", "REGEXP_REPLACE", "REGEXP_SUBSTR"};
    private final int function;

    public RegexpFunction(int function) {
        super(new Expression[function == 0 ? 3 : 6]);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v1 = this.args[0].getValue(session);
        Value v2 = this.args[1].getValue(session);
        int length = this.args.length;
        switch (this.function) {
            case 0: {
                Value v3;
                Value value = v3 = length >= 3 ? this.args[2].getValue(session) : null;
                if (v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE || v3 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                String regexp = v2.getString();
                String regexpMode = v3 != null ? v3.getString() : null;
                int flags = RegexpFunction.makeRegexpFlags(regexpMode, false);
                try {
                    v1 = ValueBoolean.get(Pattern.compile(regexp, flags).matcher(v1.getString()).find());
                    break;
                }
                catch (PatternSyntaxException e) {
                    throw DbException.get(22025, e, regexp);
                }
            }
            case 1: {
                Value v4;
                String input = v1.getString();
                if (session.getMode().getEnum() == Mode.ModeEnum.Oracle) {
                    String regexpMode;
                    String replacement = this.args[2].getValue(session).getString();
                    int position = length >= 4 ? this.args[3].getValue(session).getInt() : 1;
                    int occurrence = length >= 5 ? this.args[4].getValue(session).getInt() : 0;
                    String string = regexpMode = length >= 6 ? this.args[5].getValue(session).getString() : null;
                    if (input == null) {
                        v1 = ValueNull.INSTANCE;
                        break;
                    }
                    String regexp = v2.getString();
                    v1 = RegexpFunction.regexpReplace(session, input, regexp != null ? regexp : "", replacement != null ? replacement : "", position, occurrence, regexpMode);
                    break;
                }
                if (length > 4) {
                    throw DbException.get(7001, this.getName(), "3..4");
                }
                Value v3 = this.args[2].getValue(session);
                Value value = v4 = length == 4 ? this.args[3].getValue(session) : null;
                if (v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE || v3 == ValueNull.INSTANCE || v4 == ValueNull.INSTANCE) {
                    v1 = ValueNull.INSTANCE;
                    break;
                }
                v1 = RegexpFunction.regexpReplace(session, input, v2.getString(), v3.getString(), 1, 0, v4 != null ? v4.getString() : null);
                break;
            }
            case 2: {
                Value v3 = length >= 3 ? this.args[2].getValue(session) : null;
                Value v4 = length >= 4 ? this.args[3].getValue(session) : null;
                Value v5 = length >= 5 ? this.args[4].getValue(session) : null;
                Value v6 = length >= 6 ? this.args[5].getValue(session) : null;
                v1 = RegexpFunction.regexpSubstr(v1, v2, v3, v4, v5, v6, session);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    private static Value regexpReplace(SessionLocal session, String input, String regexp, String replacement, int position, int occurrence, String regexpMode) {
        Mode mode = session.getMode();
        if (mode.regexpReplaceBackslashReferences && (replacement.indexOf(92) >= 0 || replacement.indexOf(36) >= 0)) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < replacement.length()) {
                char c = replacement.charAt(i);
                if (c == '$') {
                    sb.append('\\');
                } else if (c == '\\' && ++i < replacement.length()) {
                    c = replacement.charAt(i);
                    sb.append((char)(c >= '0' && c <= '9' ? 36 : 92));
                }
                sb.append(c);
                ++i;
            }
            replacement = sb.toString();
        }
        boolean isInPostgreSqlMode = mode.getEnum() == Mode.ModeEnum.PostgreSQL;
        int flags = RegexpFunction.makeRegexpFlags(regexpMode, isInPostgreSqlMode);
        if (isInPostgreSqlMode && (regexpMode == null || regexpMode.isEmpty() || !regexpMode.contains("g"))) {
            occurrence = 1;
        }
        try {
            Matcher matcher = Pattern.compile(regexp, flags).matcher(input).region(position - 1, input.length());
            if (occurrence == 0) {
                return ValueVarchar.get(matcher.replaceAll(replacement), session);
            }
            StringBuffer sb = new StringBuffer();
            int index = 1;
            while (matcher.find()) {
                if (index == occurrence) {
                    matcher.appendReplacement(sb, replacement);
                    break;
                }
                ++index;
            }
            matcher.appendTail(sb);
            return ValueVarchar.get(sb.toString(), session);
        }
        catch (PatternSyntaxException e) {
            throw DbException.get(22025, e, regexp);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException e) {
            throw DbException.get(22025, e, replacement);
        }
    }

    private static Value regexpSubstr(Value inputString, Value regexpArg, Value positionArg, Value occurrenceArg, Value regexpModeArg, Value subexpressionArg, SessionLocal session) {
        if (inputString == ValueNull.INSTANCE || regexpArg == ValueNull.INSTANCE || positionArg == ValueNull.INSTANCE || occurrenceArg == ValueNull.INSTANCE || subexpressionArg == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        String regexp = regexpArg.getString();
        int position = positionArg != null ? positionArg.getInt() - 1 : 0;
        int requestedOccurrence = occurrenceArg != null ? occurrenceArg.getInt() : 1;
        String regexpMode = regexpModeArg != null ? regexpModeArg.getString() : null;
        int subexpression = subexpressionArg != null ? subexpressionArg.getInt() : 0;
        int flags = RegexpFunction.makeRegexpFlags(regexpMode, false);
        try {
            Matcher m = Pattern.compile(regexp, flags).matcher(inputString.getString());
            boolean found = m.find(position);
            int occurrence = 1;
            while (occurrence < requestedOccurrence && found) {
                found = m.find();
                ++occurrence;
            }
            if (!found) {
                return ValueNull.INSTANCE;
            }
            return ValueVarchar.get(m.group(subexpression), session);
        }
        catch (PatternSyntaxException e) {
            throw DbException.get(22025, e, regexp);
        }
        catch (IndexOutOfBoundsException e) {
            return ValueNull.INSTANCE;
        }
    }

    private static int makeRegexpFlags(String stringFlags, boolean ignoreGlobalFlag) {
        int flags = 64;
        if (stringFlags != null) {
            int i = 0;
            while (i < stringFlags.length()) {
                switch (stringFlags.charAt(i)) {
                    case 'i': {
                        flags |= 2;
                        break;
                    }
                    case 'c': {
                        flags &= 0xFFFFFFFD;
                        break;
                    }
                    case 'n': {
                        flags |= 0x20;
                        break;
                    }
                    case 'm': {
                        flags |= 8;
                        break;
                    }
                    case 'g': {
                        if (ignoreGlobalFlag) break;
                    }
                    default: {
                        throw DbException.get(90008, stringFlags);
                    }
                }
                ++i;
            }
        }
        return flags;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        int max;
        int min;
        boolean allConst = this.optimizeArguments(session, true);
        switch (this.function) {
            case 0: {
                min = 2;
                max = 3;
                this.type = TypeInfo.TYPE_BOOLEAN;
                break;
            }
            case 1: {
                min = 3;
                max = 6;
                this.type = TypeInfo.TYPE_VARCHAR;
                break;
            }
            case 2: {
                min = 2;
                max = 6;
                this.type = TypeInfo.TYPE_VARCHAR;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        int len = this.args.length;
        if (len < min || len > max) {
            throw DbException.get(7001, this.getName(), min + ".." + max);
        }
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

