/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.util.regex.Pattern;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.function.Function2;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SignalFunction
extends Function2 {
    private static final Pattern SIGNAL_PATTERN = Pattern.compile("[0-9A-Z]{5}");

    public SignalFunction(Expression arg1, Expression arg2) {
        super(arg1, arg2);
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2) {
        String sqlState = v1.getString();
        if (sqlState.startsWith("00") || !SIGNAL_PATTERN.matcher(sqlState).matches()) {
            throw DbException.getInvalidValueException("SQLSTATE", sqlState);
        }
        throw DbException.fromUser(sqlState, v2.getString());
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        this.type = TypeInfo.TYPE_NULL;
        return this;
    }

    @Override
    public String getName() {
        return "SIGNAL";
    }
}

