/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.math.BigDecimal;
import java.math.MathContext;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueNumeric;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class TruncateValueFunction
extends FunctionN {
    public TruncateValueFunction(Expression arg1, Expression arg2, Expression arg3) {
        super(new Expression[]{arg1, arg2, arg3});
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2, Value v3) {
        long precision = v2.getLong();
        boolean force = v3.getBoolean();
        if (precision <= 0L) {
            throw DbException.get(90150, Long.toString(precision), "1", "2147483647");
        }
        TypeInfo t = v1.getType();
        int valueType = t.getValueType();
        if (DataType.getDataType((int)valueType).supportsPrecision) {
            if (precision < t.getPrecision()) {
                switch (valueType) {
                    case 13: {
                        BigDecimal bd = v1.getBigDecimal().round(new MathContext(MathUtils.convertLongToInt(precision)));
                        if (bd.scale() < 0) {
                            bd = bd.setScale(0);
                        }
                        return ValueNumeric.get(bd);
                    }
                    case 16: {
                        return ValueDecfloat.get(v1.getBigDecimal().round(new MathContext(MathUtils.convertLongToInt(precision))));
                    }
                }
                return v1.castTo(TypeInfo.getTypeInfo(valueType, precision, t.getScale(), t.getExtTypeInfo()), session);
            }
        } else if (force) {
            BigDecimal bd;
            switch (valueType) {
                case 9: 
                case 10: 
                case 11: {
                    bd = BigDecimal.valueOf(v1.getInt());
                    break;
                }
                case 12: {
                    bd = BigDecimal.valueOf(v1.getLong());
                    break;
                }
                case 14: 
                case 15: {
                    bd = v1.getBigDecimal();
                    break;
                }
                default: {
                    return v1;
                }
            }
            bd = bd.round(new MathContext(MathUtils.convertLongToInt(precision)));
            if (valueType == 16) {
                return ValueDecfloat.get(bd);
            }
            if (bd.scale() < 0) {
                bd = bd.setScale(0);
            }
            return ValueNumeric.get(bd).convertTo(valueType);
        }
        return v1;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        this.type = this.args[0].getType();
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return "TRUNCATE_VALUE";
    }
}

