/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function.table;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.function.table.TableFunction;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.util.json.JSONArray;
import org.h2.util.json.JSONValue;
import org.h2.value.Value;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueInteger;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ArrayTableFunction
extends TableFunction {
    public static final int UNNEST = 0;
    public static final int TABLE = 1;
    public static final int TABLE_DISTINCT = 2;
    private Column[] columns;
    private static final String[] NAMES = new String[]{"UNNEST", "TABLE", "TABLE_DISTINCT"};
    private final int function;

    public ArrayTableFunction(int function) {
        super(new Expression[1]);
        this.function = function;
    }

    @Override
    public ResultInterface getValue(SessionLocal session) {
        return this.getTable(session, false);
    }

    @Override
    public void optimize(SessionLocal session) {
        super.optimize(session);
        if (this.args.length < 1) {
            throw DbException.get(7001, this.getName(), ">0");
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if (this.function == 0) {
            super.getSQL(builder, sqlFlags);
            if (this.args.length < this.columns.length) {
                builder.append(" WITH ORDINALITY");
            }
        } else {
            builder.append(this.getName()).append('(');
            int i = 0;
            while (i < this.args.length) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.columns[i].getCreateSQL()).append('=');
                this.args[i].getUnenclosedSQL(builder, sqlFlags);
                ++i;
            }
            builder.append(')');
        }
        return builder;
    }

    @Override
    public ResultInterface getValueTemplate(SessionLocal session) {
        return this.getTable(session, true);
    }

    public void setColumns(ArrayList<Column> columns) {
        this.columns = columns.toArray(new Column[0]);
    }

    private ResultInterface getTable(SessionLocal session, boolean onlyColumnList) {
        int totalColumns = this.columns.length;
        Expression[] header = new Expression[totalColumns];
        Database db = session.getDatabase();
        int i = 0;
        while (i < totalColumns) {
            Column c = this.columns[i];
            ExpressionColumn col = new ExpressionColumn(db, c);
            header[i] = col;
            ++i;
        }
        LocalResult result = new LocalResult(session, header, totalColumns, totalColumns);
        if (!onlyColumnList && this.function == 2) {
            result.setDistinct();
        }
        if (!onlyColumnList) {
            int len = totalColumns;
            boolean unnest = this.function == 0;
            boolean addNumber = false;
            if (unnest && (len = this.args.length) < totalColumns) {
                addNumber = true;
            }
            Value[][] list = new Value[len][];
            int rows = 0;
            int i2 = 0;
            while (i2 < len) {
                Value v = this.args[i2].getValue(session);
                if (v == ValueNull.INSTANCE) {
                    list[i2] = Value.EMPTY_VALUES;
                } else {
                    Value[] l;
                    switch (v.getValueType()) {
                        case 38: {
                            JSONValue value = v.convertToAnyJson().getDecomposition();
                            if (value instanceof JSONArray) {
                                l = ((JSONArray)value).getArray(Value.class, ValueJson::fromJson);
                                break;
                            }
                            l = Value.EMPTY_VALUES;
                            break;
                        }
                        case 40: 
                        case 41: {
                            l = ((ValueCollectionBase)v).getList();
                            break;
                        }
                        default: {
                            l = new Value[]{v};
                        }
                    }
                    list[i2] = l;
                    rows = Math.max(rows, l.length);
                }
                ++i2;
            }
            int row = 0;
            while (row < rows) {
                Value[] r = new Value[totalColumns];
                int j = 0;
                while (j < len) {
                    Value v;
                    Value[] l = list[j];
                    if (l.length <= row) {
                        v = ValueNull.INSTANCE;
                    } else {
                        Column c = this.columns[j];
                        v = l[row];
                        if (!unnest) {
                            v = v.convertForAssignTo(c.getType(), session, c);
                        }
                    }
                    r[j] = v;
                    ++j;
                }
                if (addNumber) {
                    r[len] = ValueInteger.get(row + 1);
                }
                result.addRow(r);
                ++row;
            }
        }
        result.done();
        return result;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    public int getFunctionType() {
        return this.function;
    }
}

