/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.h2.command.query.Query;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueRow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IndexCondition {
    public static final int EQUALITY = 1;
    public static final int START = 2;
    public static final int END = 4;
    public static final int RANGE = 6;
    public static final int ALWAYS_FALSE = 8;
    public static final int SPATIAL_INTERSECTS = 16;
    private final Column column;
    private final Column[] columns;
    private final boolean compoundColumns;
    private final int compareType;
    private final Expression expression;
    private final List<Expression> expressionList;
    private final Query expressionQuery;

    private IndexCondition(int compareType, ExpressionColumn column, Column[] columns, Expression expression, List<Expression> list, Query query) {
        this.compareType = compareType;
        if (column != null) {
            this.column = column.getColumn();
            this.columns = null;
            this.compoundColumns = false;
        } else if (columns != null) {
            this.column = null;
            this.columns = columns;
            this.compoundColumns = true;
        } else {
            this.column = null;
            this.columns = null;
            this.compoundColumns = false;
        }
        this.expression = expression;
        this.expressionList = list;
        this.expressionQuery = query;
    }

    public static IndexCondition get(int compareType, ExpressionColumn column, Expression expression) {
        return new IndexCondition(compareType, column, null, expression, null, null);
    }

    public static IndexCondition getInList(ExpressionColumn column, List<Expression> list) {
        return new IndexCondition(10, column, null, null, list, null);
    }

    public static IndexCondition getCompoundInList(ExpressionList columns, List<Expression> list) {
        int listSize = columns.getSubexpressionCount();
        Column[] cols = new Column[listSize];
        int i = listSize;
        while (--i >= 0) {
            cols[i] = ((ExpressionColumn)columns.getSubexpression(i)).getColumn();
        }
        return new IndexCondition(10, null, cols, null, list, null);
    }

    public static IndexCondition getInArray(ExpressionColumn column, Expression array) {
        return new IndexCondition(11, column, null, array, null, null);
    }

    public static IndexCondition getInQuery(ExpressionColumn column, Query query) {
        assert (query.isRandomAccessResult());
        return new IndexCondition(12, column, null, null, null, query);
    }

    public Value getCurrentValue(SessionLocal session) {
        return this.expression.getValue(session);
    }

    public Value[] getCurrentValueList(SessionLocal session) {
        TreeSet<Value> valueSet = new TreeSet<Value>(session.getDatabase().getCompareMode());
        if (this.compareType == 10) {
            if (this.isCompoundColumns()) {
                Column[] columns = this.getColumns();
                for (Expression e : this.expressionList) {
                    ValueRow v = (ValueRow)e.getValue(session);
                    v = Column.convert(session, columns, v);
                    valueSet.add(v);
                }
            } else {
                Column column = this.getColumn();
                for (Expression e : this.expressionList) {
                    Value v = e.getValue(session);
                    v = column.convert(session, v);
                    valueSet.add(v);
                }
            }
        } else if (this.compareType == 11) {
            Value v = this.expression.getValue(session);
            if (v instanceof ValueArray) {
                Value[] valueArray = ((ValueArray)v).getList();
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Value e = valueArray[n2];
                    valueSet.add(e);
                    ++n2;
                }
            }
        } else {
            throw DbException.getInternalError("compareType = " + this.compareType);
        }
        Value[] array = valueSet.toArray(new Value[valueSet.size()]);
        Arrays.sort(array, session.getDatabase().getCompareMode());
        return array;
    }

    public ResultInterface getCurrentResult() {
        return this.expressionQuery.query(0L);
    }

    public String getSQL(int sqlFlags) {
        if (this.compareType == 9) {
            return "FALSE";
        }
        StringBuilder builder = new StringBuilder();
        builder = this.isCompoundColumns() ? this.buildSql(sqlFlags, builder) : this.buildSql(sqlFlags, this.getColumn(), builder);
        return builder.toString();
    }

    private StringBuilder buildSql(int sqlFlags, StringBuilder builder) {
        if (this.compareType == 10) {
            builder.append(" IN(");
            int i = 0;
            int s = this.expressionList.size();
            while (i < s) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.expressionList.get(i).getSQL(sqlFlags));
                ++i;
            }
            return builder.append(')');
        }
        throw DbException.getInternalError("Multiple columns can only be used with compound IN lists.");
    }

    private StringBuilder buildSql(int sqlFlags, Column column, StringBuilder builder) {
        column.getSQL(builder, sqlFlags);
        switch (this.compareType) {
            case 0: {
                builder.append(" = ");
                break;
            }
            case 6: {
                builder.append(this.expression.isNullConstant() || column.getType().getValueType() == 8 && this.expression.isConstant() ? " IS " : " IS NOT DISTINCT FROM ");
                break;
            }
            case 5: {
                builder.append(" >= ");
                break;
            }
            case 3: {
                builder.append(" > ");
                break;
            }
            case 4: {
                builder.append(" <= ");
                break;
            }
            case 2: {
                builder.append(" < ");
                break;
            }
            case 10: {
                Expression.writeExpressions(builder.append(" IN("), this.expressionList, sqlFlags).append(')');
                break;
            }
            case 11: {
                return this.expression.getSQL(builder.append(" = ANY("), sqlFlags, 0).append(')');
            }
            case 12: {
                builder.append(" IN(");
                this.expressionQuery.getPlanSQL(builder, sqlFlags);
                builder.append(')');
                break;
            }
            case 8: {
                builder.append(" && ");
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.compareType);
            }
        }
        if (this.expression != null) {
            this.expression.getSQL(builder, sqlFlags, 0);
        }
        return builder;
    }

    public int getMask(ArrayList<IndexCondition> indexConditions) {
        switch (this.compareType) {
            case 9: {
                return 8;
            }
            case 0: 
            case 6: {
                return 1;
            }
            case 10: 
            case 11: 
            case 12: {
                if (indexConditions.size() > 1) {
                    if (this.isCompoundColumns()) {
                        Column[] columns = this.getColumns();
                        int i = columns.length;
                        while (--i >= 0) {
                            if (TableType.TABLE == columns[i].getTable().getTableType()) continue;
                            return 0;
                        }
                    } else if (TableType.TABLE != this.getColumn().getTable().getTableType()) {
                        return 0;
                    }
                }
                return 1;
            }
            case 3: 
            case 5: {
                return 2;
            }
            case 2: 
            case 4: {
                return 4;
            }
            case 8: {
                return 16;
            }
        }
        throw DbException.getInternalError("type=" + this.compareType);
    }

    public boolean isAlwaysFalse() {
        return this.compareType == 9;
    }

    public boolean isStart() {
        switch (this.compareType) {
            case 0: 
            case 3: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnd() {
        switch (this.compareType) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isSpatialIntersects() {
        switch (this.compareType) {
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int getCompareType() {
        return this.compareType;
    }

    public Column getColumn() {
        if (!this.isCompoundColumns()) {
            return this.column;
        }
        throw DbException.getInternalError("The getColumn() method cannot be with multiple columns.");
    }

    public Column[] getColumns() {
        if (this.isCompoundColumns()) {
            return this.columns;
        }
        throw DbException.getInternalError("The getColumns() method cannot be with a single column.");
    }

    public boolean isCompoundColumns() {
        return this.compoundColumns;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<Expression> getExpressionList() {
        return this.expressionList;
    }

    public Query getExpressionQuery() {
        return this.expressionQuery;
    }

    public boolean isEvaluatable() {
        if (this.expression != null) {
            return this.expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR);
        }
        if (this.expressionList != null) {
            for (Expression e : this.expressionList) {
                if (e.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) continue;
                return false;
            }
            return true;
        }
        return this.expressionQuery.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR);
    }

    public IndexCondition cloneWithIndexColumns(Index index) {
        if (!this.isCompoundColumns()) {
            throw DbException.getInternalError("The cloneWithColumns() method cannot be with a single column.");
        }
        IndexColumn[] indexColumns = index.getIndexColumns();
        int length = indexColumns.length;
        if (length != this.columns.length) {
            return null;
        }
        int[] newOrder = new int[length];
        int found = 0;
        int i = 0;
        while (i < length) {
            if (indexColumns[i] == null || indexColumns[i].column == null) {
                return null;
            }
            int j = 0;
            while (j < this.columns.length) {
                if (this.columns[j] == indexColumns[i].column) {
                    newOrder[j] = i;
                    ++found;
                }
                ++j;
            }
            ++i;
        }
        if (found != length) {
            return null;
        }
        Column[] newColumns = new Column[length];
        int i2 = 0;
        while (i2 < length) {
            newColumns[i2] = this.columns[newOrder[i2]];
            ++i2;
        }
        ArrayList<Expression> newList = new ArrayList<Expression>(length);
        for (Expression expression : this.expressionList) {
            if (expression instanceof ValueExpression) {
                ValueExpression valueExpression = (ValueExpression)expression;
                ValueRow currentRow = (ValueRow)valueExpression.getValue(null);
                ValueRow newRow = currentRow.cloneWithOrder(newOrder);
                newList.add(ValueExpression.get(newRow));
                continue;
            }
            if (expression instanceof ExpressionList) {
                ExpressionList currentRow = (ExpressionList)expression;
                ExpressionList newRow = currentRow.cloneWithOrder(newOrder);
                newList.add(newRow);
                continue;
            }
            throw DbException.getInternalError("Unexpected expression type: " + String.valueOf(expression.getClass()));
        }
        return new IndexCondition(10, null, newColumns, null, newList, null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.isCompoundColumns()) {
            builder.append("column=").append(this.column);
        } else {
            builder.append("columns=");
            Column.writeColumns(builder, this.columns, 3);
        }
        builder.append(", compareType=");
        return IndexCondition.compareTypeToString(builder, this.compareType).append(", expression=").append(this.expression).append(", expressionList=").append(this.expressionList).append(", expressionQuery=").append(this.expressionQuery).toString();
    }

    private static StringBuilder compareTypeToString(StringBuilder builder, int i) {
        boolean f = false;
        if ((i & 1) == 1) {
            f = true;
            builder.append("EQUALITY");
        }
        if ((i & 2) == 2) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            builder.append("START");
        }
        if ((i & 4) == 4) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            builder.append("END");
        }
        if ((i & 8) == 8) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            builder.append("ALWAYS_FALSE");
        }
        if ((i & 0x10) == 16) {
            if (f) {
                builder.append(", ");
            }
            builder.append("SPATIAL_INTERSECTS");
        }
        return builder;
    }
}

