/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.Objects;
import org.h2.engine.NullsDistinct;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IndexType {
    private boolean primaryKey;
    private boolean persistent;
    private boolean hash;
    private boolean scan;
    private boolean spatial;
    private boolean belongsToConstraint;
    private NullsDistinct nullsDistinct;

    public static IndexType createPrimaryKey(boolean persistent, boolean hash) {
        IndexType type = new IndexType();
        type.primaryKey = true;
        type.persistent = persistent;
        type.hash = hash;
        return type;
    }

    public static IndexType createUnique(boolean persistent, boolean hash, int uniqueColumnCount, NullsDistinct nullsDistinct) {
        IndexType type = new IndexType();
        type.persistent = persistent;
        type.hash = hash;
        type.nullsDistinct = uniqueColumnCount == 1 && nullsDistinct == NullsDistinct.ALL_DISTINCT ? NullsDistinct.DISTINCT : Objects.requireNonNull(nullsDistinct);
        return type;
    }

    public static IndexType createNonUnique(boolean persistent) {
        return IndexType.createNonUnique(persistent, false, false);
    }

    public static IndexType createNonUnique(boolean persistent, boolean hash, boolean spatial) {
        IndexType type = new IndexType();
        type.persistent = persistent;
        type.hash = hash;
        type.spatial = spatial;
        return type;
    }

    public static IndexType createScan(boolean persistent) {
        IndexType type = new IndexType();
        type.persistent = persistent;
        type.scan = true;
        return type;
    }

    public void setBelongsToConstraint(boolean belongsToConstraint) {
        this.belongsToConstraint = belongsToConstraint;
    }

    public boolean getBelongsToConstraint() {
        return this.belongsToConstraint;
    }

    public boolean isHash() {
        return this.hash;
    }

    public boolean isSpatial() {
        return this.spatial;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isUnique() {
        return this.primaryKey || this.nullsDistinct != null;
    }

    public String getSQL(boolean addNullsDistinct) {
        StringBuilder builder = new StringBuilder();
        if (this.primaryKey) {
            builder.append("PRIMARY KEY");
            if (this.hash) {
                builder.append(" HASH");
            }
        } else {
            if (this.nullsDistinct != null) {
                builder.append("UNIQUE ");
                if (addNullsDistinct) {
                    this.nullsDistinct.getSQL(builder, 0).append(' ');
                }
            }
            if (this.hash) {
                builder.append("HASH ");
            }
            if (this.spatial) {
                builder.append("SPATIAL ");
            }
            builder.append("INDEX");
        }
        return builder.toString();
    }

    public boolean isScan() {
        return this.scan;
    }

    public NullsDistinct getNullsDistinct() {
        return this.nullsDistinct;
    }

    public NullsDistinct getEffectiveNullsDistinct() {
        return this.nullsDistinct != null ? this.nullsDistinct : (this.primaryKey ? NullsDistinct.NOT_DISTINCT : null);
    }
}

