/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinkedCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.table.TableLink;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LinkedIndex
extends Index {
    private final TableLink link;
    private final String targetTableName;
    private long rowCount;
    private final int sqlFlags = 1;

    public LinkedIndex(TableLink table, int id, IndexColumn[] columns, int uniqueColumnCount, IndexType indexType) {
        super(table, id, null, columns, uniqueColumnCount, indexType);
        this.link = table;
        this.targetTableName = this.link.getQualifiedTable();
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void close(SessionLocal session) {
    }

    private static boolean isNull(Value v) {
        return v == null || v == ValueNull.INSTANCE;
    }

    @Override
    public void add(SessionLocal session, Row row) {
        ArrayList<Value> params = Utils.newSmallArrayList();
        StringBuilder buff = new StringBuilder("INSERT INTO ");
        buff.append(this.targetTableName).append(" VALUES(");
        int i = 0;
        while (i < row.getColumnCount()) {
            Value v = row.getValue(i);
            if (i > 0) {
                buff.append(", ");
            }
            if (v == null) {
                buff.append("DEFAULT");
            } else if (LinkedIndex.isNull(v)) {
                buff.append("NULL");
            } else {
                buff.append('?');
                params.add(v);
            }
            ++i;
        }
        buff.append(')');
        String sql = buff.toString();
        try {
            this.link.execute(sql, params, true, session);
            ++this.rowCount;
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    @Override
    public Cursor find(SessionLocal session, SearchRow first, SearchRow last, boolean reverse) {
        Column col;
        Value v;
        assert (!reverse);
        ArrayList<Value> params = Utils.newSmallArrayList();
        StringBuilder builder = new StringBuilder("SELECT * FROM ").append(this.targetTableName).append(" T");
        boolean f = false;
        int i = 0;
        while (first != null && i < first.getColumnCount()) {
            v = first.getValue(i);
            if (v != null) {
                builder.append(f ? " AND " : " WHERE ");
                f = true;
                col = this.table.getColumn(i);
                this.addColumnName(builder, col);
                if (v == ValueNull.INSTANCE) {
                    builder.append(" IS NULL");
                } else {
                    builder.append(">=");
                    this.addParameter(builder, col);
                    params.add(v);
                }
            }
            ++i;
        }
        i = 0;
        while (last != null && i < last.getColumnCount()) {
            v = last.getValue(i);
            if (v != null) {
                builder.append(f ? " AND " : " WHERE ");
                f = true;
                col = this.table.getColumn(i);
                this.addColumnName(builder, col);
                if (v == ValueNull.INSTANCE) {
                    builder.append(" IS NULL");
                } else {
                    builder.append("<=");
                    this.addParameter(builder, col);
                    params.add(v);
                }
            }
            ++i;
        }
        String sql = builder.toString();
        try {
            PreparedStatement prep = this.link.execute(sql, params, false, session);
            ResultSet rs = prep.getResultSet();
            return new LinkedCursor(this.link, rs, session, sql, prep);
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    private void addColumnName(StringBuilder builder, Column col) {
        String identifierQuoteString = this.link.getIdentifierQuoteString();
        String name = col.getName();
        if (identifierQuoteString == null || identifierQuoteString.isEmpty() || identifierQuoteString.equals(" ")) {
            builder.append(name);
        } else if (identifierQuoteString.equals("\"")) {
            builder.append('\"');
            int i = name.indexOf(34);
            if (i < 0) {
                builder.append(name);
            } else {
                builder.append(name, 0, ++i).append('\"');
                int l = name.length();
                while (i < l) {
                    char c = name.charAt(i);
                    if (c == '\"') {
                        builder.append('\"');
                    }
                    builder.append(c);
                    ++i;
                }
            }
            builder.append('\"');
        } else {
            builder.append(identifierQuoteString).append(name).append(identifierQuoteString);
        }
    }

    private void addParameter(StringBuilder builder, Column col) {
        TypeInfo type = col.getType();
        if (type.getValueType() == 1 && this.link.isOracle()) {
            builder.append("CAST(? AS CHAR(").append(type.getPrecision()).append("))");
        } else {
            builder.append('?');
        }
    }

    @Override
    public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return 100L + this.getCostRangeIndex(masks, this.rowCount + 1000L, filters, filter, sortOrder, false, allColumnsSet);
    }

    @Override
    public void remove(SessionLocal session) {
    }

    @Override
    public void truncate(SessionLocal session) {
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("LINKED");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(SessionLocal session, Row row) {
        ArrayList<Value> params = Utils.newSmallArrayList();
        StringBuilder builder = new StringBuilder("DELETE FROM ").append(this.targetTableName).append(" WHERE ");
        int i = 0;
        while (i < row.getColumnCount()) {
            if (i > 0) {
                builder.append("AND ");
            }
            Column col = this.table.getColumn(i);
            this.addColumnName(builder, col);
            Value v = row.getValue(i);
            if (LinkedIndex.isNull(v)) {
                builder.append(" IS NULL ");
            } else {
                builder.append('=');
                this.addParameter(builder, col);
                params.add(v);
                builder.append(' ');
            }
            ++i;
        }
        String sql = builder.toString();
        try {
            PreparedStatement prep = this.link.execute(sql, params, false, session);
            int count = prep.executeUpdate();
            this.link.reusePreparedStatement(prep, sql);
            this.rowCount -= (long)count;
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    public void update(Row oldRow, Row newRow, SessionLocal session) {
        ArrayList<Value> params = Utils.newSmallArrayList();
        StringBuilder builder = new StringBuilder("UPDATE ").append(this.targetTableName).append(" SET ");
        int i = 0;
        while (i < newRow.getColumnCount()) {
            if (i > 0) {
                builder.append(", ");
            }
            this.table.getColumn(i).getSQL(builder, 1).append('=');
            Value v = newRow.getValue(i);
            if (v == null) {
                builder.append("DEFAULT");
            } else {
                builder.append('?');
                params.add(v);
            }
            ++i;
        }
        builder.append(" WHERE ");
        i = 0;
        while (i < oldRow.getColumnCount()) {
            Column col = this.table.getColumn(i);
            if (i > 0) {
                builder.append(" AND ");
            }
            this.addColumnName(builder, col);
            Value v = oldRow.getValue(i);
            if (LinkedIndex.isNull(v)) {
                builder.append(" IS NULL");
            } else {
                builder.append('=');
                params.add(v);
                this.addParameter(builder, col);
            }
            ++i;
        }
        String sql = builder.toString();
        try {
            this.link.execute(sql, params, true, session);
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    @Override
    public long getRowCount(SessionLocal session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return this.rowCount;
    }
}

