/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.command.query.Query;
import org.h2.engine.SessionLocal;
import org.h2.expression.Parameter;
import org.h2.index.Cursor;
import org.h2.index.QueryExpressionCursor;
import org.h2.index.QueryExpressionIndex;
import org.h2.index.SpatialIndex;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.QueryExpressionTable;
import org.h2.table.TableFilter;
import org.h2.util.IntArray;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class RegularQueryExpressionIndex
extends QueryExpressionIndex
implements SpatialIndex {
    private final int[] indexMasks;
    private final long evaluatedAt;

    public RegularQueryExpressionIndex(QueryExpressionTable table, String querySQL, ArrayList<Parameter> originalParameters, SessionLocal session, int[] masks) {
        super(table, querySQL, originalParameters);
        this.indexMasks = masks;
        Query q = session.prepareQueryExpression(querySQL, table.getQueryScope());
        if (masks != null && q.allowGlobalConditions()) {
            q = this.addConditions(table, querySQL, originalParameters, session, masks, q);
        }
        q.preparePlan();
        this.query = q;
        this.evaluatedAt = table.getTopQuery() == null ? System.nanoTime() : 0L;
    }

    private Query addConditions(QueryExpressionTable table, String querySQL, ArrayList<Parameter> originalParameters, SessionLocal session, int[] masks, Query q) {
        int firstIndexParam = table.getParameterOffset(originalParameters);
        IntArray paramColumnIndex = new IntArray();
        int indexColumnCount = 0;
        int i = 0;
        while (i < masks.length) {
            int mask = masks[i];
            if (mask != 0) {
                ++indexColumnCount;
                int bitCount = Integer.bitCount(mask);
                int j = 0;
                while (j < bitCount) {
                    paramColumnIndex.add(i);
                    ++j;
                }
            }
            ++i;
        }
        int len = paramColumnIndex.size();
        ArrayList<Column> columnList = new ArrayList<Column>(len);
        int i2 = 0;
        while (i2 < len) {
            Parameter param;
            int idx = paramColumnIndex.get(i2);
            columnList.add(table.getColumn(idx));
            int mask = masks[idx];
            if ((mask & 1) != 0) {
                param = new Parameter(firstIndexParam + i2);
                q.addGlobalCondition(param, idx, 6);
                ++i2;
            }
            if ((mask & 2) != 0) {
                param = new Parameter(firstIndexParam + i2);
                q.addGlobalCondition(param, idx, 5);
                ++i2;
            }
            if ((mask & 4) != 0) {
                param = new Parameter(firstIndexParam + i2);
                q.addGlobalCondition(param, idx, 4);
                ++i2;
            }
            if ((mask & 0x10) == 0) continue;
            param = new Parameter(firstIndexParam + i2);
            q.addGlobalCondition(param, idx, 8);
            ++i2;
        }
        this.columns = columnList.toArray(new Column[0]);
        this.indexColumns = new IndexColumn[indexColumnCount];
        this.columnIds = new int[indexColumnCount];
        int type = 0;
        int indexColumnId = 0;
        while (type < 2) {
            int i3 = 0;
            while (i3 < masks.length) {
                int mask = masks[i3];
                if (mask != 0 && !(type == 0 ? (mask & 1) == 0 : (mask & 1) != 0)) {
                    Column column = table.getColumn(i3);
                    this.indexColumns[indexColumnId] = new IndexColumn(column);
                    this.columnIds[indexColumnId] = column.getColumnId();
                    ++indexColumnId;
                }
                ++i3;
            }
            ++type;
        }
        String sql = q.getPlanSQL(0);
        if (!sql.equals(querySQL)) {
            q = session.prepareQueryExpression(sql, table.getQueryScope());
        }
        return q;
    }

    @Override
    public boolean isExpired() {
        return this.table.getTopQuery() == null && System.nanoTime() - this.evaluatedAt > 10000000000L;
    }

    @Override
    public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return this.query.getCost();
    }

    @Override
    public Cursor find(SessionLocal session, SearchRow first, SearchRow last, boolean reverse) {
        return this.find(session, first, last, null);
    }

    @Override
    public Cursor findByGeometry(SessionLocal session, SearchRow first, SearchRow last, boolean reverse, SearchRow intersection) {
        assert (!reverse);
        return this.find(session, first, last, intersection);
    }

    private Cursor find(SessionLocal session, SearchRow first, SearchRow last, SearchRow intersection) {
        ArrayList<Parameter> paramList = this.query.getParameters();
        if (this.originalParameters != null) {
            for (Parameter orig : this.originalParameters) {
                if (orig == null) continue;
                int idx = orig.getIndex();
                Value value = orig.getValue(session);
                RegularQueryExpressionIndex.setParameter(paramList, idx, value);
            }
        }
        int len = first != null ? first.getColumnCount() : (last != null ? last.getColumnCount() : (intersection != null ? intersection.getColumnCount() : 0));
        int idx = this.table.getParameterOffset(this.originalParameters);
        int i = 0;
        while (i < len) {
            int mask = this.indexMasks[i];
            if ((mask & 1) != 0) {
                RegularQueryExpressionIndex.setParameter(paramList, idx++, first.getValue(i));
            }
            if ((mask & 2) != 0) {
                RegularQueryExpressionIndex.setParameter(paramList, idx++, first.getValue(i));
            }
            if ((mask & 4) != 0) {
                RegularQueryExpressionIndex.setParameter(paramList, idx++, last.getValue(i));
            }
            if ((mask & 0x10) != 0) {
                RegularQueryExpressionIndex.setParameter(paramList, idx++, intersection.getValue(i));
            }
            ++i;
        }
        return new QueryExpressionCursor(this, this.query.query(0L), first, last);
    }

    private static void setParameter(ArrayList<Parameter> paramList, int x, Value v) {
        if (x >= paramList.size()) {
            return;
        }
        Parameter param = paramList.get(x);
        param.setValue(v);
    }
}

