/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jcr;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.h2.bnf.Bnf;
import org.h2.build.BuildBase;
import org.h2.build.doc.BnfRailroad;
import org.h2.build.doc.BnfSyntax;
import org.h2.build.doc.RailroadImages;
import org.h2.server.web.PageParser;
import org.h2.tools.Csv;
import org.h2.util.StringUtils;

public class Railroads {
    private Bnf bnf;
    private final HashMap<String, Object> session = new HashMap();

    public static void main(String ... args) throws Exception {
        new Railroads().process();
    }

    private void process() throws Exception {
        RailroadImages.main(new String[0]);
        this.bnf = Bnf.getInstance(Railroads.getReader());
        Csv csv = new Csv();
        csv.setLineCommentCharacter('#');
        ResultSet rs = csv.read(Railroads.getReader(), null);
        this.map("grammar", rs, true);
        this.processHtml("jcr-sql2.html");
    }

    private void processHtml(String fileName) throws Exception {
        String source = "src/tools/org/h2/jcr/";
        String target = "docs/html/";
        byte[] s = BuildBase.readFile(Paths.get(source + "stylesheet.css", new String[0]));
        BuildBase.writeFile(Paths.get(target + "stylesheet.css", new String[0]), s);
        Path inFile = Paths.get(source + fileName, new String[0]);
        Path outFile = Paths.get(target + fileName, new String[0]);
        Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
        byte[] bytes = Files.readAllBytes(inFile);
        if (fileName.endsWith(".html")) {
            String page = new String(bytes);
            page = PageParser.parse(page, this.session);
            bytes = page.getBytes();
        }
        Files.write(outFile, bytes, new OpenOption[0]);
    }

    private static Reader getReader() {
        return new InputStreamReader(Railroads.class.getResourceAsStream("help.csv"));
    }

    private void map(String key, ResultSet rs, boolean railroads) throws Exception {
        ArrayList list = new ArrayList();
        while (rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>();
            ResultSetMetaData meta = rs.getMetaData();
            int i = 0;
            while (i < meta.getColumnCount()) {
                String k = StringUtils.toLowerEnglish(meta.getColumnLabel(i + 1));
                String value = rs.getString(i + 1);
                value = value.trim();
                map.put(k, PageParser.escapeHtml(value));
                ++i;
            }
            String topic = rs.getString("TOPIC");
            String syntax = rs.getString("SYNTAX").trim();
            if (railroads) {
                BnfRailroad r = new BnfRailroad();
                String railroad = r.getHtml(this.bnf, syntax);
                map.put("railroad", railroad);
            }
            BnfSyntax visitor = new BnfSyntax();
            String syntaxHtml = visitor.getHtml(this.bnf, syntax);
            map.put("syntax", syntaxHtml);
            String text = (String)map.get("text");
            if (text != null) {
                text = StringUtils.replaceAll(text, "<br /><br />", "</p><p>");
                text = StringUtils.replaceAll(text, "<br />", " ");
                map.put("text", text);
            }
            String link = topic.toLowerCase();
            link = link.replace(' ', '_');
            link = link.replace('@', '_');
            map.put("link", StringUtils.urlEncode(link));
            list.add(map);
        }
        this.session.put(key, list);
        int div = 3;
        int part = (list.size() + div - 1) / div;
        int i = 0;
        int start = 0;
        while (i < div) {
            List listThird = list.subList(start, Math.min(start + part, list.size()));
            this.session.put(key + "-" + i, listThird);
            ++i;
            start += part;
        }
        rs.close();
    }
}

