/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcLob;
import org.h2.message.DbException;
import org.h2.util.IOUtils;
import org.h2.util.Task;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JdbcBlob
extends JdbcLob
implements Blob {
    public JdbcBlob(JdbcConnection conn, Value value, JdbcLob.State state, int id) {
        super(conn, value, state, 9, id);
    }

    @Override
    public long length() throws SQLException {
        try {
            long precision;
            this.debugCodeCall("length");
            this.checkReadable();
            if (this.value.getValueType() == 7 && (precision = this.value.getType().getPrecision()) > 0L) {
                return precision;
            }
            return IOUtils.copyAndCloseInput(this.value.getInputStream(), null);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBytes(" + pos + ", " + length + ")");
            }
            this.checkReadable();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream in = this.value.getInputStream();){
                IOUtils.skipFully(in, pos - 1L);
                IOUtils.copy(in, (OutputStream)out, (long)length);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + pos + ", " + JdbcBlob.quoteBytes(bytes) + ")");
            }
            this.checkEditable();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            this.completeWrite(this.conn.createBlob(new ByteArrayInputStream(bytes), -1L));
            return bytes.length;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + pos + ", " + JdbcBlob.quoteBytes(bytes) + ", " + offset + ", " + len + ")");
            }
            this.checkEditable();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            this.completeWrite(this.conn.createBlob(new ByteArrayInputStream(bytes, offset, len), -1L));
            return (int)this.value.getType().getPrecision();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return super.getBinaryStream();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("setBinaryStream", pos);
            }
            this.checkEditable();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            final PipedInputStream in = new PipedInputStream();
            Task task = new Task(){

                @Override
                public void call() {
                    JdbcBlob.this.completeWrite(JdbcBlob.this.conn.createBlob(in, -1L));
                }
            };
            JdbcLob.LobPipedOutputStream out = new JdbcLob.LobPipedOutputStream(in, task);
            task.execute();
            this.state = JdbcLob.State.SET_CALLED;
            return new BufferedOutputStream(out);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("position(" + JdbcBlob.quoteBytes(pattern) + ", " + start + ")");
        }
        throw this.unsupported("LOB search");
    }

    @Override
    public long position(Blob blobPattern, long start) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("position(blobPattern, " + start + ")");
        }
        throw this.unsupported("LOB subset");
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBinaryStream(" + pos + ", " + length + ")");
            }
            this.checkReadable();
            if (this.state == JdbcLob.State.NEW) {
                if (pos != 1L) {
                    throw DbException.getInvalidValueException("pos", pos);
                }
                if (length != 0L) {
                    throw DbException.getInvalidValueException("length", pos);
                }
            }
            return this.value.getInputStream(pos, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }
}

