/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc.meta;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.h2.command.dml.Help;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Mode;
import org.h2.engine.Right;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.expression.condition.CompareLike;
import org.h2.index.Index;
import org.h2.jdbc.meta.DatabaseMetaLocalBase;
import org.h2.message.DbException;
import org.h2.mode.DefaultNullOrdering;
import org.h2.result.ResultInterface;
import org.h2.result.SimpleResult;
import org.h2.result.SortOrder;
import org.h2.schema.FunctionAlias;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.UserDefinedFunction;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableSynonym;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueToObjectConverter2;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DatabaseMetaLocal
extends DatabaseMetaLocalBase {
    private static final Value YES = ValueVarchar.get("YES");
    private static final Value NO = ValueVarchar.get("NO");
    private static final ValueSmallint BEST_ROW_SESSION = ValueSmallint.get((short)2);
    private static final ValueSmallint BEST_ROW_NOT_PSEUDO = ValueSmallint.get((short)1);
    private static final ValueInteger COLUMN_NO_NULLS = ValueInteger.get(0);
    private static final ValueSmallint COLUMN_NO_NULLS_SMALL = ValueSmallint.get((short)0);
    private static final ValueInteger COLUMN_NULLABLE = ValueInteger.get(1);
    private static final ValueSmallint COLUMN_NULLABLE_UNKNOWN_SMALL = ValueSmallint.get((short)2);
    private static final ValueSmallint IMPORTED_KEY_CASCADE = ValueSmallint.get((short)0);
    private static final ValueSmallint IMPORTED_KEY_RESTRICT = ValueSmallint.get((short)1);
    private static final ValueSmallint IMPORTED_KEY_DEFAULT = ValueSmallint.get((short)4);
    private static final ValueSmallint IMPORTED_KEY_SET_NULL = ValueSmallint.get((short)2);
    private static final ValueSmallint IMPORTED_KEY_NOT_DEFERRABLE = ValueSmallint.get((short)7);
    private static final ValueSmallint PROCEDURE_COLUMN_IN = ValueSmallint.get((short)1);
    private static final ValueSmallint PROCEDURE_COLUMN_RETURN = ValueSmallint.get((short)5);
    private static final ValueSmallint PROCEDURE_NO_RESULT = ValueSmallint.get((short)1);
    private static final ValueSmallint PROCEDURE_RETURNS_RESULT = ValueSmallint.get((short)2);
    private static final ValueSmallint TABLE_INDEX_HASHED = ValueSmallint.get((short)2);
    private static final ValueSmallint TABLE_INDEX_OTHER = ValueSmallint.get((short)3);
    private static final String[] TABLE_TYPES = new String[]{"BASE TABLE", "GLOBAL TEMPORARY", "LOCAL TEMPORARY", "SYNONYM", "VIEW"};
    private static final ValueSmallint TYPE_NULLABLE = ValueSmallint.get((short)1);
    private static final ValueSmallint TYPE_SEARCHABLE = ValueSmallint.get((short)3);
    private static final Value NO_USAGE_RESTRICTIONS = ValueVarchar.get("NO_USAGE_RESTRICTIONS");
    private final SessionLocal session;

    public DatabaseMetaLocal(SessionLocal session) {
        this.session = session;
    }

    @Override
    public final DefaultNullOrdering defaultNullOrdering() {
        return this.session.getDatabase().getDefaultNullOrdering();
    }

    @Override
    public String getSQLKeywords() {
        StringBuilder builder = new StringBuilder(103).append("CURRENT_CATALOG,CURRENT_SCHEMA,GROUPS,IF,ILIKE,KEY,");
        Mode mode = this.session.getMode();
        if (mode.limit) {
            builder.append("LIMIT,");
        }
        if (mode.minusIsExcept) {
            builder.append("MINUS,");
        }
        builder.append("OFFSET,QUALIFY,REGEXP,ROWNUM,");
        if (mode.topInSelect || mode.topInDML) {
            builder.append("TOP,");
        }
        return builder.append("_ROWID_").toString();
    }

    @Override
    public String getNumericFunctions() {
        return this.getFunctions("Functions (Numeric)");
    }

    @Override
    public String getStringFunctions() {
        return this.getFunctions("Functions (String)");
    }

    @Override
    public String getSystemFunctions() {
        return this.getFunctions("Functions (System)");
    }

    @Override
    public String getTimeDateFunctions() {
        return this.getFunctions("Functions (Time and Date)");
    }

    private String getFunctions(String section) {
        this.checkClosed();
        StringBuilder builder = new StringBuilder();
        try {
            ResultSet rs = Help.getTable();
            while (rs.next()) {
                String topic;
                int spaceIndex;
                if (!rs.getString(1).trim().equals(section)) continue;
                if (builder.length() != 0) {
                    builder.append(',');
                }
                if ((spaceIndex = (topic = rs.getString(2).trim()).indexOf(32)) >= 0) {
                    StringUtils.trimSubstring(builder, topic, 0, spaceIndex);
                    continue;
                }
                builder.append(topic);
            }
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
        return builder.toString();
    }

    @Override
    public String getSearchStringEscape() {
        return this.session.getDatabase().getSettings().defaultEscape;
    }

    @Override
    public ResultInterface getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("PROCEDURE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PROCEDURE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PROCEDURE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("RESERVED1", TypeInfo.TYPE_NULL);
        result.addColumn("RESERVED2", TypeInfo.TYPE_NULL);
        result.addColumn("RESERVED3", TypeInfo.TYPE_NULL);
        result.addColumn("REMARKS", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PROCEDURE_TYPE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("SPECIFIC_NAME", TypeInfo.TYPE_VARCHAR);
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        CompareLike procedureLike = this.getLike(procedureNamePattern);
        for (Schema s : this.getSchemasForPattern(schemaPattern)) {
            Value schemaValue = this.getString(s.getName());
            for (UserDefinedFunction userDefinedFunction : s.getAllFunctionsAndAggregates()) {
                String procedureName = userDefinedFunction.getName();
                if (procedureLike != null && !procedureLike.test(procedureName)) continue;
                Value procedureNameValue = this.getString(procedureName);
                if (userDefinedFunction instanceof FunctionAlias) {
                    FunctionAlias.JavaMethod[] methods;
                    try {
                        methods = ((FunctionAlias)userDefinedFunction).getJavaMethods();
                    }
                    catch (DbException e) {
                        continue;
                    }
                    int i = 0;
                    while (i < methods.length) {
                        FunctionAlias.JavaMethod method = methods[i];
                        TypeInfo typeInfo = method.getDataType();
                        this.getProceduresAdd(result, catalogValue, schemaValue, procedureNameValue, userDefinedFunction.getComment(), typeInfo == null || typeInfo.getValueType() != 0 ? PROCEDURE_RETURNS_RESULT : PROCEDURE_NO_RESULT, this.getString(procedureName + "_" + (i + 1)));
                        ++i;
                    }
                    continue;
                }
                this.getProceduresAdd(result, catalogValue, schemaValue, procedureNameValue, userDefinedFunction.getComment(), PROCEDURE_RETURNS_RESULT, procedureNameValue);
            }
        }
        result.sortRows(new SortOrder(this.session, new int[]{1, 2, 8}));
        return result;
    }

    private void getProceduresAdd(SimpleResult result, Value catalogValue, Value schemaValue, Value procedureNameValue, String comment, ValueSmallint procedureType, Value specificNameValue) {
        result.addRow(catalogValue, schemaValue, procedureNameValue, ValueNull.INSTANCE, ValueNull.INSTANCE, ValueNull.INSTANCE, this.getString(comment), procedureType, specificNameValue);
    }

    @Override
    public ResultInterface getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("PROCEDURE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PROCEDURE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PROCEDURE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("COLUMN_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("COLUMN_TYPE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("DATA_TYPE", TypeInfo.TYPE_INTEGER);
        result.addColumn("TYPE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PRECISION", TypeInfo.TYPE_INTEGER);
        result.addColumn("LENGTH", TypeInfo.TYPE_INTEGER);
        result.addColumn("SCALE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("RADIX", TypeInfo.TYPE_SMALLINT);
        result.addColumn("NULLABLE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("REMARKS", TypeInfo.TYPE_VARCHAR);
        result.addColumn("COLUMN_DEF", TypeInfo.TYPE_VARCHAR);
        result.addColumn("SQL_DATA_TYPE", TypeInfo.TYPE_INTEGER);
        result.addColumn("SQL_DATETIME_SUB", TypeInfo.TYPE_INTEGER);
        result.addColumn("CHAR_OCTET_LENGTH", TypeInfo.TYPE_INTEGER);
        result.addColumn("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER);
        result.addColumn("IS_NULLABLE", TypeInfo.TYPE_VARCHAR);
        result.addColumn("SPECIFIC_NAME", TypeInfo.TYPE_VARCHAR);
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        CompareLike procedureLike = this.getLike(procedureNamePattern);
        for (Schema s : this.getSchemasForPattern(schemaPattern)) {
            Value schemaValue = this.getString(s.getName());
            for (UserDefinedFunction userDefinedFunction : s.getAllFunctionsAndAggregates()) {
                FunctionAlias.JavaMethod[] methods;
                if (!(userDefinedFunction instanceof FunctionAlias)) continue;
                String procedureName = userDefinedFunction.getName();
                if (procedureLike != null && !procedureLike.test(procedureName)) continue;
                Value procedureNameValue = this.getString(procedureName);
                try {
                    methods = ((FunctionAlias)userDefinedFunction).getJavaMethods();
                }
                catch (DbException e) {
                    continue;
                }
                int i = 0;
                int l = methods.length;
                while (i < l) {
                    FunctionAlias.JavaMethod method = methods[i];
                    Value specificNameValue = this.getString(procedureName + "_" + (i + 1));
                    TypeInfo typeInfo = method.getDataType();
                    if (typeInfo != null && typeInfo.getValueType() != 0) {
                        this.getProcedureColumnAdd(result, catalogValue, schemaValue, procedureNameValue, specificNameValue, typeInfo, method.getClass().isPrimitive(), 0);
                    }
                    Class<?>[] columnList = method.getColumnClasses();
                    int o = 1;
                    int p = method.hasConnectionParam() ? 1 : 0;
                    int n = columnList.length;
                    while (p < n) {
                        Class<?> clazz = columnList[p];
                        this.getProcedureColumnAdd(result, catalogValue, schemaValue, procedureNameValue, specificNameValue, ValueToObjectConverter2.classToType(clazz), clazz.isPrimitive(), o);
                        ++o;
                        ++p;
                    }
                    ++i;
                }
            }
        }
        result.sortRows(new SortOrder(this.session, new int[]{1, 2, 19}));
        return result;
    }

    private void getProcedureColumnAdd(SimpleResult result, Value catalogValue, Value schemaValue, Value procedureNameValue, Value specificNameValue, TypeInfo type, boolean notNull, int ordinal) {
        int valueType = type.getValueType();
        DataType dt = DataType.getDataType(valueType);
        ValueInteger precisionValue = ValueInteger.get(MathUtils.convertLongToInt(type.getPrecision()));
        result.addRow(catalogValue, schemaValue, procedureNameValue, this.getString((String)(ordinal == 0 ? "RESULT" : "P" + ordinal)), ordinal == 0 ? PROCEDURE_COLUMN_RETURN : PROCEDURE_COLUMN_IN, ValueInteger.get(DataType.convertTypeToSQLType(type)), this.getDataTypeName(type), precisionValue, precisionValue, dt.supportsScale ? ValueSmallint.get(MathUtils.convertIntToShort(dt.defaultScale)) : ValueNull.INSTANCE, DatabaseMetaLocal.getRadix(valueType, true), notNull ? COLUMN_NO_NULLS_SMALL : COLUMN_NULLABLE_UNKNOWN_SMALL, ValueNull.INSTANCE, ValueNull.INSTANCE, ValueNull.INSTANCE, ValueNull.INSTANCE, DataType.isBinaryStringType(valueType) || DataType.isCharacterStringType(valueType) ? precisionValue : ValueNull.INSTANCE, ValueInteger.get(ordinal), ValueVarchar.EMPTY, specificNameValue);
    }

    @Override
    public ResultInterface getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        HashSet<String> typesSet;
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_TYPE", TypeInfo.TYPE_VARCHAR);
        result.addColumn("REMARKS", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TYPE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TYPE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TYPE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("SELF_REFERENCING_COL_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("REF_GENERATION", TypeInfo.TYPE_VARCHAR);
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        if (types != null) {
            typesSet = new HashSet<String>(8);
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                int idx = Arrays.binarySearch(TABLE_TYPES, type);
                if (idx >= 0) {
                    typesSet.add(TABLE_TYPES[idx]);
                } else if (type.equals("TABLE")) {
                    typesSet.add("BASE TABLE");
                }
                ++n2;
            }
            if (typesSet.isEmpty()) {
                return result;
            }
        } else {
            typesSet = null;
        }
        for (Schema schema : this.getSchemasForPattern(schemaPattern)) {
            Value schemaValue = this.getString(schema.getName());
            for (SchemaObject schemaObject : this.getTablesForPattern(schema, tableNamePattern)) {
                Value tableName = this.getString(schemaObject.getName());
                if (schemaObject instanceof Table) {
                    this.getTablesAdd(result, catalogValue, schemaValue, tableName, (Table)schemaObject, false, typesSet);
                    continue;
                }
                this.getTablesAdd(result, catalogValue, schemaValue, tableName, ((TableSynonym)schemaObject).getSynonymFor(), true, typesSet);
            }
        }
        result.sortRows(new SortOrder(this.session, new int[]{3, 1, 2}));
        return result;
    }

    private void getTablesAdd(SimpleResult result, Value catalogValue, Value schemaValue, Value tableName, Table t, boolean synonym, HashSet<String> typesSet) {
        String type;
        String string = type = synonym ? "SYNONYM" : t.getSQLTableType();
        if (typesSet != null && !typesSet.contains(type)) {
            return;
        }
        result.addRow(catalogValue, schemaValue, tableName, this.getString(type), this.getString(t.getComment()), ValueNull.INSTANCE, ValueNull.INSTANCE, ValueNull.INSTANCE, ValueNull.INSTANCE, ValueNull.INSTANCE);
    }

    @Override
    public ResultInterface getSchemas() {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultInterface getCatalogs() {
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addRow(this.getString(this.session.getDatabase().getShortName()));
        return result;
    }

    @Override
    public ResultInterface getTableTypes() {
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_TYPE", TypeInfo.TYPE_VARCHAR);
        result.addRow(this.getString("BASE TABLE"));
        result.addRow(this.getString("GLOBAL TEMPORARY"));
        result.addRow(this.getString("LOCAL TEMPORARY"));
        result.addRow(this.getString("SYNONYM"));
        result.addRow(this.getString("VIEW"));
        return result;
    }

    @Override
    public ResultInterface getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("COLUMN_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("DATA_TYPE", TypeInfo.TYPE_INTEGER);
        result.addColumn("TYPE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("COLUMN_SIZE", TypeInfo.TYPE_INTEGER);
        result.addColumn("BUFFER_LENGTH", TypeInfo.TYPE_INTEGER);
        result.addColumn("DECIMAL_DIGITS", TypeInfo.TYPE_INTEGER);
        result.addColumn("NUM_PREC_RADIX", TypeInfo.TYPE_INTEGER);
        result.addColumn("NULLABLE", TypeInfo.TYPE_INTEGER);
        result.addColumn("REMARKS", TypeInfo.TYPE_VARCHAR);
        result.addColumn("COLUMN_DEF", TypeInfo.TYPE_VARCHAR);
        result.addColumn("SQL_DATA_TYPE", TypeInfo.TYPE_INTEGER);
        result.addColumn("SQL_DATETIME_SUB", TypeInfo.TYPE_INTEGER);
        result.addColumn("CHAR_OCTET_LENGTH", TypeInfo.TYPE_INTEGER);
        result.addColumn("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER);
        result.addColumn("IS_NULLABLE", TypeInfo.TYPE_VARCHAR);
        result.addColumn("SCOPE_CATALOG", TypeInfo.TYPE_VARCHAR);
        result.addColumn("SCOPE_SCHEMA", TypeInfo.TYPE_VARCHAR);
        result.addColumn("SCOPE_TABLE", TypeInfo.TYPE_VARCHAR);
        result.addColumn("SOURCE_DATA_TYPE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("IS_AUTOINCREMENT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("IS_GENERATEDCOLUMN", TypeInfo.TYPE_VARCHAR);
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        CompareLike columnLike = this.getLike(columnNamePattern);
        for (Schema schema : this.getSchemasForPattern(schemaPattern)) {
            Value schemaValue = this.getString(schema.getName());
            for (SchemaObject schemaObject : this.getTablesForPattern(schema, tableNamePattern)) {
                Value tableName = this.getString(schemaObject.getName());
                if (schemaObject instanceof Table) {
                    this.getColumnsAdd(result, catalogValue, schemaValue, tableName, (Table)schemaObject, columnLike);
                    continue;
                }
                TableSynonym s = (TableSynonym)schemaObject;
                Table t = s.getSynonymFor();
                this.getColumnsAdd(result, catalogValue, schemaValue, tableName, t, columnLike);
            }
        }
        result.sortRows(new SortOrder(this.session, new int[]{1, 2, 16}));
        return result;
    }

    private void getColumnsAdd(SimpleResult result, Value catalogValue, Value schemaValue, Value tableName, Table t, CompareLike columnLike) {
        int ordinal = 0;
        Column[] columnArray = t.getColumns();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            if (c.getVisible()) {
                ++ordinal;
                String name = c.getName();
                if (columnLike == null || columnLike.test(name)) {
                    TypeInfo type = c.getType();
                    ValueInteger precision = ValueInteger.get(MathUtils.convertLongToInt(type.getPrecision()));
                    boolean nullable = c.isNullable();
                    boolean isGenerated = c.isGenerated();
                    result.addRow(catalogValue, schemaValue, tableName, this.getString(name), ValueInteger.get(DataType.convertTypeToSQLType(type)), this.getDataTypeName(type), precision, ValueNull.INSTANCE, ValueInteger.get(type.getScale()), DatabaseMetaLocal.getRadix(type.getValueType(), false), nullable ? COLUMN_NULLABLE : COLUMN_NO_NULLS, this.getString(c.getComment()), isGenerated ? ValueNull.INSTANCE : this.getString(c.getDefaultSQL()), ValueNull.INSTANCE, ValueNull.INSTANCE, precision, ValueInteger.get(ordinal), nullable ? YES : NO, ValueNull.INSTANCE, ValueNull.INSTANCE, ValueNull.INSTANCE, ValueNull.INSTANCE, c.isIdentity() ? YES : NO, isGenerated ? YES : NO);
                }
            }
            ++n2;
        }
    }

    @Override
    public ResultInterface getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) {
        if (table == null) {
            throw DbException.getInvalidValueException("table", null);
        }
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("COLUMN_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("GRANTOR", TypeInfo.TYPE_VARCHAR);
        result.addColumn("GRANTEE", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PRIVILEGE", TypeInfo.TYPE_VARCHAR);
        result.addColumn("IS_GRANTABLE", TypeInfo.TYPE_VARCHAR);
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        CompareLike columnLike = this.getLike(columnNamePattern);
        for (Right r : db.getAllRights()) {
            Schema s;
            Table t;
            String tableName;
            DbObject object = r.getGrantedObject();
            if (!(object instanceof Table) || !db.equalsIdentifiers(table, tableName = (t = (Table)object).getName()) || !this.checkSchema(schema, s = t.getSchema())) continue;
            this.addPrivileges(result, catalogValue, s.getName(), tableName, r.getGrantee(), r.getRightMask(), columnLike, t.getColumns());
        }
        result.sortRows(new SortOrder(this.session, new int[]{3, 6}));
        return result;
    }

    @Override
    public ResultInterface getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) {
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("GRANTOR", TypeInfo.TYPE_VARCHAR);
        result.addColumn("GRANTEE", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PRIVILEGE", TypeInfo.TYPE_VARCHAR);
        result.addColumn("IS_GRANTABLE", TypeInfo.TYPE_VARCHAR);
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        CompareLike schemaLike = this.getLike(schemaPattern);
        CompareLike tableLike = this.getLike(tableNamePattern);
        for (Right r : db.getAllRights()) {
            DbObject object = r.getGrantedObject();
            if (!(object instanceof Table)) continue;
            Table table = (Table)object;
            String tableName = table.getName();
            if (tableLike != null && !tableLike.test(tableName)) continue;
            Schema schema = table.getSchema();
            String schemaName = schema.getName();
            if (schemaPattern != null && (schemaPattern.isEmpty() ? schema != db.getMainSchema() : !schemaLike.test(schemaName))) continue;
            this.addPrivileges(result, catalogValue, schemaName, tableName, r.getGrantee(), r.getRightMask(), null, null);
        }
        result.sortRows(new SortOrder(this.session, new int[]{1, 2, 5}));
        return result;
    }

    private void addPrivileges(SimpleResult result, Value catalogValue, String schemaName, String tableName, DbObject grantee, int rightMask, CompareLike columnLike, Column[] columns) {
        boolean isAdmin;
        Value schemaValue = this.getString(schemaName);
        Value tableValue = this.getString(tableName);
        Value granteeValue = this.getString(grantee.getName());
        boolean bl = isAdmin = grantee.getType() == 2 && ((User)grantee).isAdmin();
        if ((rightMask & 1) != 0) {
            this.addPrivilege(result, catalogValue, schemaValue, tableValue, granteeValue, "SELECT", isAdmin, columnLike, columns);
        }
        if ((rightMask & 4) != 0) {
            this.addPrivilege(result, catalogValue, schemaValue, tableValue, granteeValue, "INSERT", isAdmin, columnLike, columns);
        }
        if ((rightMask & 8) != 0) {
            this.addPrivilege(result, catalogValue, schemaValue, tableValue, granteeValue, "UPDATE", isAdmin, columnLike, columns);
        }
        if ((rightMask & 2) != 0) {
            this.addPrivilege(result, catalogValue, schemaValue, tableValue, granteeValue, "DELETE", isAdmin, columnLike, columns);
        }
    }

    private void addPrivilege(SimpleResult result, Value catalogValue, Value schemaValue, Value tableValue, Value granteeValue, String right, boolean isAdmin, CompareLike columnLike, Column[] columns) {
        if (columns == null) {
            result.addRow(catalogValue, schemaValue, tableValue, ValueNull.INSTANCE, granteeValue, this.getString(right), isAdmin ? YES : NO);
        } else {
            Column[] columnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                String columnName = column.getName();
                if (columnLike == null || columnLike.test(columnName)) {
                    result.addRow(catalogValue, schemaValue, tableValue, this.getString(columnName), ValueNull.INSTANCE, granteeValue, this.getString(right), isAdmin ? YES : NO);
                }
                ++n2;
            }
        }
    }

    @Override
    public ResultInterface getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        if (table == null) {
            throw DbException.getInvalidValueException("table", null);
        }
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("SCOPE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("COLUMN_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("DATA_TYPE", TypeInfo.TYPE_INTEGER);
        result.addColumn("TYPE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("COLUMN_SIZE", TypeInfo.TYPE_INTEGER);
        result.addColumn("BUFFER_LENGTH", TypeInfo.TYPE_INTEGER);
        result.addColumn("DECIMAL_DIGITS", TypeInfo.TYPE_SMALLINT);
        result.addColumn("PSEUDO_COLUMN", TypeInfo.TYPE_SMALLINT);
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        for (Schema s : this.getSchemas(schema)) {
            ArrayList<Constraint> constraints;
            Table t = s.findTableOrView(this.session, table);
            if (t == null || (constraints = t.getConstraints()) == null) continue;
            for (Constraint constraint : constraints) {
                if (constraint.getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                IndexColumn[] columns = ((ConstraintUnique)constraint).getColumns();
                int i = 0;
                int l = columns.length;
                while (i < l) {
                    IndexColumn ic = columns[i];
                    Column c = ic.column;
                    TypeInfo type = c.getType();
                    DataType dt = DataType.getDataType(type.getValueType());
                    result.addRow(BEST_ROW_SESSION, this.getString(c.getName()), ValueInteger.get(DataType.convertTypeToSQLType(type)), this.getDataTypeName(type), ValueInteger.get(MathUtils.convertLongToInt(type.getPrecision())), ValueNull.INSTANCE, dt.supportsScale ? ValueSmallint.get(MathUtils.convertIntToShort(type.getScale())) : ValueNull.INSTANCE, BEST_ROW_NOT_PSEUDO);
                    ++i;
                }
            }
        }
        return result;
    }

    private Value getDataTypeName(TypeInfo typeInfo) {
        return this.getString(typeInfo.getDeclaredTypeName());
    }

    @Override
    public ResultInterface getPrimaryKeys(String catalog, String schema, String table) {
        if (table == null) {
            throw DbException.getInvalidValueException("table", null);
        }
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("COLUMN_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("KEY_SEQ", TypeInfo.TYPE_SMALLINT);
        result.addColumn("PK_NAME", TypeInfo.TYPE_VARCHAR);
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        for (Schema s : this.getSchemas(schema)) {
            ArrayList<Constraint> constraints;
            Table t = s.findTableOrView(this.session, table);
            if (t == null || (constraints = t.getConstraints()) == null) continue;
            for (Constraint constraint : constraints) {
                if (constraint.getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                Value schemaValue = this.getString(s.getName());
                Value tableValue = this.getString(t.getName());
                Value pkValue = this.getString(constraint.getName());
                IndexColumn[] columns = ((ConstraintUnique)constraint).getColumns();
                int i = 0;
                int l = columns.length;
                while (i < l) {
                    result.addRow(catalogValue, schemaValue, tableValue, this.getString(columns[i].column.getName()), ValueSmallint.get((short)(++i)), pkValue);
                }
            }
        }
        result.sortRows(new SortOrder(this.session, new int[]{3}));
        return result;
    }

    @Override
    public ResultInterface getImportedKeys(String catalog, String schema, String table) {
        if (table == null) {
            throw DbException.getInvalidValueException("table", null);
        }
        SimpleResult result = this.initCrossReferenceResult();
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        for (Schema s : this.getSchemas(schema)) {
            ArrayList<Constraint> constraints;
            Table t = s.findTableOrView(this.session, table);
            if (t == null || (constraints = t.getConstraints()) == null) continue;
            for (Constraint constraint : constraints) {
                ConstraintReferential fk;
                Table fkTable;
                if (constraint.getConstraintType() != Constraint.Type.REFERENTIAL || (fkTable = (fk = (ConstraintReferential)constraint).getTable()) != t) continue;
                Table pkTable = fk.getRefTable();
                this.addCrossReferenceResult(result, catalogValue, pkTable.getSchema().getName(), pkTable, fkTable.getSchema().getName(), fkTable, fk);
            }
        }
        result.sortRows(new SortOrder(this.session, new int[]{1, 2, 8}));
        return result;
    }

    @Override
    public ResultInterface getExportedKeys(String catalog, String schema, String table) {
        if (table == null) {
            throw DbException.getInvalidValueException("table", null);
        }
        SimpleResult result = this.initCrossReferenceResult();
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        for (Schema s : this.getSchemas(schema)) {
            ArrayList<Constraint> constraints;
            Table t = s.findTableOrView(this.session, table);
            if (t == null || (constraints = t.getConstraints()) == null) continue;
            for (Constraint constraint : constraints) {
                ConstraintReferential fk;
                Table pkTable;
                if (constraint.getConstraintType() != Constraint.Type.REFERENTIAL || (pkTable = (fk = (ConstraintReferential)constraint).getRefTable()) != t) continue;
                Table fkTable = fk.getTable();
                this.addCrossReferenceResult(result, catalogValue, pkTable.getSchema().getName(), pkTable, fkTable.getSchema().getName(), fkTable, fk);
            }
        }
        result.sortRows(new SortOrder(this.session, new int[]{5, 6, 8}));
        return result;
    }

    @Override
    public ResultInterface getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        if (primaryTable == null) {
            throw DbException.getInvalidValueException("primaryTable", null);
        }
        if (foreignTable == null) {
            throw DbException.getInvalidValueException("foreignTable", null);
        }
        SimpleResult result = this.initCrossReferenceResult();
        if (!this.checkCatalogName(primaryCatalog) || !this.checkCatalogName(foreignCatalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        for (Schema s : this.getSchemas(foreignSchema)) {
            ArrayList<Constraint> constraints;
            Table t = s.findTableOrView(this.session, foreignTable);
            if (t == null || (constraints = t.getConstraints()) == null) continue;
            for (Constraint constraint : constraints) {
                Schema pkSchema;
                Table pkTable;
                ConstraintReferential fk;
                Table fkTable;
                if (constraint.getConstraintType() != Constraint.Type.REFERENTIAL || (fkTable = (fk = (ConstraintReferential)constraint).getTable()) != t || !db.equalsIdentifiers((pkTable = fk.getRefTable()).getName(), primaryTable) || !this.checkSchema(primarySchema, pkSchema = pkTable.getSchema())) continue;
                this.addCrossReferenceResult(result, catalogValue, pkSchema.getName(), pkTable, fkTable.getSchema().getName(), fkTable, fk);
            }
        }
        result.sortRows(new SortOrder(this.session, new int[]{5, 6, 8}));
        return result;
    }

    private SimpleResult initCrossReferenceResult() {
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("PKTABLE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PKTABLE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PKTABLE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PKCOLUMN_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("FKTABLE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("FKTABLE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("FKTABLE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("FKCOLUMN_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("KEY_SEQ", TypeInfo.TYPE_SMALLINT);
        result.addColumn("UPDATE_RULE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("DELETE_RULE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("FK_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("PK_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("DEFERRABILITY", TypeInfo.TYPE_SMALLINT);
        return result;
    }

    private void addCrossReferenceResult(SimpleResult result, Value catalog, String pkSchema, Table pkTable, String fkSchema, Table fkTable, ConstraintReferential fk) {
        Value pkSchemaValue = this.getString(pkSchema);
        Value pkTableValue = this.getString(pkTable.getName());
        Value fkSchemaValue = this.getString(fkSchema);
        Value fkTableValue = this.getString(fkTable.getName());
        IndexColumn[] pkCols = fk.getRefColumns();
        IndexColumn[] fkCols = fk.getColumns();
        ValueSmallint update = DatabaseMetaLocal.getRefAction(fk.getUpdateAction());
        ValueSmallint delete = DatabaseMetaLocal.getRefAction(fk.getDeleteAction());
        Value fkNameValue = this.getString(fk.getName());
        Value pkNameValue = this.getString(fk.getReferencedConstraint().getName());
        int j = 0;
        int len = fkCols.length;
        while (j < len) {
            result.addRow(catalog, pkSchemaValue, pkTableValue, this.getString(pkCols[j].column.getName()), catalog, fkSchemaValue, fkTableValue, this.getString(fkCols[j].column.getName()), ValueSmallint.get((short)(j + 1)), update, delete, fkNameValue, pkNameValue, IMPORTED_KEY_NOT_DEFERRABLE);
            ++j;
        }
    }

    private static ValueSmallint getRefAction(ConstraintActionType action) {
        switch (action) {
            case CASCADE: {
                return IMPORTED_KEY_CASCADE;
            }
            case RESTRICT: {
                return IMPORTED_KEY_RESTRICT;
            }
            case SET_DEFAULT: {
                return IMPORTED_KEY_DEFAULT;
            }
            case SET_NULL: {
                return IMPORTED_KEY_SET_NULL;
            }
        }
        throw DbException.getInternalError("action=" + String.valueOf((Object)action));
    }

    @Override
    public ResultInterface getTypeInfo() {
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("TYPE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("DATA_TYPE", TypeInfo.TYPE_INTEGER);
        result.addColumn("PRECISION", TypeInfo.TYPE_INTEGER);
        result.addColumn("LITERAL_PREFIX", TypeInfo.TYPE_VARCHAR);
        result.addColumn("LITERAL_SUFFIX", TypeInfo.TYPE_VARCHAR);
        result.addColumn("CREATE_PARAMS", TypeInfo.TYPE_VARCHAR);
        result.addColumn("NULLABLE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("CASE_SENSITIVE", TypeInfo.TYPE_BOOLEAN);
        result.addColumn("SEARCHABLE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("UNSIGNED_ATTRIBUTE", TypeInfo.TYPE_BOOLEAN);
        result.addColumn("FIXED_PREC_SCALE", TypeInfo.TYPE_BOOLEAN);
        result.addColumn("AUTO_INCREMENT", TypeInfo.TYPE_BOOLEAN);
        result.addColumn("LOCAL_TYPE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("MINIMUM_SCALE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("MAXIMUM_SCALE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("SQL_DATA_TYPE", TypeInfo.TYPE_INTEGER);
        result.addColumn("SQL_DATETIME_SUB", TypeInfo.TYPE_INTEGER);
        result.addColumn("NUM_PREC_RADIX", TypeInfo.TYPE_INTEGER);
        int i = 1;
        int l = 42;
        while (i < l) {
            DataType t = DataType.getDataType(i);
            Value name = this.getString(Value.getTypeName(t.type));
            result.addRow(name, ValueInteger.get(t.sqlType), ValueInteger.get(MathUtils.convertLongToInt(t.maxPrecision)), this.getString(t.prefix), this.getString(t.suffix), this.getString(t.params), TYPE_NULLABLE, ValueBoolean.get(t.caseSensitive), TYPE_SEARCHABLE, ValueBoolean.FALSE, ValueBoolean.get(t.type == 13), ValueBoolean.get(DataType.isNumericType(i)), name, ValueSmallint.get(MathUtils.convertIntToShort(t.minScale)), ValueSmallint.get(MathUtils.convertIntToShort(t.maxScale)), ValueNull.INSTANCE, ValueNull.INSTANCE, DatabaseMetaLocal.getRadix(t.type, false));
            ++i;
        }
        result.sortRows(new SortOrder(this.session, new int[]{1}));
        return result;
    }

    private static Value getRadix(int valueType, boolean small) {
        if (DataType.isNumericType(valueType)) {
            int radix = valueType == 13 || valueType == 16 ? 10 : 2;
            return small ? ValueSmallint.get((short)radix) : ValueInteger.get(radix);
        }
        return ValueNull.INSTANCE;
    }

    @Override
    public ResultInterface getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        if (table == null) {
            throw DbException.getInvalidValueException("table", null);
        }
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_CAT", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("NON_UNIQUE", TypeInfo.TYPE_BOOLEAN);
        result.addColumn("INDEX_QUALIFIER", TypeInfo.TYPE_VARCHAR);
        result.addColumn("INDEX_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TYPE", TypeInfo.TYPE_SMALLINT);
        result.addColumn("ORDINAL_POSITION", TypeInfo.TYPE_SMALLINT);
        result.addColumn("COLUMN_NAME", TypeInfo.TYPE_VARCHAR);
        result.addColumn("ASC_OR_DESC", TypeInfo.TYPE_VARCHAR);
        result.addColumn("CARDINALITY", TypeInfo.TYPE_BIGINT);
        result.addColumn("PAGES", TypeInfo.TYPE_BIGINT);
        result.addColumn("FILTER_CONDITION", TypeInfo.TYPE_VARCHAR);
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        for (Schema s : this.getSchemas(schema)) {
            Table t = s.findTableOrView(this.session, table);
            if (t == null) continue;
            this.getIndexInfo(catalogValue, this.getString(s.getName()), t, unique, approximate, result, db);
        }
        result.sortRows(new SortOrder(this.session, new int[]{3, 6, 5, 7}));
        return result;
    }

    private void getIndexInfo(Value catalogValue, Value schemaValue, Table table, boolean unique, boolean approximate, SimpleResult result, Database db) {
        ArrayList<Index> indexes = table.getIndexes();
        if (indexes != null) {
            block0: for (Index index : indexes) {
                if (index.getCreateSQL() == null) continue;
                int uniqueColumnCount = index.getUniqueColumnCount();
                if (unique && uniqueColumnCount == 0) continue;
                Value tableValue = this.getString(table.getName());
                Value indexValue = this.getString(index.getName());
                IndexColumn[] cols = index.getIndexColumns();
                ValueSmallint type = index.getIndexType().isHash() ? TABLE_INDEX_HASHED : TABLE_INDEX_OTHER;
                int i = 0;
                int l = cols.length;
                while (i < l) {
                    boolean nonUnique;
                    IndexColumn c = cols[i];
                    boolean bl = nonUnique = i >= uniqueColumnCount;
                    if (unique && nonUnique) continue block0;
                    result.addRow(catalogValue, schemaValue, tableValue, ValueBoolean.get(nonUnique), catalogValue, indexValue, type, ValueSmallint.get((short)(i + 1)), this.getString(c.column.getName()), this.getString((c.sortType & 1) != 0 ? "D" : "A"), ValueBigint.get(approximate ? index.getRowCountApproximation(this.session) : index.getRowCount(this.session)), ValueBigint.get(index.getDiskSpaceUsed() / (long)db.getPageSize()), ValueNull.INSTANCE);
                    ++i;
                }
            }
        }
    }

    @Override
    public ResultInterface getSchemas(String catalog, String schemaPattern) {
        this.checkClosed();
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_SCHEM", TypeInfo.TYPE_VARCHAR);
        result.addColumn("TABLE_CATALOG", TypeInfo.TYPE_VARCHAR);
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        CompareLike schemaLike = this.getLike(schemaPattern);
        Collection<Schema> allSchemas = this.session.getDatabase().getAllSchemas();
        Value catalogValue = this.getString(this.session.getDatabase().getShortName());
        if (schemaLike == null) {
            for (Schema s : allSchemas) {
                result.addRow(this.getString(s.getName()), catalogValue);
            }
        } else {
            for (Schema s : allSchemas) {
                String name = s.getName();
                if (!schemaLike.test(name)) continue;
                result.addRow(this.getString(s.getName()), catalogValue);
            }
        }
        result.sortRows(new SortOrder(this.session, new int[1]));
        return result;
    }

    @Override
    public ResultInterface getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        SimpleResult result = this.getPseudoColumnsResult();
        if (!this.checkCatalogName(catalog)) {
            return result;
        }
        Database db = this.session.getDatabase();
        Value catalogValue = this.getString(db.getShortName());
        CompareLike columnLike = this.getLike(columnNamePattern);
        for (Schema schema : this.getSchemasForPattern(schemaPattern)) {
            Value schemaValue = this.getString(schema.getName());
            for (SchemaObject schemaObject : this.getTablesForPattern(schema, tableNamePattern)) {
                Value tableName = this.getString(schemaObject.getName());
                if (schemaObject instanceof Table) {
                    this.getPseudoColumnsAdd(result, catalogValue, schemaValue, tableName, (Table)schemaObject, columnLike);
                    continue;
                }
                TableSynonym s = (TableSynonym)schemaObject;
                Table t = s.getSynonymFor();
                this.getPseudoColumnsAdd(result, catalogValue, schemaValue, tableName, t, columnLike);
            }
        }
        result.sortRows(new SortOrder(this.session, new int[]{1, 2, 3}));
        return result;
    }

    private void getPseudoColumnsAdd(SimpleResult result, Value catalogValue, Value schemaValue, Value tableName, Table t, CompareLike columnLike) {
        Column rowId = t.getRowIdColumn();
        if (rowId != null) {
            this.getPseudoColumnsAdd(result, catalogValue, schemaValue, tableName, columnLike, rowId);
        }
        Column[] columnArray = t.getColumns();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            if (!c.getVisible()) {
                this.getPseudoColumnsAdd(result, catalogValue, schemaValue, tableName, columnLike, c);
            }
            ++n2;
        }
    }

    private void getPseudoColumnsAdd(SimpleResult result, Value catalogValue, Value schemaValue, Value tableName, CompareLike columnLike, Column c) {
        String name = c.getName();
        if (columnLike != null && !columnLike.test(name)) {
            return;
        }
        TypeInfo type = c.getType();
        ValueInteger precision = ValueInteger.get(MathUtils.convertLongToInt(type.getPrecision()));
        result.addRow(catalogValue, schemaValue, tableName, this.getString(name), ValueInteger.get(DataType.convertTypeToSQLType(type)), precision, ValueInteger.get(type.getScale()), DatabaseMetaLocal.getRadix(type.getValueType(), false), NO_USAGE_RESTRICTIONS, this.getString(c.getComment()), precision, c.isNullable() ? YES : NO);
    }

    @Override
    void checkClosed() {
        if (this.session.isClosed()) {
            throw DbException.get(90121);
        }
    }

    Value getString(String string) {
        return string != null ? ValueVarchar.get(string, this.session) : ValueNull.INSTANCE;
    }

    private boolean checkCatalogName(String catalog) {
        if (catalog != null && !catalog.isEmpty()) {
            Database db = this.session.getDatabase();
            return db.equalsIdentifiers(catalog, db.getShortName());
        }
        return true;
    }

    private Collection<Schema> getSchemas(String schema) {
        Database db = this.session.getDatabase();
        if (schema == null) {
            return db.getAllSchemas();
        }
        if (schema.isEmpty()) {
            return Collections.singleton(db.getMainSchema());
        }
        Schema s = db.findSchema(schema);
        if (s != null) {
            return Collections.singleton(s);
        }
        return Collections.emptySet();
    }

    private Collection<Schema> getSchemasForPattern(String schemaPattern) {
        Database db = this.session.getDatabase();
        if (schemaPattern == null) {
            return db.getAllSchemas();
        }
        if (schemaPattern.isEmpty()) {
            return Collections.singleton(db.getMainSchema());
        }
        ArrayList<Schema> list = Utils.newSmallArrayList();
        CompareLike like = this.getLike(schemaPattern);
        for (Schema s : db.getAllSchemas()) {
            if (!like.test(s.getName())) continue;
            list.add(s);
        }
        return list;
    }

    private Collection<? extends SchemaObject> getTablesForPattern(Schema schema, String tablePattern) {
        Collection<Table> tables = schema.getAllTablesAndViews(this.session);
        Collection<TableSynonym> synonyms = schema.getAllSynonyms();
        if (tablePattern == null) {
            if (tables.isEmpty()) {
                return synonyms;
            }
            if (synonyms.isEmpty()) {
                return tables;
            }
            ArrayList<SchemaObject> list = new ArrayList<SchemaObject>(tables.size() + synonyms.size());
            list.addAll(tables);
            list.addAll(synonyms);
            return list;
        }
        if (tables.isEmpty() && synonyms.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList list = Utils.newSmallArrayList();
        CompareLike like = this.getLike(tablePattern);
        for (Table table : tables) {
            if (!like.test(table.getName())) continue;
            list.add(table);
        }
        for (TableSynonym tableSynonym : synonyms) {
            if (!like.test(tableSynonym.getName())) continue;
            list.add(tableSynonym);
        }
        return list;
    }

    private boolean checkSchema(String schemaName, Schema schema) {
        if (schemaName == null) {
            return true;
        }
        if (schemaName.isEmpty()) {
            return schema == this.session.getDatabase().getMainSchema();
        }
        return this.session.getDatabase().equalsIdentifiers(schemaName, schema.getName());
    }

    private CompareLike getLike(String pattern) {
        if (pattern == null) {
            return null;
        }
        CompareLike like = new CompareLike(this.session.getDatabase().getCompareMode(), "\\", null, false, false, null, null, CompareLike.LikeType.LIKE);
        like.initPattern(pattern, Character.valueOf('\\'));
        return like;
    }
}

