/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.h2.engine.SysProperties;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JdbcDataSourceFactory
implements ObjectFactory {
    private static final TraceSystem traceSystem = new TraceSystem(SysProperties.CLIENT_TRACE_DIRECTORY + "h2datasource.trace.db");
    private final Trace trace = traceSystem.getTrace(14);

    static {
        traceSystem.setLevelFile(SysProperties.DATASOURCE_TRACE_LEVEL);
    }

    @Override
    public synchronized Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) {
        Reference ref;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("getObjectInstance obj={0} name={1} nameCtx={2} environment={3}", obj, name, nameCtx, environment);
        }
        if (obj instanceof Reference && (ref = (Reference)obj).getClassName().equals(JdbcDataSource.class.getName())) {
            JdbcDataSource dataSource = new JdbcDataSource();
            dataSource.setURL((String)ref.get("url").getContent());
            dataSource.setUser((String)ref.get("user").getContent());
            dataSource.setPassword((String)ref.get("password").getContent());
            dataSource.setDescription((String)ref.get("description").getContent());
            String s = (String)ref.get("loginTimeout").getContent();
            dataSource.setLoginTimeout(Integer.parseInt(s));
            return dataSource;
        }
        return null;
    }

    public static TraceSystem getTraceSystem() {
        return traceSystem;
    }

    Trace getTrace() {
        return this.trace;
    }
}

