/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.util.Base64;
import javax.transaction.xa.Xid;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.message.DbException;
import org.h2.message.TraceObject;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JdbcXid
extends TraceObject
implements Xid {
    private static final String PREFIX = "XID";
    private static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();
    private final int formatId;
    private final byte[] branchQualifier;
    private final byte[] globalTransactionId;

    JdbcXid(JdbcDataSourceFactory factory, int id, String tid) {
        this.setTrace(factory.getTrace(), 15, id);
        try {
            String[] splits = tid.split("\\|");
            if (splits.length == 4 && PREFIX.equals(splits[0])) {
                this.formatId = Integer.parseInt(splits[1]);
                Base64.Decoder decoder = Base64.getUrlDecoder();
                this.branchQualifier = decoder.decode(splits[2]);
                this.globalTransactionId = decoder.decode(splits[3]);
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw DbException.get(90101, tid);
    }

    static StringBuilder toString(StringBuilder builder, Xid xid) {
        return builder.append(PREFIX).append('|').append(xid.getFormatId()).append('|').append(ENCODER.encodeToString(xid.getBranchQualifier())).append('|').append(ENCODER.encodeToString(xid.getGlobalTransactionId()));
    }

    @Override
    public int getFormatId() {
        this.debugCodeCall("getFormatId");
        return this.formatId;
    }

    @Override
    public byte[] getBranchQualifier() {
        this.debugCodeCall("getBranchQualifier");
        return this.branchQualifier;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        this.debugCodeCall("getGlobalTransactionId");
        return this.globalTransactionId;
    }
}

