/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.h2.api.ErrorCode;
import org.h2.jdbc.JdbcException;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceWriter;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TraceSystem
implements TraceWriter {
    public static final int PARENT = -1;
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int ADAPTER = 4;
    public static final int DEFAULT_TRACE_LEVEL_SYSTEM_OUT = 0;
    public static final int DEFAULT_TRACE_LEVEL_FILE = 1;
    private static final int DEFAULT_MAX_FILE_SIZE = 0x4000000;
    private static final int CHECK_SIZE_EACH_WRITES = 4096;
    private static DateTimeFormatter DATE_TIME_FORMATTER;
    private int levelSystemOut = 0;
    private int levelFile = 1;
    private int levelMax;
    private int maxFileSize = 0x4000000;
    private String fileName;
    private final AtomicReferenceArray<Trace> traces = new AtomicReferenceArray(Trace.MODULE_NAMES.length);
    private Writer fileWriter;
    private PrintWriter printWriter;
    private int checkSize = -1;
    private boolean closed;
    private boolean writingErrorLogged;
    private TraceWriter writer = this;
    private PrintStream sysOut = System.out;

    public TraceSystem(String fileName) {
        this.fileName = fileName;
        this.updateLevel();
    }

    private void updateLevel() {
        this.levelMax = Math.max(this.levelSystemOut, this.levelFile);
    }

    public void setSysOut(PrintStream out) {
        this.sysOut = out;
    }

    public Trace getTrace(int moduleId) {
        Trace t = this.traces.get(moduleId);
        if (t == null && !this.traces.compareAndSet(moduleId, null, t = new Trace(this.writer, moduleId))) {
            t = this.traces.get(moduleId);
        }
        return t;
    }

    public Trace getTrace(String module) {
        return new Trace(this.writer, module);
    }

    @Override
    public boolean isEnabled(int level) {
        if (this.levelMax == 4) {
            return this.writer.isEnabled(level);
        }
        return level <= this.levelMax;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public void setMaxFileSize(int max) {
        this.maxFileSize = max;
    }

    public void setLevelSystemOut(int level) {
        if (level < -1 || level > 3) {
            throw DbException.getInvalidValueException("TRACE_LEVEL_SYSTEM_OUT", level);
        }
        this.levelSystemOut = level;
        this.updateLevel();
    }

    public void setLevelFile(int level) {
        if (level == 4) {
            String adapterClass = "org.h2.message.TraceWriterAdapter";
            try {
                this.writer = (TraceWriter)Class.forName(adapterClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e2) {
                DbException e2 = DbException.get(90086, e2, adapterClass);
                this.write(1, 2, adapterClass, (Throwable)e2);
                return;
            }
            String name = this.fileName;
            if (name != null) {
                int idx;
                if (name.endsWith(".trace.db")) {
                    name = name.substring(0, name.length() - ".trace.db".length());
                }
                if ((idx = Math.max(name.lastIndexOf(47), name.lastIndexOf(92))) >= 0) {
                    name = name.substring(idx + 1);
                }
                this.writer.setName(name);
            }
        } else if (level < -1 || level > 3) {
            throw DbException.getInvalidValueException("TRACE_LEVEL_FILE", level);
        }
        this.levelFile = level;
        this.updateLevel();
    }

    public int getLevelFile() {
        return this.levelFile;
    }

    private static String format(String module, String s) {
        DateTimeFormatter dateTimeFormatter = DATE_TIME_FORMATTER;
        if (dateTimeFormatter == null) {
            dateTimeFormatter = TraceSystem.initTimeFormatter();
        }
        return dateTimeFormatter.format(OffsetDateTime.now()) + " " + module + ": " + s;
    }

    private static DateTimeFormatter initTimeFormatter() {
        DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 6, 6, true).appendOffsetId().toFormatter(Locale.ROOT);
        return DATE_TIME_FORMATTER;
    }

    @Override
    public void write(int level, int moduleId, String s, Throwable t) {
        this.write(level, Trace.MODULE_NAMES[moduleId], s, t);
    }

    @Override
    public void write(int level, String module, String s, Throwable t) {
        boolean logToFile;
        boolean logToSystemOut = level <= this.levelSystemOut || level > this.levelMax;
        boolean bl = logToFile = this.fileName != null && level <= this.levelFile;
        if (logToSystemOut || logToFile) {
            String row = TraceSystem.format(module, s);
            if (logToSystemOut) {
                this.sysOut.println(row);
                if (t != null && this.levelSystemOut == 3) {
                    t.printStackTrace(this.sysOut);
                }
            }
            if (logToFile) {
                this.writeFile(row, t);
            }
        }
    }

    private synchronized void writeFile(String s, Throwable t) {
        try {
            this.checkSize = (this.checkSize + 1) % 4096;
            if (this.checkSize == 0) {
                this.closeWriter();
                if (this.maxFileSize > 0 && FileUtils.size(this.fileName) > (long)this.maxFileSize) {
                    String old = this.fileName + ".old";
                    FileUtils.delete(old);
                    FileUtils.move(this.fileName, old);
                }
            }
            if (!this.openWriter()) {
                return;
            }
            this.printWriter.println(s);
            if (t != null) {
                if (this.levelFile == 1 && t instanceof JdbcException) {
                    JdbcException se = (JdbcException)((Object)t);
                    int code = se.getErrorCode();
                    if (ErrorCode.isCommon(code)) {
                        this.printWriter.println(t);
                    } else {
                        t.printStackTrace(this.printWriter);
                    }
                } else {
                    t.printStackTrace(this.printWriter);
                }
            }
            this.printWriter.flush();
            if (this.closed) {
                this.closeWriter();
            }
        }
        catch (Exception e) {
            this.logWritingError(e);
        }
    }

    private void logWritingError(Exception e) {
        if (this.writingErrorLogged) {
            return;
        }
        this.writingErrorLogged = true;
        DbException se = DbException.get(90034, e, this.fileName, e.toString());
        this.fileName = null;
        this.sysOut.println(se);
        se.printStackTrace();
    }

    private boolean openWriter() {
        if (this.printWriter == null) {
            block4: {
                try {
                    FileUtils.createDirectories(FileUtils.getParent(this.fileName));
                    if (!FileUtils.exists(this.fileName) || FileUtils.canWrite(this.fileName)) break block4;
                    return false;
                }
                catch (Exception e) {
                    this.logWritingError(e);
                    return false;
                }
            }
            this.fileWriter = IOUtils.getBufferedWriter(FileUtils.newOutputStream(this.fileName, true));
            this.printWriter = new PrintWriter(this.fileWriter, true);
        }
        return true;
    }

    private synchronized void closeWriter() {
        if (this.printWriter != null) {
            this.printWriter.flush();
            this.printWriter.close();
            this.printWriter = null;
        }
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileWriter = null;
        }
    }

    public void close() {
        this.closeWriter();
        this.closed = true;
    }

    @Override
    public void setName(String name) {
    }
}

