/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.CurrentDateTimeValueFunction;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.mode.CompatibilityDateTimeValueFunction;
import org.h2.mode.FunctionInfo;
import org.h2.mode.FunctionsDB2Derby;
import org.h2.mode.FunctionsLegacy;
import org.h2.mode.FunctionsMSSQLServer;
import org.h2.mode.FunctionsMySQL;
import org.h2.mode.FunctionsOracle;
import org.h2.mode.FunctionsPostgreSQL;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ModeFunction
extends FunctionN {
    protected static final int VAR_ARGS = -1;
    protected final FunctionInfo info;

    public static ModeFunction getFunction(Database database, String name) {
        Mode.ModeEnum modeEnum = database.getMode().getEnum();
        if (modeEnum != Mode.ModeEnum.REGULAR) {
            return ModeFunction.getCompatibilityModeFunction(name, modeEnum);
        }
        return null;
    }

    private static ModeFunction getCompatibilityModeFunction(String name, Mode.ModeEnum modeEnum) {
        switch (modeEnum) {
            case LEGACY: {
                return FunctionsLegacy.getFunction(name);
            }
            case DB2: 
            case Derby: {
                return FunctionsDB2Derby.getFunction(name);
            }
            case MSSQLServer: {
                return FunctionsMSSQLServer.getFunction(name);
            }
            case MariaDB: 
            case MySQL: {
                return FunctionsMySQL.getFunction(name);
            }
            case Oracle: {
                return FunctionsOracle.getFunction(name);
            }
            case PostgreSQL: {
                return FunctionsPostgreSQL.getFunction(name);
            }
        }
        return null;
    }

    public static Expression getCompatibilityDateTimeValueFunction(Database database, String name, int scale) {
        switch (name) {
            case "SYSDATE": {
                switch (database.getMode().getEnum()) {
                    case LEGACY: 
                    case HSQLDB: 
                    case Oracle: {
                        return new CompatibilityDateTimeValueFunction(0, -1);
                    }
                }
                break;
            }
            case "SYSTIMESTAMP": {
                switch (database.getMode().getEnum()) {
                    case LEGACY: 
                    case Oracle: {
                        return new CompatibilityDateTimeValueFunction(1, scale);
                    }
                }
                break;
            }
            case "TODAY": {
                switch (database.getMode().getEnum()) {
                    case LEGACY: 
                    case HSQLDB: {
                        return new CurrentDateTimeValueFunction(0, scale);
                    }
                }
            }
        }
        return null;
    }

    ModeFunction(FunctionInfo info) {
        super(new Expression[info.parameterCount != -1 ? info.parameterCount : 4]);
        this.info = info;
    }

    static Value getNullOrValue(SessionLocal session, Expression[] args, Value[] values, int i) {
        if (i >= args.length) {
            return null;
        }
        Value v = values[i];
        if (v == null) {
            Expression e = args[i];
            if (e == null) {
                return null;
            }
            v = values[i] = e.getValue(session);
        }
        return v;
    }

    final Value[] getArgumentsValues(SessionLocal session, Expression[] args) {
        Value[] values = new Value[args.length];
        if (this.info.nullIfParameterIsNull) {
            int i = 0;
            int l = args.length;
            while (i < l) {
                Value v = args[i].getValue(session);
                if (v == ValueNull.INSTANCE) {
                    return null;
                }
                values[i] = v;
                ++i;
            }
        }
        return values;
    }

    void checkParameterCount(int len) {
        throw DbException.getInternalError("type=" + this.info.type);
    }

    @Override
    public void doneWithParameters() {
        int count = this.info.parameterCount;
        if (count == -1) {
            this.checkParameterCount(this.argsCount);
            super.doneWithParameters();
        } else if (count != this.argsCount) {
            throw DbException.get(7001, this.info.name, Integer.toString(this.argsCount));
        }
    }

    final boolean optimizeArguments(SessionLocal session) {
        return this.optimizeArguments(session, this.info.deterministic);
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!super.isEverything(visitor)) {
            return false;
        }
        switch (visitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return this.info.deterministic;
            }
        }
        return true;
    }
}

