/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import java.util.HashMap;
import java.util.Map;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.mode.PgCatalogTable;
import org.h2.schema.MetaSchema;
import org.h2.table.Table;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class PgCatalogSchema
extends MetaSchema {
    private volatile HashMap<String, Table> tables;

    public PgCatalogSchema(Database database, User owner) {
        super(database, -1000, database.sysIdentifier("PG_CATALOG"), owner);
    }

    @Override
    protected Map<String, Table> getMap(SessionLocal session) {
        HashMap<String, Table> map = this.tables;
        if (map == null) {
            map = this.fillMap();
        }
        return map;
    }

    private synchronized HashMap<String, Table> fillMap() {
        HashMap<String, Table> map = this.tables;
        if (map == null) {
            map = this.database.newStringMap();
            int type = 0;
            while (type < 19) {
                PgCatalogTable table = new PgCatalogTable(this, -1000 - type, type);
                map.put(table.getName(), table);
                ++type;
            }
            this.tables = map;
        }
        return map;
    }
}

