/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.ZipOutputStream;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MFChunk;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.cache.FilePathCache;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.encrypt.FileEncrypt;
import org.h2.store.fs.encrypt.FilePathEncrypt;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AppendOnlyMultiFileStore
extends FileStore<MFChunk> {
    private final int maxFileCount;
    private long creationTime;
    private int volumeId;
    private int fileCount;
    private FileChannel fileChannel;
    private FileChannel originalFileChannel;
    private final FileChannel[] fileChannels;
    private FileLock fileLock;
    private final Map<String, Object> config;

    public AppendOnlyMultiFileStore(Map<String, Object> config) {
        super(config);
        this.config = config;
        this.maxFileCount = DataUtils.getConfigParam(config, "maxFileCount", 16);
        this.fileChannels = new FileChannel[this.maxFileCount];
    }

    @Override
    protected final MFChunk createChunk(int newChunkId) {
        return new MFChunk(newChunkId);
    }

    @Override
    public MFChunk createChunk(String s) {
        return new MFChunk(s);
    }

    @Override
    protected MFChunk createChunk(Map<String, String> map) {
        return new MFChunk(map);
    }

    @Override
    public boolean shouldSaveNow(int unsavedMemory, int autoCommitMemory) {
        return unsavedMemory > autoCommitMemory;
    }

    @Override
    public void open(String fileName, boolean readOnly, char[] encryptionKey) {
        this.open(fileName, readOnly, encryptionKey == null ? null : fileChannel -> new FileEncrypt(fileName, FilePathEncrypt.getPasswordBytes(encryptionKey), (FileChannel)fileChannel));
    }

    public AppendOnlyMultiFileStore open(String fileName, boolean readOnly) {
        AppendOnlyMultiFileStore result = new AppendOnlyMultiFileStore(this.config);
        result.open(fileName, readOnly, this.originalFileChannel == null ? null : fileChannel -> new FileEncrypt(fileName, (FileEncrypt)this.fileChannel, (FileChannel)fileChannel));
        return result;
    }

    private void open(String fileName, boolean readOnly, Function<FileChannel, FileChannel> encryptionTransformer) {
        if (this.fileChannel != null && this.fileChannel.isOpen()) {
            return;
        }
        FilePathCache.INSTANCE.getScheme();
        FilePath f = FilePath.get(fileName);
        FilePath parent = f.getParent();
        if (parent != null && !parent.exists()) {
            throw DataUtils.newIllegalArgumentException("Directory does not exist: {0}", parent);
        }
        if (f.exists() && !f.canWrite()) {
            readOnly = true;
        }
        this.init(fileName, readOnly);
        try {
            this.fileChannel = f.open(readOnly ? "r" : "rw");
            if (encryptionTransformer != null) {
                this.originalFileChannel = this.fileChannel;
                this.fileChannel = encryptionTransformer.apply(this.fileChannel);
            }
            try {
                this.fileLock = this.fileChannel.tryLock(0L, Long.MAX_VALUE, readOnly);
            }
            catch (OverlappingFileLockException e) {
                throw DataUtils.newMVStoreException(7, "The file is locked: {0}", fileName, e);
            }
            if (this.fileLock == null) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw DataUtils.newMVStoreException(7, "The file is locked: {0}", fileName);
            }
            this.saveChunkLock.lock();
            try {
                this.setSize(this.fileChannel.size());
            }
            finally {
                this.saveChunkLock.unlock();
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw DataUtils.newMVStoreException(1, "Could not open file {0}", fileName, e);
        }
    }

    @Override
    public void close() {
        try {
            try {
                if (this.fileChannel.isOpen()) {
                    if (this.fileLock != null) {
                        this.fileLock.release();
                    }
                    this.fileChannel.close();
                }
            }
            catch (Exception e) {
                throw DataUtils.newMVStoreException(2, "Closing failed for file {0}", this.getFileName(), e);
            }
        }
        finally {
            this.fileLock = null;
            super.close();
        }
    }

    @Override
    protected void writeFully(MFChunk chunk, long pos, ByteBuffer src) {
        assert (chunk.volumeId == this.volumeId);
        int len = src.remaining();
        this.setSize(Math.max(super.size(), pos + (long)len));
        DataUtils.writeFully(this.fileChannels[this.volumeId], pos, src);
        this.writeCount.incrementAndGet();
        this.writeBytes.addAndGet(len);
    }

    @Override
    public ByteBuffer readFully(MFChunk chunk, long pos, int len) {
        int volumeId = chunk.volumeId;
        return this.readFully(this.fileChannels[volumeId], pos, len);
    }

    @Override
    protected void initializeStoreHeader(long time) {
    }

    @Override
    protected void readStoreHeader(boolean recoveryMode) {
        ByteBuffer fileHeaderBlocks = this.readFully(new MFChunk(""), 0L, 4096);
        byte[] buff = new byte[4096];
        fileHeaderBlocks.get(buff);
        try {
            HashMap<String, String> m = DataUtils.parseChecksummedMap(buff);
            if (m == null) {
                throw DataUtils.newMVStoreException(6, "Store header is corrupt: {0}", this);
            }
            this.storeHeader.putAll(m);
        }
        catch (Exception ignore) {
            throw DataUtils.newMVStoreException(6, "Store header is corrupt: {0}", this);
        }
        this.processCommonHeaderAttributes();
        long fileSize = this.size();
        long blocksInVolume = fileSize / 4096L;
        MFChunk chunk = (MFChunk)this.discoverChunk(blocksInVolume);
        this.setLastChunk(chunk);
        for (MFChunk c : this.getChunksFromLayoutMap()) {
            if (c.isLive()) continue;
            this.registerDeadChunk(c);
        }
    }

    @Override
    protected void allocateChunkSpace(MFChunk chunk, WriteBuffer buff) {
        chunk.block = this.size() / 4096L;
        this.setSize((chunk.block + (long)chunk.len) * 4096L);
    }

    @Override
    protected void writeChunk(MFChunk chunk, WriteBuffer buff) {
        long filePos = chunk.block * 4096L;
        this.writeFully(chunk, filePos, buff.getBuffer());
    }

    @Override
    protected void writeCleanShutdownMark() {
    }

    @Override
    protected void adjustStoreToLastChunk() {
    }

    @Override
    protected void compactStore(int thresholdFillRate, long maxCompactTime, int maxWriteSize, MVStore mvStore) {
    }

    @Override
    protected void doHousekeeping(MVStore mvStore) throws InterruptedException {
    }

    @Override
    public int getFillRate() {
        return 0;
    }

    @Override
    protected void shrinkStoreIfPossible(int minPercent) {
    }

    @Override
    public void markUsed(long pos, int length) {
    }

    @Override
    protected void freeChunkSpace(Iterable<MFChunk> chunks) {
    }

    @Override
    protected boolean validateFileLength(String msg) {
        return true;
    }

    @Override
    public void backup(ZipOutputStream out) throws IOException {
    }
}

