/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.BitSet;
import org.h2.mvstore.DataUtils;
import org.h2.util.MathUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FreeSpaceBitSet {
    private static final boolean DETAILED_INFO = false;
    private final int firstFreeBlock;
    private final int blockSize;
    private final BitSet set = new BitSet();
    private int failureFlags;

    public FreeSpaceBitSet(int firstFreeBlock, int blockSize) {
        this.firstFreeBlock = firstFreeBlock;
        this.blockSize = blockSize;
        this.clear();
    }

    public void clear() {
        this.set.clear();
        this.set.set(0, this.firstFreeBlock);
    }

    public boolean isUsed(long pos, int length) {
        int start = this.getBlock(pos);
        int blocks = this.getBlockCount(length);
        int i = start;
        while (i < start + blocks) {
            if (!this.set.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isFree(long pos, int length) {
        int start = this.getBlock(pos);
        int blocks = this.getBlockCount(length);
        int i = start;
        while (i < start + blocks) {
            if (this.set.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public long allocate(int length) {
        return this.allocate(length, 0L, 0L);
    }

    long allocate(int length, long reservedLow, long reservedHigh) {
        return this.getPos(this.allocate(this.getBlockCount(length), (int)reservedLow, (int)reservedHigh, true));
    }

    long predictAllocation(int blocks, long reservedLow, long reservedHigh) {
        return this.allocate(blocks, (int)reservedLow, (int)reservedHigh, false);
    }

    boolean isFragmented() {
        return Integer.bitCount(this.failureFlags & 0xF) > 1;
    }

    private int allocate(int blocks, int reservedLow, int reservedHigh, boolean allocate) {
        int freeBlocksTotal = 0;
        int i = 0;
        while (true) {
            int start = this.set.nextClearBit(i);
            int end = this.set.nextSetBit(start + 1);
            int freeBlocks = end - start;
            if (end < 0 || freeBlocks >= blocks) {
                if ((reservedHigh < 0 || start < reservedHigh) && start + blocks > reservedLow && reservedHigh >= 0) {
                    freeBlocksTotal += freeBlocks;
                    i = reservedHigh;
                    continue;
                }
                assert (this.set.nextSetBit(start) == -1 || this.set.nextSetBit(start) >= start + blocks) : "Double alloc: " + Integer.toHexString(start) + "/" + Integer.toHexString(blocks) + " " + String.valueOf(this);
                if (allocate) {
                    this.set.set(start, start + blocks);
                } else {
                    this.failureFlags <<= 1;
                    if (end < 0 && freeBlocksTotal > 4 * blocks) {
                        this.failureFlags |= 1;
                    }
                }
                return start;
            }
            freeBlocksTotal += freeBlocks;
            i = end;
        }
    }

    public void markUsed(long pos, int length) {
        int start = this.getBlock(pos);
        int blocks = this.getBlockCount(length);
        if (this.set.nextSetBit(start) != -1 && this.set.nextSetBit(start) < start + blocks) {
            throw DataUtils.newMVStoreException(6, "Double mark: " + Integer.toHexString(start) + "/" + Integer.toHexString(blocks) + " " + String.valueOf(this), new Object[0]);
        }
        this.set.set(start, start + blocks);
    }

    public void free(long pos, int length) {
        int start = this.getBlock(pos);
        int blocks = this.getBlockCount(length);
        assert (this.set.nextClearBit(start) >= start + blocks) : "Double free: " + Integer.toHexString(start) + "/" + Integer.toHexString(blocks) + " " + String.valueOf(this);
        this.set.clear(start, start + blocks);
    }

    private long getPos(int block) {
        return (long)block * (long)this.blockSize;
    }

    private int getBlock(long pos) {
        return (int)(pos / (long)this.blockSize);
    }

    private int getBlockCount(int length) {
        return MathUtils.roundUpInt(length, this.blockSize) / this.blockSize;
    }

    int getFillRate() {
        int usedBlocks = this.set.cardinality() - this.firstFreeBlock;
        int totalBlocks = this.set.length() - this.firstFreeBlock;
        return totalBlocks == 0 ? 0 : (int)((100L * (long)usedBlocks + (long)totalBlocks - 1L) / (long)totalBlocks);
    }

    long getFirstFree() {
        return this.getPos(this.set.nextClearBit(0));
    }

    long getLastFree() {
        return this.getPos(this.getAfterLastBlock());
    }

    int getAfterLastBlock() {
        return this.set.previousSetBit(this.set.size() - 1) + 1;
    }

    int getMovePriority(int block) {
        int freeSize;
        int prevEnd = this.set.previousClearBit(block);
        if (prevEnd < 0) {
            prevEnd = this.firstFreeBlock;
            freeSize = 0;
        } else {
            freeSize = prevEnd - this.set.previousSetBit(prevEnd);
        }
        int nextStart = this.set.nextClearBit(block);
        int nextEnd = this.set.nextSetBit(nextStart);
        if (nextEnd >= 0) {
            freeSize += nextEnd - nextStart;
        }
        return (nextStart - prevEnd - 1) * 1000 / (freeSize + 1);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append('[');
        int i = 0;
        while (true) {
            if (i > 0) {
                buff.append(", ");
            }
            int start = this.set.nextClearBit(i);
            buff.append(Integer.toHexString(start)).append('-');
            int end = this.set.nextSetBit(start + 1);
            if (end < 0) break;
            buff.append(Integer.toHexString(end - 1));
            i = end + 1;
        }
        buff.append(']');
        return buff.toString();
    }
}

