/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.Page;
import org.h2.mvstore.RootReference;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.util.MemoryEstimator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MVMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    public final MVStore store;
    private final AtomicReference<RootReference<K, V>> root;
    private final int id;
    private final long createVersion;
    private final DataType<K> keyType;
    private final DataType<V> valueType;
    private final int keysPerPage;
    private final boolean singleWriter;
    private final K[] keysBuffer;
    private final V[] valuesBuffer;
    private final Object lock = new Object();
    private volatile boolean notificationRequested;
    private volatile boolean closed;
    private boolean readOnly;
    private boolean isVolatile;
    private final AtomicLong avgKeySize;
    private final AtomicLong avgValSize;

    protected MVMap(Map<String, Object> config, DataType<K> keyType, DataType<V> valueType) {
        this((MVStore)config.get("store"), keyType, valueType, DataUtils.readHexInt(config, "id", 0), DataUtils.readHexLong(config, "createVersion", 0L), new AtomicReference<RootReference<K, V>>(), ((MVStore)config.get("store")).getKeysPerPage(), config.containsKey("singleWriter") && (Boolean)config.get("singleWriter") != false);
        this.setInitialRoot(this.createEmptyLeaf(), this.store.getCurrentVersion());
    }

    protected MVMap(MVMap<K, V> source) {
        this(source.store, source.keyType, source.valueType, source.id, source.createVersion, new AtomicReference<RootReference<K, V>>(source.root.get()), source.keysPerPage, source.singleWriter);
    }

    MVMap(MVStore store, int id, DataType<K> keyType, DataType<V> valueType) {
        this(store, keyType, valueType, id, 0L, new AtomicReference<RootReference<K, V>>(), store.getKeysPerPage(), false);
        this.setInitialRoot(this.createEmptyLeaf(), store.getCurrentVersion());
    }

    private MVMap(MVStore store, DataType<K> keyType, DataType<V> valueType, int id, long createVersion, AtomicReference<RootReference<K, V>> root, int keysPerPage, boolean singleWriter) {
        this.store = store;
        this.id = id;
        this.createVersion = createVersion;
        this.keyType = keyType;
        this.valueType = valueType;
        this.root = root;
        this.keysPerPage = keysPerPage;
        this.keysBuffer = singleWriter ? keyType.createStorage(keysPerPage) : null;
        this.valuesBuffer = singleWriter ? valueType.createStorage(keysPerPage) : null;
        this.singleWriter = singleWriter;
        this.avgKeySize = keyType.isMemoryEstimationAllowed() ? new AtomicLong() : null;
        this.avgValSize = valueType.isMemoryEstimationAllowed() ? new AtomicLong() : null;
    }

    protected MVMap<K, V> cloneIt() {
        return new MVMap<K, V>(this);
    }

    static String getMapRootKey(int mapId) {
        return "root." + Integer.toHexString(mapId);
    }

    static String getMapKey(int mapId) {
        return "map." + Integer.toHexString(mapId);
    }

    @Override
    public V put(K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        return (V)this.operate(key, value, DecisionMaker.PUT);
    }

    public final K firstKey() {
        return this.getFirstLast(true);
    }

    public final K lastKey() {
        return this.getFirstLast(false);
    }

    public final K getKey(long index) {
        if (index < 0L || index >= this.sizeAsLong()) {
            return null;
        }
        Page<K, V> p = this.getRootPage();
        long offset = 0L;
        while (true) {
            if (p.isLeaf()) {
                if (index >= offset + (long)p.getKeyCount()) {
                    return null;
                }
                K key = p.getKey((int)(index - offset));
                return key;
            }
            int i = 0;
            int size = this.getChildPageCount(p);
            while (i < size) {
                long c = p.getCounts(i);
                if (index < c + offset) break;
                offset += c;
                ++i;
            }
            if (i == size) {
                return null;
            }
            p = p.getChildPage(i);
        }
    }

    public final List<K> keyList() {
        return new AbstractList<K>(){

            @Override
            public K get(int index) {
                return MVMap.this.getKey(index);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public int indexOf(Object key) {
                return (int)MVMap.this.getKeyIndex(key);
            }
        };
    }

    public final long getKeyIndex(K key) {
        Page<K, V> p = this.getRootPage();
        if (p.getTotalCount() == 0L) {
            return -1L;
        }
        long offset = 0L;
        while (true) {
            int x = p.binarySearch(key);
            if (p.isLeaf()) {
                if (x < 0) {
                    offset = -offset;
                }
                return offset + (long)x;
            }
            if (x++ < 0) {
                x = -x;
            }
            int i = 0;
            while (i < x) {
                offset += p.getCounts(i);
                ++i;
            }
            p = p.getChildPage(x);
        }
    }

    private K getFirstLast(boolean first) {
        Page<K, V> p = this.getRootPage();
        return this.getFirstLast(p, first);
    }

    private K getFirstLast(Page<K, V> p, boolean first) {
        if (p.getTotalCount() == 0L) {
            return null;
        }
        while (!p.isLeaf()) {
            p = p.getChildPage(first ? 0 : this.getChildPageCount(p) - 1);
        }
        return p.getKey(first ? 0 : p.getKeyCount() - 1);
    }

    public final K higherKey(K key) {
        return this.getMinMax(key, false, true);
    }

    public final K higherKey(RootReference<K, V> rootRef, K key) {
        return this.getMinMax(rootRef, key, false, true);
    }

    public final K ceilingKey(K key) {
        return this.getMinMax(key, false, false);
    }

    public final K floorKey(K key) {
        return this.getMinMax(key, true, false);
    }

    public final K lowerKey(K key) {
        return this.getMinMax(key, true, true);
    }

    public final K lowerKey(RootReference<K, V> rootRef, K key) {
        return this.getMinMax(rootRef, key, true, true);
    }

    private K getMinMax(K key, boolean min, boolean excluding) {
        return this.getMinMax(this.flushAndGetRoot(), key, min, excluding);
    }

    private K getMinMax(RootReference<K, V> rootRef, K key, boolean min, boolean excluding) {
        return this.getMinMax(rootRef.root, key, min, excluding);
    }

    private K getMinMax(Page<K, V> p, K key, boolean min, boolean excluding) {
        int x = p.binarySearch(key);
        if (p.isLeaf()) {
            if (x < 0) {
                x = -x - (min ? 2 : 1);
            } else if (excluding) {
                x += min ? -1 : 1;
            }
            if (x < 0 || x >= p.getKeyCount()) {
                return null;
            }
            return p.getKey(x);
        }
        if (x++ < 0) {
            x = -x;
        }
        while (x >= 0 && x < this.getChildPageCount(p)) {
            K k = this.getMinMax(p.getChildPage(x), key, min, excluding);
            if (k != null) {
                return k;
            }
            x += min ? -1 : 1;
        }
        return null;
    }

    @Override
    public final V get(Object key) {
        return this.get(this.getRootPage(), key);
    }

    public V get(Page<K, V> p, K key) {
        return Page.get(p, key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public void clear() {
        this.clearIt();
    }

    RootReference<K, V> clearIt() {
        Page<K, V> emptyRootPage = this.createEmptyLeaf();
        int attempt = 0;
        RootReference<K, V> rootReference;
        while ((rootReference = this.flushAndGetRoot()).getTotalCount() != 0L) {
            boolean locked = rootReference.isLockedByCurrentThread();
            if (!locked) {
                if (attempt++ == 0) {
                    this.beforeWrite();
                } else if (attempt > 3 || rootReference.isLocked()) {
                    rootReference = this.lockRoot(rootReference, attempt);
                    locked = true;
                }
            }
            Page rootPage = rootReference.root;
            long version = rootReference.version;
            try {
                if (!locked && (rootReference = rootReference.updateRootPage(emptyRootPage, attempt)) == null) continue;
                if (this.isPersistent()) {
                    this.registerUnsavedMemory(rootPage.removeAllRecursive(version));
                }
                rootPage = emptyRootPage;
                RootReference<K, V> rootReference2 = rootReference;
                return rootReference2;
            }
            finally {
                if (!locked) continue;
                this.unlockRoot(rootPage);
                continue;
            }
            break;
        }
        return rootReference;
    }

    protected final void registerUnsavedMemory(int memory) {
        if (this.isPersistent()) {
            this.store.registerUnsavedMemory(memory);
        }
    }

    final void close() {
        this.closed = true;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public V remove(Object key) {
        return (V)this.operate(key, null, DecisionMaker.REMOVE);
    }

    @Override
    public final V putIfAbsent(K key, V value) {
        return (V)this.operate(key, value, DecisionMaker.IF_ABSENT);
    }

    @Override
    public boolean remove(Object key, Object value) {
        EqualsDecisionMaker<Object> decisionMaker = new EqualsDecisionMaker<Object>(this.valueType, value);
        this.operate(key, null, decisionMaker);
        return decisionMaker.getDecision() != Decision.ABORT;
    }

    static <X> boolean areValuesEqual(DataType<X> datatype, X a, X b) {
        return a == b || a != null && b != null && datatype.compare(a, b) == 0;
    }

    @Override
    public final boolean replace(K key, V oldValue, V newValue) {
        boolean res;
        EqualsDecisionMaker<V> decisionMaker = new EqualsDecisionMaker<V>(this.valueType, oldValue);
        V result = this.operate(key, newValue, decisionMaker);
        boolean bl = res = decisionMaker.getDecision() != Decision.ABORT;
        assert (!res || MVMap.areValuesEqual(this.valueType, oldValue, result)) : String.valueOf(oldValue) + " != " + String.valueOf(result);
        return res;
    }

    @Override
    public final V replace(K key, V value) {
        return (V)this.operate(key, value, DecisionMaker.IF_PRESENT);
    }

    final int compare(K a, K b) {
        return this.keyType.compare(a, b);
    }

    public final DataType<K> getKeyType() {
        return this.keyType;
    }

    public final DataType<V> getValueType() {
        return this.valueType;
    }

    boolean isSingleWriter() {
        return this.singleWriter;
    }

    final Page<K, V> readPage(long pos) {
        return this.store.readPage(this, pos);
    }

    final void setRootPos(long rootPos, long version) {
        Page<K, V> root = this.readOrCreateRootPage(rootPos);
        if (root.map != this) {
            assert (this.id == root.map.id);
            root = root.copy(this, false);
        }
        this.setInitialRoot(root, version - 1L);
        this.setWriteVersion(version);
    }

    private Page<K, V> readOrCreateRootPage(long rootPos) {
        Page<K, V> root = rootPos == 0L ? this.createEmptyLeaf() : this.readPage(rootPos);
        return root;
    }

    public final Iterator<K> keyIterator(K from) {
        return this.cursor(from, null, false);
    }

    public final Iterator<K> keyIteratorReverse(K from) {
        return this.cursor(from, null, true);
    }

    final boolean rewritePage(long pagePos) {
        Page<K, V> p = this.readPage(pagePos);
        if (p.getKeyCount() == 0) {
            return true;
        }
        assert (p.isSaved());
        K key = p.getKey(0);
        if (!this.isClosed()) {
            boolean res;
            RewriteDecisionMaker decisionMaker = new RewriteDecisionMaker(p.getPos());
            Object result = this.operate(key, null, decisionMaker);
            boolean bl = res = decisionMaker.getDecision() != Decision.ABORT;
            assert (!res || result != null);
            return res;
        }
        return false;
    }

    public final Cursor<K, V> cursor(K from) {
        return this.cursor(from, null, false);
    }

    public final Cursor<K, V> cursor(K from, K to, boolean reverse) {
        return this.cursor(this.flushAndGetRoot(), from, to, reverse);
    }

    public Cursor<K, V> cursor(RootReference<K, V> rootReference, K from, K to, boolean reverse) {
        return new Cursor<K, V>(rootReference, from, to, reverse);
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        final RootReference<K, V> rootReference = this.flushAndGetRoot();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Cursor cursor = MVMap.this.cursor(rootReference, null, null, false);
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return cursor.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object k = cursor.next();
                        return new AbstractMap.SimpleImmutableEntry(k, cursor.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return MVMap.this.containsKey(o);
            }
        };
    }

    @Override
    public Set<K> keySet() {
        final RootReference<K, V> rootReference = this.flushAndGetRoot();
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return MVMap.this.cursor(rootReference, null, null, false);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return MVMap.this.containsKey(o);
            }
        };
    }

    public final String getName() {
        return this.store.getMapName(this.id);
    }

    public final MVStore getStore() {
        return this.store;
    }

    protected final boolean isPersistent() {
        return this.store.isPersistent() && !this.isVolatile;
    }

    public final int getId() {
        return this.id;
    }

    public final Page<K, V> getRootPage() {
        return this.flushAndGetRoot().root;
    }

    public RootReference<K, V> getRoot() {
        return this.root.get();
    }

    public RootReference<K, V> flushAndGetRoot() {
        RootReference<K, V> rootReference = this.getRoot();
        if (this.singleWriter && rootReference.getAppendCounter() > 0) {
            return this.flushAppendBuffer(rootReference, true);
        }
        return rootReference;
    }

    final void setInitialRoot(Page<K, V> rootPage, long version) {
        this.root.set(new RootReference<K, V>(rootPage, version));
    }

    final boolean compareAndSetRoot(RootReference<K, V> expectedRootReference, RootReference<K, V> updatedRootReference) {
        return this.root.compareAndSet(expectedRootReference, updatedRootReference);
    }

    final void rollbackTo(long version) {
        if (version > this.createVersion) {
            this.rollbackRoot(version);
        }
    }

    boolean rollbackRoot(long version) {
        RootReference previous;
        RootReference<K, V> rootReference = this.flushAndGetRoot();
        while (rootReference.version >= version && (previous = rootReference.previous) != null) {
            if (!this.root.compareAndSet(rootReference, previous)) continue;
            rootReference = previous;
            this.closed = false;
        }
        this.setWriteVersion(version);
        return rootReference.version < version;
    }

    protected static <K, V> boolean updateRoot(RootReference<K, V> expectedRootReference, Page<K, V> newRootPage, int attemptUpdateCounter) {
        return expectedRootReference.updateRootPage(newRootPage, attemptUpdateCounter) != null;
    }

    private void removeUnusedOldVersions(RootReference<K, V> rootReference) {
        rootReference.removeUnusedOldVersions(this.store.getOldestVersionToKeep());
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public final boolean isVolatile() {
        return this.isVolatile;
    }

    protected final void beforeWrite() {
        assert (!this.getRoot().isLockedByCurrentThread()) : this.getRoot();
        if (this.closed) {
            int id = this.getId();
            String mapName = this.store.getMapName(id);
            throw DataUtils.newMVStoreException(4, "Map {0}({1}) is closed. {2}", mapName, id, this.store.getPanicException());
        }
        if (this.readOnly) {
            throw DataUtils.newUnsupportedOperationException("This map is read-only");
        }
        this.store.beforeWrite(this);
    }

    @Override
    public final int hashCode() {
        return this.id;
    }

    @Override
    public final boolean equals(Object o) {
        return this == o;
    }

    @Override
    public final int size() {
        long size = this.sizeAsLong();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public final long sizeAsLong() {
        return this.getRoot().getTotalCount();
    }

    @Override
    public boolean isEmpty() {
        return this.sizeAsLong() == 0L;
    }

    final long getCreateVersion() {
        return this.createVersion;
    }

    public final MVMap<K, V> openVersion(long version) {
        RootReference previous;
        if (this.readOnly) {
            throw DataUtils.newUnsupportedOperationException("This map is read-only; need to call the method on the writable map");
        }
        DataUtils.checkArgument(version >= this.createVersion, "Unknown version {0}; this map was created in version is {1}", version, this.createVersion);
        RootReference<K, V> rootReference = this.flushAndGetRoot();
        this.removeUnusedOldVersions(rootReference);
        while ((previous = rootReference.previous) != null && previous.version >= version) {
            rootReference = previous;
        }
        if (previous == null && version < this.store.getOldestVersionToKeep()) {
            throw DataUtils.newIllegalArgumentException("Unknown version {0}", version);
        }
        MVMap m = this.openReadOnly(rootReference.root, version);
        assert (m.getVersion() <= version) : m.getVersion() + " <= " + version;
        return m;
    }

    final MVMap<K, V> openReadOnly(long rootPos, long version) {
        Page<K, V> root = this.readOrCreateRootPage(rootPos);
        return this.openReadOnly(root, version);
    }

    private MVMap<K, V> openReadOnly(Page<K, V> root, long version) {
        MVMap<K, V> m = this.cloneIt();
        m.readOnly = true;
        m.setInitialRoot(root, version);
        return m;
    }

    public final long getVersion() {
        return this.getRoot().getVersion();
    }

    final boolean hasChangesSince(long version) {
        return this.getRoot().hasChangesSince(version, this.isPersistent());
    }

    protected int getChildPageCount(Page<K, V> p) {
        return p.getRawChildPageCount();
    }

    public String getType() {
        return null;
    }

    protected String asString(String name) {
        String type;
        StringBuilder buff = new StringBuilder();
        if (name != null) {
            DataUtils.appendMap(buff, "name", name);
        }
        if (this.createVersion != 0L) {
            DataUtils.appendMap(buff, "createVersion", this.createVersion);
        }
        if ((type = this.getType()) != null) {
            DataUtils.appendMap(buff, "type", type);
        }
        return buff.toString();
    }

    final RootReference<K, V> setWriteVersion(long writeVersion) {
        int attempt = 0;
        while (true) {
            RootReference<K, V> rootReference = this.flushAndGetRoot();
            if (rootReference.version >= writeVersion) {
                return rootReference;
            }
            if (this.isClosed() && rootReference.getVersion() + 1L < this.store.getOldestVersionToKeep()) {
                this.store.deregisterMapRoot(this.id);
                return null;
            }
            RootReference<K, V> lockedRootReference = null;
            if (++attempt > 3 || rootReference.isLocked()) {
                lockedRootReference = this.lockRoot(rootReference, attempt);
                rootReference = this.flushAndGetRoot();
            }
            try {
                if ((rootReference = rootReference.tryUnlockAndUpdateVersion(writeVersion, attempt)) == null) continue;
                lockedRootReference = null;
                this.removeUnusedOldVersions(rootReference);
                RootReference<K, V> rootReference2 = rootReference;
                return rootReference2;
            }
            finally {
                if (lockedRootReference == null) continue;
                this.unlockRoot();
                continue;
            }
            break;
        }
    }

    protected Page<K, V> createEmptyLeaf() {
        return Page.createEmptyLeaf(this);
    }

    protected Page<K, V> createEmptyNode() {
        return Page.createEmptyNode(this);
    }

    final void copyFrom(MVMap<K, V> sourceMap) {
        MVStore.TxCounter txCounter = this.store.registerVersionUsage();
        try {
            this.beforeWrite();
            this.copy(sourceMap.getRootPage(), null, 0);
        }
        finally {
            this.store.deregisterVersionUsage(txCounter);
        }
    }

    private void copy(Page<K, V> source, Page<K, V> parent, int index) {
        Page<K, V> target = source.copy(this, true);
        if (parent == null) {
            this.setInitialRoot(target, -1L);
        } else {
            parent.setChild(index, target);
        }
        if (!source.isLeaf()) {
            int i = 0;
            while (i < this.getChildPageCount(target)) {
                if (source.getChildPagePos(i) != 0L) {
                    this.copy(source.getChildPage(i), target, i);
                }
                ++i;
            }
            target.setComplete();
        }
        this.store.registerUnsavedMemoryAndCommitIfNeeded(target.getMemory());
    }

    private RootReference<K, V> flushAppendBuffer(RootReference<K, V> rootReference, boolean fullFlush) {
        boolean preLocked;
        boolean locked = preLocked = rootReference.isLockedByCurrentThread();
        int keysPerPage = this.store.getKeysPerPage();
        try {
            int keyCount;
            IntValueHolder unsavedMemoryHolder = new IntValueHolder();
            int attempt = 0;
            int availabilityThreshold = fullFlush ? 0 : keysPerPage - 1;
            while ((keyCount = rootReference.getAppendCounter()) > availabilityThreshold) {
                if (!locked) {
                    if ((rootReference = this.tryLock(rootReference, ++attempt)) == null) {
                        rootReference = this.getRoot();
                        continue;
                    }
                    locked = true;
                }
                Page rootPage = rootReference.root;
                long version = rootReference.version;
                CursorPos pos = rootPage.getAppendCursorPos(null);
                assert (pos != null);
                assert (pos.index < 0) : pos.index;
                int index = -pos.index - 1;
                assert (index == pos.page.getKeyCount()) : index + " != " + pos.page.getKeyCount();
                Page p = pos.page;
                CursorPos tip = pos;
                pos = pos.parent;
                int remainingBuffer = 0;
                Page page = null;
                int available = keysPerPage - p.getKeyCount();
                if (available > 0) {
                    p = p.copy();
                    if (keyCount <= available) {
                        p.expand(keyCount, this.keysBuffer, this.valuesBuffer);
                    } else {
                        p.expand(available, this.keysBuffer, this.valuesBuffer);
                        keyCount -= available;
                        if (fullFlush) {
                            K[] keys = p.createKeyStorage(keyCount);
                            V[] values = p.createValueStorage(keyCount);
                            System.arraycopy(this.keysBuffer, available, keys, 0, keyCount);
                            if (this.valuesBuffer != null) {
                                System.arraycopy(this.valuesBuffer, available, values, 0, keyCount);
                            }
                            page = Page.createLeaf(this, keys, values, 0);
                        } else {
                            System.arraycopy(this.keysBuffer, available, this.keysBuffer, 0, keyCount);
                            if (this.valuesBuffer != null) {
                                System.arraycopy(this.valuesBuffer, available, this.valuesBuffer, 0, keyCount);
                            }
                            remainingBuffer = keyCount;
                        }
                    }
                } else {
                    tip = tip.parent;
                    page = Page.createLeaf(this, Arrays.copyOf(this.keysBuffer, keyCount), this.valuesBuffer == null ? null : Arrays.copyOf(this.valuesBuffer, keyCount), 0);
                }
                unsavedMemoryHolder.value = 0;
                if (page != null) {
                    assert (page.map == this);
                    assert (page.getKeyCount() > 0);
                    K key = page.getKey(0);
                    unsavedMemoryHolder.value += page.getMemory();
                    while (true) {
                        if (pos == null) {
                            if (p.getKeyCount() == 0) {
                                p = page;
                                break;
                            }
                            K[] keys = p.createKeyStorage(1);
                            keys[0] = key;
                            Page.PageReference<K, V>[] children = Page.createRefStorage(2);
                            children[0] = new Page.PageReference(p);
                            children[1] = new Page.PageReference(page);
                            unsavedMemoryHolder.value += p.getMemory();
                            p = Page.createNode(this, keys, children, p.getTotalCount() + page.getTotalCount(), 0);
                            break;
                        }
                        Page c = p;
                        p = pos.page;
                        index = pos.index;
                        pos = pos.parent;
                        p = p.copy();
                        p.setChild(index, page);
                        p.insertNode(index, key, c);
                        keyCount = p.getKeyCount();
                        int at = keyCount - (p.isLeaf() ? 1 : 2);
                        if (keyCount <= keysPerPage && ((long)p.getMemory() < this.store.getMaxPageSize() || at <= 0)) break;
                        key = p.getKey(at);
                        page = p.split(at);
                        unsavedMemoryHolder.value += p.getMemory() + page.getMemory();
                    }
                }
                if ((rootReference = rootReference.updatePageAndLockedStatus(p = MVMap.replacePage(pos, p, unsavedMemoryHolder), preLocked || this.isPersistent(), remainingBuffer)) != null) {
                    boolean bl = locked = preLocked || this.isPersistent();
                    if (this.isPersistent() && tip != null) {
                        this.registerUnsavedMemory(unsavedMemoryHolder.value + tip.processRemovalInfo(version));
                    }
                    assert (rootReference.getAppendCounter() <= availabilityThreshold);
                    break;
                }
                rootReference = this.getRoot();
            }
        }
        finally {
            if (locked && !preLocked) {
                rootReference = this.unlockRoot();
            }
        }
        return rootReference;
    }

    private static <K, V> Page<K, V> replacePage(CursorPos<K, V> path, Page<K, V> replacement, IntValueHolder unsavedMemoryHolder) {
        int unsavedMemory = replacement.isSaved() ? 0 : replacement.getMemory();
        while (path != null) {
            Page parent = path.page;
            if (parent.getKeyCount() > 0) {
                Page<K, V> child = replacement;
                replacement = parent.copy();
                replacement.setChild(path.index, child);
                unsavedMemory += replacement.getMemory();
            }
            path = path.parent;
        }
        unsavedMemoryHolder.value += unsavedMemory;
        return replacement;
    }

    public void append(K key, V value) {
        if (this.singleWriter) {
            this.beforeWrite();
            RootReference<K, V> rootReference = this.lockRoot(this.getRoot(), 1);
            int appendCounter = rootReference.getAppendCounter();
            try {
                if (appendCounter >= this.keysPerPage) {
                    rootReference = this.flushAppendBuffer(rootReference, false);
                    appendCounter = rootReference.getAppendCounter();
                    assert (appendCounter < this.keysPerPage);
                }
                this.keysBuffer[appendCounter] = key;
                if (this.valuesBuffer != null) {
                    this.valuesBuffer[appendCounter] = value;
                }
                ++appendCounter;
            }
            finally {
                this.unlockRoot(appendCounter);
            }
        } else {
            this.put(key, value);
        }
    }

    public void trimLast() {
        if (this.singleWriter) {
            boolean useRegularRemove;
            RootReference<K, V> rootReference = this.getRoot();
            int appendCounter = rootReference.getAppendCounter();
            boolean bl = useRegularRemove = appendCounter == 0;
            if (!useRegularRemove) {
                rootReference = this.lockRoot(rootReference, 1);
                try {
                    appendCounter = rootReference.getAppendCounter();
                    boolean bl2 = useRegularRemove = appendCounter == 0;
                    if (!useRegularRemove) {
                        --appendCounter;
                    }
                }
                finally {
                    this.unlockRoot(appendCounter);
                }
            }
            if (useRegularRemove) {
                Page lastLeaf = rootReference.root.getAppendCursorPos(null).page;
                assert (lastLeaf.isLeaf());
                assert (lastLeaf.getKeyCount() > 0);
                Object key = lastLeaf.getKey(lastLeaf.getKeyCount() - 1);
                this.remove(key);
            }
        } else {
            this.remove(this.lastKey());
        }
    }

    @Override
    public final String toString() {
        return this.asString(null);
    }

    public V operate(K key, V value, DecisionMaker<? super V> decisionMaker) {
        IntValueHolder unsavedMemoryHolder = new IntValueHolder();
        int attempt = 0;
        block15: while (true) {
            RootReference rootReference;
            boolean locked;
            if (!(locked = (rootReference = this.flushAndGetRoot()).isLockedByCurrentThread())) {
                if (attempt++ == 0) {
                    this.beforeWrite();
                }
                if (attempt > 3 || rootReference.isLocked()) {
                    rootReference = this.lockRoot(rootReference, attempt);
                    locked = true;
                }
            }
            Page rootPage = rootReference.root;
            long version = rootReference.version;
            unsavedMemoryHolder.value = 0;
            try {
                CursorPos pos = CursorPos.traverseDown(rootPage, key);
                if (!locked && rootReference != this.getRoot()) continue;
                Page p = pos.page;
                int index = pos.index;
                CursorPos tip = pos;
                pos = pos.parent;
                V result = index < 0 ? null : (V)p.getValue(index);
                Decision decision = decisionMaker.decide(result, value, tip);
                block7 : switch (decision) {
                    case REPEAT: {
                        decisionMaker.reset();
                        continue block15;
                    }
                    case ABORT: {
                        if (!locked && rootReference != this.getRoot()) {
                            decisionMaker.reset();
                            continue block15;
                        }
                        V v = result;
                        return v;
                    }
                    case REMOVE: {
                        int keyCount;
                        if (index < 0) {
                            if (!locked && rootReference != this.getRoot()) {
                                decisionMaker.reset();
                                continue block15;
                            }
                            return null;
                        }
                        if (p.getTotalCount() == 1L && pos != null) {
                            do {
                                p = pos.page;
                                index = pos.index;
                                pos = pos.parent;
                            } while ((keyCount = p.getKeyCount()) == 0 && pos != null);
                            if (keyCount <= 1) {
                                if (keyCount == 1) {
                                    assert (index <= 1);
                                    p = p.getChildPage(1 - index);
                                    break;
                                }
                                p = Page.createEmptyLeaf(this);
                                break;
                            }
                        }
                        p = p.copy();
                        p.remove(index);
                        break;
                    }
                    case PUT: {
                        int keyCount;
                        value = decisionMaker.selectValue(result, value);
                        p = p.copy();
                        if (index < 0) {
                            p.insertLeaf(-index - 1, key, value);
                            while ((keyCount = p.getKeyCount()) > this.store.getKeysPerPage() || (long)p.getMemory() > this.store.getMaxPageSize() && keyCount > (p.isLeaf() ? 1 : 2)) {
                                long totalCount = p.getTotalCount();
                                int at = keyCount >> 1;
                                Object k = p.getKey(at);
                                Page split = p.split(at);
                                unsavedMemoryHolder.value += p.getMemory() + split.getMemory();
                                if (pos == null) {
                                    K[] keys = p.createKeyStorage(1);
                                    keys[0] = k;
                                    Page.PageReference<K, V>[] children = Page.createRefStorage(2);
                                    children[0] = new Page.PageReference(p);
                                    children[1] = new Page.PageReference(split);
                                    p = Page.createNode(this, keys, children, totalCount, 0);
                                    break block7;
                                }
                                Page c = p;
                                p = pos.page;
                                index = pos.index;
                                pos = pos.parent;
                                p = p.copy();
                                p.setChild(index, split);
                                p.insertNode(index, k, c);
                            }
                            break;
                        }
                        p.setValue(index, value);
                    }
                }
                rootPage = MVMap.replacePage(pos, p, unsavedMemoryHolder);
                if (!locked && (rootReference = rootReference.updateRootPage(rootPage, attempt)) == null) {
                    decisionMaker.reset();
                    continue;
                }
                if (this.isPersistent()) {
                    this.registerUnsavedMemory(unsavedMemoryHolder.value + tip.processRemovalInfo(version));
                }
                V v = result;
                return v;
            }
            finally {
                if (!locked) continue;
                this.unlockRoot(rootPage);
                continue;
            }
            break;
        }
    }

    private RootReference<K, V> lockRoot(RootReference<K, V> rootReference, int attempt) {
        RootReference<K, V> lockedRootReference;
        while ((lockedRootReference = this.tryLock(rootReference, attempt++)) == null) {
            rootReference = this.getRoot();
        }
        return lockedRootReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootReference<K, V> tryLock(RootReference<K, V> rootReference, int attempt) {
        RootReference<K, V> lockedRootReference = rootReference.tryLock(attempt);
        if (lockedRootReference != null) {
            return lockedRootReference;
        }
        assert (!rootReference.isLockedByCurrentThread()) : rootReference;
        RootReference oldRootReference = rootReference.previous;
        int contention = 1;
        if (oldRootReference != null) {
            long updateAttemptCounter = rootReference.updateAttemptCounter - oldRootReference.updateAttemptCounter;
            assert (updateAttemptCounter >= 0L) : updateAttemptCounter;
            long updateCounter = rootReference.updateCounter - oldRootReference.updateCounter;
            assert (updateCounter >= 0L) : updateCounter;
            assert (updateAttemptCounter >= updateCounter) : updateAttemptCounter + " >= " + updateCounter;
            contention += (int)((updateAttemptCounter + 1L) / (updateCounter + 1L));
        }
        if (attempt > 4) {
            if (attempt <= 12) {
                Thread.yield();
            } else {
                if (attempt <= 70 - 2 * contention) {
                    try {
                        Thread.sleep(contention);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                Object object = this.lock;
                synchronized (object) {
                    this.notificationRequested = true;
                    try {
                        this.lock.wait(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private RootReference<K, V> unlockRoot() {
        return this.unlockRoot(null, -1);
    }

    protected RootReference<K, V> unlockRoot(Page<K, V> newRootPage) {
        return this.unlockRoot(newRootPage, -1);
    }

    private void unlockRoot(int appendCounter) {
        this.unlockRoot(null, appendCounter);
    }

    private RootReference<K, V> unlockRoot(Page<K, V> newRootPage, int appendCounter) {
        RootReference<K, V> rootReference;
        RootReference<K, V> updatedRootReference;
        do {
            rootReference = this.getRoot();
            assert (rootReference.isLockedByCurrentThread());
        } while ((updatedRootReference = rootReference.updatePageAndLockedStatus(newRootPage == null ? rootReference.root : newRootPage, false, appendCounter == -1 ? rootReference.getAppendCounter() : appendCounter)) == null);
        this.notifyWaiters();
        return updatedRootReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaiters() {
        if (this.notificationRequested) {
            Object object = this.lock;
            synchronized (object) {
                this.notificationRequested = false;
                this.lock.notify();
            }
        }
    }

    final boolean isMemoryEstimationAllowed() {
        return this.avgKeySize != null || this.avgValSize != null;
    }

    final int evaluateMemoryForKeys(K[] storage, int count) {
        if (this.avgKeySize == null) {
            return MVMap.calculateMemory(this.keyType, storage, count);
        }
        return MemoryEstimator.estimateMemory(this.avgKeySize, this.keyType, storage, count);
    }

    final int evaluateMemoryForValues(V[] storage, int count) {
        if (this.avgValSize == null) {
            return MVMap.calculateMemory(this.valueType, storage, count);
        }
        return MemoryEstimator.estimateMemory(this.avgValSize, this.valueType, storage, count);
    }

    private static <T> int calculateMemory(DataType<T> keyType, T[] storage, int count) {
        int mem = count * 8;
        int i = 0;
        while (i < count) {
            mem += keyType.getMemory(storage[i]);
            ++i;
        }
        return mem;
    }

    final int evaluateMemoryForKey(K key) {
        if (this.avgKeySize == null) {
            return this.keyType.getMemory(key);
        }
        return MemoryEstimator.estimateMemory(this.avgKeySize, this.keyType, key);
    }

    final int evaluateMemoryForValue(V value) {
        if (this.avgValSize == null) {
            return this.valueType.getMemory(value);
        }
        return MemoryEstimator.estimateMemory(this.avgValSize, this.valueType, value);
    }

    static int samplingPct(AtomicLong stats) {
        return MemoryEstimator.samplingPct(stats);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static abstract class BasicBuilder<M extends MVMap<K, V>, K, V>
    implements MapBuilder<M, K, V> {
        private DataType<K> keyType;
        private DataType<V> valueType;

        protected BasicBuilder() {
        }

        @Override
        public DataType<K> getKeyType() {
            return this.keyType;
        }

        @Override
        public DataType<V> getValueType() {
            return this.valueType;
        }

        @Override
        public void setKeyType(DataType<? super K> keyType) {
            this.keyType = keyType;
        }

        @Override
        public void setValueType(DataType<? super V> valueType) {
            this.valueType = valueType;
        }

        public BasicBuilder<M, K, V> keyType(DataType<? super K> keyType) {
            this.setKeyType(keyType);
            return this;
        }

        public BasicBuilder<M, K, V> valueType(DataType<? super V> valueType) {
            this.setValueType(valueType);
            return this;
        }

        @Override
        public M create(MVStore store, Map<String, Object> config) {
            if (this.getKeyType() == null) {
                this.setKeyType(new ObjectDataType());
            }
            if (this.getValueType() == null) {
                this.setValueType(new ObjectDataType());
            }
            DataType<K> keyType = this.getKeyType();
            DataType<V> valueType = this.getValueType();
            config.put("store", store);
            config.put("key", keyType);
            config.put("val", valueType);
            return this.create(config);
        }

        protected abstract M create(Map<String, Object> var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Builder<K, V>
    extends BasicBuilder<MVMap<K, V>, K, V> {
        private boolean singleWriter;

        public Builder<K, V> keyType(DataType<? super K> dataType) {
            this.setKeyType(dataType);
            return this;
        }

        public Builder<K, V> valueType(DataType<? super V> dataType) {
            this.setValueType(dataType);
            return this;
        }

        public Builder<K, V> singleWriter() {
            this.singleWriter = true;
            return this;
        }

        @Override
        protected MVMap<K, V> create(Map<String, Object> config) {
            config.put("singleWriter", this.singleWriter);
            Object type = config.get("type");
            if (type == null || type.equals("rtree")) {
                return new MVMap(config, this.getKeyType(), this.getValueType());
            }
            throw new IllegalArgumentException("Incompatible map type");
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Decision {
        ABORT,
        REMOVE,
        PUT,
        REPEAT;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static abstract class DecisionMaker<V> {
        public static final DecisionMaker<Object> DEFAULT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object existingValue, Object providedValue) {
                return providedValue == null ? Decision.REMOVE : Decision.PUT;
            }

            public String toString() {
                return "default";
            }
        };
        public static final DecisionMaker<Object> PUT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object existingValue, Object providedValue) {
                return Decision.PUT;
            }

            public String toString() {
                return "put";
            }
        };
        public static final DecisionMaker<Object> REMOVE = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object existingValue, Object providedValue) {
                return Decision.REMOVE;
            }

            public String toString() {
                return "remove";
            }
        };
        static final DecisionMaker<Object> IF_ABSENT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object existingValue, Object providedValue) {
                return existingValue == null ? Decision.PUT : Decision.ABORT;
            }

            public String toString() {
                return "if_absent";
            }
        };
        static final DecisionMaker<Object> IF_PRESENT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object existingValue, Object providedValue) {
                return existingValue != null ? Decision.PUT : Decision.ABORT;
            }

            public String toString() {
                return "if_present";
            }
        };

        public Decision decide(V existingValue, V providedValue, CursorPos<?, ?> tip) {
            return this.decide(existingValue, providedValue);
        }

        public abstract Decision decide(V var1, V var2);

        public <T extends V> T selectValue(T existingValue, T providedValue) {
            return providedValue;
        }

        public void reset() {
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class EqualsDecisionMaker<V>
    extends DecisionMaker<V> {
        private final DataType<V> dataType;
        private final V expectedValue;
        private Decision decision;

        EqualsDecisionMaker(DataType<V> dataType, V expectedValue) {
            this.dataType = dataType;
            this.expectedValue = expectedValue;
        }

        @Override
        public Decision decide(V existingValue, V providedValue) {
            assert (this.decision == null);
            this.decision = !MVMap.areValuesEqual(this.dataType, this.expectedValue, existingValue) ? Decision.ABORT : (providedValue == null ? Decision.REMOVE : Decision.PUT);
            return this.decision;
        }

        @Override
        public void reset() {
            this.decision = null;
        }

        Decision getDecision() {
            return this.decision;
        }

        public String toString() {
            return "equals_to " + String.valueOf(this.expectedValue);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class IntValueHolder {
        int value;

        IntValueHolder() {
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface MapBuilder<M extends MVMap<K, V>, K, V> {
        public M create(MVStore var1, Map<String, Object> var2);

        public DataType<K> getKeyType();

        public DataType<V> getValueType();

        public void setKeyType(DataType<? super K> var1);

        public void setValueType(DataType<? super V> var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class RewriteDecisionMaker<V>
    extends DecisionMaker<V> {
        private final long pagePos;
        private Decision decision;

        RewriteDecisionMaker(long pagePos) {
            this.pagePos = pagePos;
        }

        @Override
        public Decision decide(V existingValue, V providedValue, CursorPos<?, ?> tip) {
            assert (this.decision == null);
            this.decision = Decision.ABORT;
            if (!DataUtils.isLeafPosition(this.pagePos)) {
                while ((tip = tip.parent) != null) {
                    if (tip.page.getPos() != this.pagePos) continue;
                    this.decision = this.decide(existingValue, providedValue);
                    break;
                }
            } else if (tip.page.getPos() == this.pagePos) {
                this.decision = this.decide(existingValue, providedValue);
            }
            return this.decision;
        }

        @Override
        public Decision decide(V existingValue, V providedValue) {
            this.decision = existingValue == null ? Decision.ABORT : Decision.PUT;
            return this.decision;
        }

        @Override
        public <T extends V> T selectValue(T existingValue, T providedValue) {
            return existingValue;
        }

        @Override
        public void reset() {
            this.decision = null;
        }

        Decision getDecision() {
            return this.decision;
        }

        public String toString() {
            return "rewrite";
        }
    }
}

