/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TreeMap;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.SFChunk;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MVStoreTool {
    public static final int MAX_NB_FILE_HEADERS_PER_FILE = 2;

    public static void main(String ... args) {
        int i = 0;
        while (i < args.length) {
            String fileName;
            if ("-dump".equals(args[i])) {
                fileName = args[++i];
                MVStoreTool.dump(fileName, new PrintWriter(System.out), true);
            } else if ("-info".equals(args[i])) {
                fileName = args[++i];
                MVStoreTool.info(fileName, new PrintWriter(System.out));
            } else if ("-compact".equals(args[i])) {
                fileName = args[++i];
                MVStoreTool.compact(fileName, false);
            } else if ("-compress".equals(args[i])) {
                fileName = args[++i];
                MVStoreTool.compact(fileName, true);
            } else if ("-rollback".equals(args[i])) {
                fileName = args[++i];
                long targetVersion = Long.decode(args[++i]);
                MVStoreTool.rollback(fileName, targetVersion, new PrintWriter(System.out));
            } else if ("-repair".equals(args[i])) {
                fileName = args[++i];
                MVStoreTool.repair(fileName);
            }
            ++i;
        }
    }

    public static void dump(String fileName, boolean details) {
        MVStoreTool.dump(fileName, new PrintWriter(System.out), details);
    }

    public static void info(String fileName) {
        MVStoreTool.info(fileName, new PrintWriter(System.out));
    }

    public static void dump(String fileName, Writer writer, boolean details) {
        PrintWriter pw = new PrintWriter(writer, true);
        if (!FilePath.get(fileName).exists()) {
            pw.println("File not found: " + fileName);
            return;
        }
        long size = FileUtils.size(fileName);
        pw.printf("File %s, %d bytes, %d MB\n", fileName, size, size / 1024L / 1024L);
        int blockSize = 4096;
        TreeMap<Integer, Long> mapSizesTotal = new TreeMap<Integer, Long>();
        long pageSizeTotal = 0L;
        try {
            Throwable throwable = null;
            Object var11_11 = null;
            try (FileChannel file = FilePath.get(fileName).open("r");){
                long fileSize = file.size();
                int len = Long.toHexString(fileSize).length();
                ByteBuffer buffer = ByteBuffer.allocate(4096);
                long pageCount = 0L;
                int readFileHeaderCount = 0;
                long pos = 0L;
                while (pos < fileSize) {
                    SFChunk c;
                    buffer.rewind();
                    try {
                        DataUtils.readFully(file, pos, buffer);
                    }
                    catch (MVStoreException e) {
                        pw.printf("ERROR illegal position %d%n", pos += (long)blockSize);
                        continue;
                    }
                    buffer.rewind();
                    byte headerType = buffer.get();
                    if (headerType == 72 && readFileHeaderCount < 2) {
                        String header = new String(buffer.array(), StandardCharsets.ISO_8859_1).trim();
                        pw.printf("%0" + len + "x fileHeader %s%n", pos, header);
                        pos += (long)blockSize;
                        ++readFileHeaderCount;
                        continue;
                    }
                    if (headerType != 99) {
                        pos += (long)blockSize;
                        continue;
                    }
                    buffer.position(0);
                    try {
                        c = new SFChunk(Chunk.readChunkHeader(buffer));
                    }
                    catch (MVStoreException e) {
                        pos += (long)blockSize;
                        continue;
                    }
                    if (c.len <= 0) {
                        pos += (long)blockSize;
                        continue;
                    }
                    int length = c.len * 4096;
                    pw.printf("%n%0" + len + "x chunkHeader %s%n", pos, c);
                    ByteBuffer chunk = ByteBuffer.allocate(length);
                    DataUtils.readFully(file, pos, chunk);
                    int p = buffer.position();
                    pos += (long)length;
                    int remaining = c.pageCount;
                    pageCount += (long)c.pageCount;
                    TreeMap<Integer, Integer> mapSizes = new TreeMap<Integer, Integer>();
                    int pageSizeSum = 0;
                    while (remaining > 0) {
                        boolean node;
                        int start = p;
                        try {
                            chunk.position(p);
                        }
                        catch (IllegalArgumentException e) {
                            pw.printf("ERROR illegal position %d%n", p);
                            break;
                        }
                        int pageSize = chunk.getInt();
                        chunk.getShort();
                        DataUtils.readVarInt(chunk);
                        int mapId = DataUtils.readVarInt(chunk);
                        int entries = DataUtils.readVarInt(chunk);
                        byte type = chunk.get();
                        boolean compressed = (type & 2) != 0;
                        boolean bl = node = (type & 1) != 0;
                        if (details) {
                            pw.printf("+%0" + len + "x %s, map %x, %d entries, %d bytes, maxLen %x%n", p, (node ? "node" : "leaf") + (compressed ? " compressed" : ""), mapId, node ? entries + 1 : entries, pageSize, DataUtils.getPageMaxLength(DataUtils.composePagePos(0, 0, pageSize, 0)));
                        }
                        p += pageSize;
                        Integer mapSize = (Integer)mapSizes.get(mapId);
                        if (mapSize == null) {
                            mapSize = 0;
                        }
                        mapSizes.put(mapId, mapSize + pageSize);
                        Long total = (Long)mapSizesTotal.get(mapId);
                        if (total == null) {
                            total = 0L;
                        }
                        mapSizesTotal.put(mapId, total + (long)pageSize);
                        pageSizeSum += pageSize;
                        pageSizeTotal += (long)pageSize;
                        --remaining;
                        long[] children = null;
                        long[] counts = null;
                        if (node) {
                            children = new long[entries + 1];
                            int i = 0;
                            while (i <= entries) {
                                children[i] = chunk.getLong();
                                ++i;
                            }
                            counts = new long[entries + 1];
                            i = 0;
                            while (i <= entries) {
                                long s;
                                counts[i] = s = DataUtils.readVarLong(chunk);
                                ++i;
                            }
                        }
                        String[] keys = new String[entries];
                        if (mapId == 0 && details) {
                            ByteBuffer data;
                            if (compressed) {
                                boolean fast = (type & 6) != 6;
                                Compressor compressor = MVStoreTool.getCompressor(fast);
                                int lenAdd = DataUtils.readVarInt(chunk);
                                int compLen = pageSize + start - chunk.position();
                                byte[] comp = Utils.newBytes(compLen);
                                chunk.get(comp);
                                int l = compLen + lenAdd;
                                data = ByteBuffer.allocate(l);
                                compressor.expand(comp, 0, compLen, data.array(), 0, l);
                            } else {
                                data = chunk;
                            }
                            int i = 0;
                            while (i < entries) {
                                String k;
                                keys[i] = k = StringDataType.INSTANCE.read(data);
                                ++i;
                            }
                            if (node) {
                                i = 0;
                                while (i < entries) {
                                    long cp = children[i];
                                    pw.printf("    %d children < %s @ chunk %x +%0" + len + "x%n", counts[i], keys[i], DataUtils.getPageChunkId(cp), DataUtils.getPageOffset(cp));
                                    ++i;
                                }
                                long cp = children[entries];
                                pw.printf("    %d children >= %s @ chunk %x +%0" + len + "x%n", counts[entries], entries <= keys.length ? null : keys[entries], DataUtils.getPageChunkId(cp), DataUtils.getPageOffset(cp));
                                continue;
                            }
                            String[] values = new String[entries];
                            int i2 = 0;
                            while (i2 < entries) {
                                String v;
                                values[i2] = v = StringDataType.INSTANCE.read(data);
                                ++i2;
                            }
                            i2 = 0;
                            while (i2 < entries) {
                                pw.println("    " + keys[i2] + " = " + values[i2]);
                                ++i2;
                            }
                            continue;
                        }
                        if (!node || !details) continue;
                        int i = 0;
                        while (i <= entries) {
                            long cp = children[i];
                            pw.printf("    %d children @ chunk %x +%0" + len + "x%n", counts[i], DataUtils.getPageChunkId(cp), DataUtils.getPageOffset(cp));
                            ++i;
                        }
                    }
                    pageSizeSum = Math.max(1, pageSizeSum);
                    for (Integer mapId : mapSizes.keySet()) {
                        int percent = 100 * (Integer)mapSizes.get(mapId) / pageSizeSum;
                        pw.printf("map %x: %d bytes, %d%%%n", mapId, mapSizes.get(mapId), percent);
                    }
                    int footerPos = chunk.limit() - 128;
                    try {
                        chunk.position(footerPos);
                        pw.printf("+%0" + len + "x chunkFooter %s%n", footerPos, new String(chunk.array(), chunk.position(), 128, StandardCharsets.ISO_8859_1).trim());
                    }
                    catch (IllegalArgumentException e) {
                        pw.printf("ERROR illegal footer position %d%n", footerPos);
                    }
                }
                pw.printf("%n%0" + len + "x eof%n", fileSize);
                pw.printf("\n", new Object[0]);
                pageCount = Math.max(1L, pageCount);
                pw.printf("page size total: %d bytes, page count: %d, average page size: %d bytes\n", pageSizeTotal, pageCount, pageSizeTotal / pageCount);
                pageSizeTotal = Math.max(1L, pageSizeTotal);
                for (Integer mapId : mapSizesTotal.keySet()) {
                    int percent = (int)(100L * (Long)mapSizesTotal.get(mapId) / pageSizeTotal);
                    pw.printf("map %x: %d bytes, %d%%%n", mapId, mapSizesTotal.get(mapId), percent);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            pw.println("ERROR: " + String.valueOf(e));
            e.printStackTrace(pw);
        }
        pw.flush();
    }

    private static Compressor getCompressor(boolean fast) {
        return fast ? new CompressLZF() : new CompressDeflate();
    }

    public static String info(String fileName, Writer writer) {
        PrintWriter pw = new PrintWriter(writer, true);
        if (!FilePath.get(fileName).exists()) {
            pw.println("File not found: " + fileName);
            return "File not found: " + fileName;
        }
        long fileLength = FileUtils.size(fileName);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (MVStore store = new MVStore.Builder().fileName(fileName).recoveryMode().readOnly().open();){
                Map<String, String> layout = store.getLayoutMap();
                Map<String, Object> header = store.getStoreHeader();
                long fileCreated = DataUtils.readHexLong(header, "created", 0L);
                TreeMap chunks = new TreeMap();
                long chunkLength = 0L;
                long maxLength = 0L;
                long maxLengthLive = 0L;
                long maxLengthNotEmpty = 0L;
                for (Map.Entry<String, String> entry : layout.entrySet()) {
                    String k = entry.getKey();
                    if (!k.startsWith("chunk.")) continue;
                    Object c = store.getFileStore().createChunk(entry.getValue());
                    chunks.put(((Chunk)c).id, c);
                    chunkLength += (long)((Chunk)c).len * 4096L;
                    maxLength += ((Chunk)c).maxLen;
                    maxLengthLive += ((Chunk)c).maxLenLive;
                    if (((Chunk)c).maxLenLive <= 0L) continue;
                    maxLengthNotEmpty += ((Chunk)c).maxLen;
                }
                pw.printf("Created: %s\n", MVStoreTool.formatTimestamp(fileCreated, fileCreated));
                pw.printf("Last modified: %s\n", MVStoreTool.formatTimestamp(FileUtils.lastModified(fileName), fileCreated));
                pw.printf("File length: %d\n", fileLength);
                pw.printf("The last chunk is not listed\n", new Object[0]);
                pw.printf("Chunk length: %d\n", chunkLength);
                pw.printf("Chunk count: %d\n", chunks.size());
                pw.printf("Used space: %d%%\n", MVStoreTool.getPercent(chunkLength, fileLength));
                pw.printf("Chunk fill rate: %d%%\n", maxLength == 0L ? 100 : MVStoreTool.getPercent(maxLengthLive, maxLength));
                pw.printf("Chunk fill rate excluding empty chunks: %d%%\n", maxLengthNotEmpty == 0L ? 100 : MVStoreTool.getPercent(maxLengthLive, maxLengthNotEmpty));
                for (Map.Entry<String, String> entry : chunks.entrySet()) {
                    Chunk c = (Chunk)((Object)entry.getValue());
                    long created = fileCreated + c.time;
                    pw.printf("  Chunk %d: %s, %d%% used, %d blocks", c.id, MVStoreTool.formatTimestamp(created, fileCreated), MVStoreTool.getPercent(c.maxLenLive, c.maxLen), c.len);
                    if (c.maxLenLive == 0L) {
                        pw.printf(", unused: %s", MVStoreTool.formatTimestamp(fileCreated + c.unused, fileCreated));
                    }
                    pw.printf("\n", new Object[0]);
                }
                pw.printf("\n", new Object[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            pw.println("ERROR: " + String.valueOf(e));
            e.printStackTrace(pw);
            return e.getMessage();
        }
        pw.flush();
        return null;
    }

    private static String formatTimestamp(long t, long start) {
        String x = new Timestamp(t).toString();
        Object s = x.substring(0, 19);
        s = (String)s + " (+" + (t - start) / 1000L + " s)";
        return s;
    }

    private static int getPercent(long value, long max) {
        if (value == 0L) {
            return 0;
        }
        if (value == max) {
            return 100;
        }
        return (int)(1L + 98L * value / Math.max(1L, max));
    }

    public static void compact(String fileName, boolean compress) {
        String tempName = fileName + ".tempFile";
        FileUtils.delete(tempName);
        MVStoreTool.compact(fileName, tempName, compress);
        MVStoreTool.moveAtomicReplace(tempName, fileName);
    }

    public static void moveAtomicReplace(String sourceName, String destinationName) {
        try {
            FileUtils.moveAtomicReplace(sourceName, destinationName);
        }
        catch (MVStoreException e) {
            String newName = destinationName + ".newFile";
            FileUtils.delete(newName);
            FileUtils.move(sourceName, newName);
            FileUtils.delete(destinationName);
            FileUtils.move(newName, destinationName);
        }
    }

    public static void compactCleanUp(String fileName) {
        String newName;
        String tempName = fileName + ".tempFile";
        if (FileUtils.exists(tempName)) {
            FileUtils.delete(tempName);
        }
        if (FileUtils.exists(newName = fileName + ".newFile")) {
            if (FileUtils.exists(fileName)) {
                FileUtils.delete(newName);
            } else {
                FileUtils.move(newName, fileName);
            }
        }
    }

    public static void compact(String sourceFileName, String targetFileName, boolean compress) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (MVStore source = new MVStore.Builder().fileName(sourceFileName).readOnly().open();){
            FileUtils.delete(targetFileName);
            MVStore.Builder b = new MVStore.Builder().fileName(targetFileName);
            if (compress) {
                b.compress();
            }
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (MVStore target = b.open();){
                MVStoreTool.compact(source, target);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static void compact(MVStore source, MVStore target) {
        target.setCurrentVersion(source.getCurrentVersion());
        target.adjustLastMapId(source.getLastMapId());
        int autoCommitDelay = target.getAutoCommitDelay();
        boolean reuseSpace = target.isSpaceReused();
        try {
            target.setReuseSpace(false);
            target.setAutoCommitDelay(0);
            MVMap<String, String> sourceMeta = source.getMetaMap();
            MVMap<String, String> targetMeta = target.getMetaMap();
            for (Map.Entry<String, String> m : sourceMeta.entrySet()) {
                String key = m.getKey();
                if (key.startsWith("map.") || key.startsWith("name.")) continue;
                targetMeta.put(key, m.getValue());
            }
            for (String mapName : source.getMapNames()) {
                MVMap.Builder<Object, Object> mp = MVStoreTool.getGenericMapBuilder();
                if (mapName.startsWith("undoLog")) {
                    mp.singleWriter();
                }
                Object sourceMap = source.openMap(mapName, mp);
                Object targetMap = target.openMap(mapName, mp);
                ((MVMap)targetMap).copyFrom(sourceMap);
                targetMeta.put(MVMap.getMapKey(((MVMap)targetMap).getId()), sourceMeta.get(MVMap.getMapKey(((MVMap)sourceMap).getId())));
            }
            target.commit();
        }
        finally {
            target.setAutoCommitDelay(autoCommitDelay);
            target.setReuseSpace(reuseSpace);
        }
    }

    public static void repair(String fileName) {
        PrintWriter pw = new PrintWriter(System.out);
        long version = Long.MAX_VALUE;
        OutputStream ignore = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
        while (version >= 0L) {
            pw.println((String)(version == Long.MAX_VALUE ? "Trying latest version" : "Trying version " + version));
            pw.flush();
            version = MVStoreTool.rollback(fileName, version, new PrintWriter(ignore));
            try {
                String error = MVStoreTool.info(fileName + ".temp", new PrintWriter(ignore));
                if (error == null) {
                    FilePath.get(fileName).moveTo(FilePath.get(fileName + ".back"), true);
                    FilePath.get(fileName + ".temp").moveTo(FilePath.get(fileName), true);
                    pw.println("Success");
                    break;
                }
                pw.println("    ... failed: " + error);
            }
            catch (Exception e) {
                pw.println("Fail: " + e.getMessage());
                pw.flush();
            }
            --version;
        }
        pw.flush();
    }

    public static long rollback(String fileName, long targetVersion, Writer writer) {
        PrintWriter pw;
        long newestVersion;
        block32: {
            newestVersion = -1L;
            pw = new PrintWriter(writer, true);
            if (!FilePath.get(fileName).exists()) {
                pw.println("File not found: " + fileName);
                return newestVersion;
            }
            FileChannel file = null;
            AbstractInterruptibleChannel target = null;
            int blockSize = 4096;
            try {
                try {
                    file = FilePath.get(fileName).open("r");
                    FilePath.get(fileName + ".temp").delete();
                    target = FilePath.get(fileName + ".temp").open("rw");
                    long fileSize = file.size();
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    SFChunk newestChunk = null;
                    long pos = 0L;
                    while (pos < fileSize) {
                        SFChunk c;
                        buffer.rewind();
                        DataUtils.readFully(file, pos, buffer);
                        buffer.rewind();
                        byte headerType = buffer.get();
                        buffer.rewind();
                        if (headerType == 72) {
                            ((FileChannel)target).write(buffer, pos);
                            pos += (long)blockSize;
                            continue;
                        }
                        if (headerType != 99) {
                            pos += (long)blockSize;
                            continue;
                        }
                        try {
                            c = new SFChunk(Chunk.readChunkHeader(buffer));
                        }
                        catch (MVStoreException e) {
                            pos += (long)blockSize;
                            continue;
                        }
                        if (c.len <= 0) {
                            pos += (long)blockSize;
                            continue;
                        }
                        int length = c.len * 4096;
                        ByteBuffer chunk = ByteBuffer.allocate(length);
                        DataUtils.readFully(file, pos, chunk);
                        if (c.version > targetVersion) {
                            pos += (long)length;
                            continue;
                        }
                        chunk.rewind();
                        ((FileChannel)target).write(chunk, pos);
                        if (newestChunk == null || c.version > newestChunk.version) {
                            newestChunk = c;
                            newestVersion = c.version;
                        }
                        pos += (long)length;
                    }
                    int length = newestChunk.len * 4096;
                    ByteBuffer chunk = ByteBuffer.allocate(length);
                    DataUtils.readFully(file, newestChunk.block * 4096L, chunk);
                    chunk.rewind();
                    ((FileChannel)target).write(chunk, fileSize);
                }
                catch (IOException e) {
                    pw.println("ERROR: " + String.valueOf(e));
                    e.printStackTrace(pw);
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (target != null) {
                        try {
                            target.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (target != null) {
                    try {
                        target.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (target != null) {
                try {
                    target.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        pw.flush();
        return newestVersion;
    }

    static MVMap.Builder<Object, Object> getGenericMapBuilder() {
        return ((MVMap.Builder)new MVMap.Builder().keyType((DataType)GenericDataType.INSTANCE)).valueType((DataType)GenericDataType.INSTANCE);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class GenericDataType
    extends BasicDataType<byte[]> {
        static GenericDataType INSTANCE = new GenericDataType();

        private GenericDataType() {
        }

        @Override
        public boolean isMemoryEstimationAllowed() {
            return false;
        }

        @Override
        public int getMemory(byte[] obj) {
            return obj == null ? 0 : obj.length * 8;
        }

        public byte[][] createStorage(int size) {
            return new byte[size][];
        }

        @Override
        public void write(WriteBuffer buff, byte[] obj) {
            if (obj != null) {
                buff.put(obj);
            }
        }

        @Override
        public byte[] read(ByteBuffer buff) {
            int len = buff.remaining();
            if (len == 0) {
                return null;
            }
            byte[] data = new byte[len];
            buff.get(data);
            return data;
        }
    }
}

