/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.RandomAccessStore;
import org.h2.mvstore.SFChunk;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OffHeapStore
extends RandomAccessStore {
    private final TreeMap<Long, ByteBuffer> memory = new TreeMap();

    public OffHeapStore() {
        super(new HashMap<String, Object>());
    }

    @Override
    public void open(String fileName, boolean readOnly, char[] encryptionKey) {
        this.init();
    }

    public OffHeapStore open(String fileName, boolean readOnly) {
        OffHeapStore result = new OffHeapStore();
        result.init();
        return result;
    }

    private void init() {
        this.memory.clear();
    }

    public String toString() {
        return this.memory.toString();
    }

    @Override
    public ByteBuffer readFully(SFChunk chunk, long pos, int len) {
        Map.Entry<Long, ByteBuffer> memEntry = this.memory.floorEntry(pos);
        if (memEntry == null) {
            throw DataUtils.newMVStoreException(1, "Could not read from position {0}", pos);
        }
        this.readCount.incrementAndGet();
        this.readBytes.addAndGet(len);
        ByteBuffer buff = memEntry.getValue();
        ByteBuffer read = buff.duplicate();
        int offset = (int)(pos - memEntry.getKey());
        read.position(offset);
        read.limit(len + offset);
        return read.slice();
    }

    @Override
    public void free(long pos, int length) {
        super.free(pos, length);
        ByteBuffer buff = this.memory.remove(pos);
        if (buff != null && buff.remaining() != length) {
            throw DataUtils.newMVStoreException(1, "Partial remove is not supported at position {0}", pos);
        }
    }

    @Override
    public void writeFully(SFChunk chunk, long pos, ByteBuffer src) {
        this.setSize(Math.max(this.size(), pos + (long)src.remaining()));
        Map.Entry<Long, ByteBuffer> mem = this.memory.floorEntry(pos);
        if (mem == null) {
            this.writeNewEntry(pos, src);
            return;
        }
        long prevPos = mem.getKey();
        ByteBuffer buff = mem.getValue();
        int prevLength = buff.capacity();
        int length = src.remaining();
        if (prevPos == pos) {
            if (prevLength != length) {
                throw DataUtils.newMVStoreException(1, "Could not write to position {0}; partial overwrite is not supported", pos);
            }
            this.writeCount.incrementAndGet();
            this.writeBytes.addAndGet(length);
            buff.rewind();
            buff.put(src);
            return;
        }
        if (prevPos + (long)prevLength > pos) {
            throw DataUtils.newMVStoreException(1, "Could not write to position {0}; partial overwrite is not supported", pos);
        }
        this.writeNewEntry(pos, src);
    }

    private void writeNewEntry(long pos, ByteBuffer src) {
        int length = src.remaining();
        this.writeCount.incrementAndGet();
        this.writeBytes.addAndGet(length);
        ByteBuffer buff = ByteBuffer.allocateDirect(length);
        buff.put(src);
        buff.rewind();
        this.memory.put(pos, buff);
    }

    @Override
    public void truncate(long size) {
        this.writeCount.incrementAndGet();
        this.setSize(size);
        if (size == 0L) {
            this.memory.clear();
        } else {
            Iterator<Long> it = this.memory.keySet().iterator();
            while (it.hasNext()) {
                long pos = it.next();
                if (pos < size) break;
                ByteBuffer buff = this.memory.get(pos);
                if ((long)buff.capacity() > size) {
                    throw DataUtils.newMVStoreException(1, "Could not truncate to {0}; partial truncate is not supported", pos);
                }
                it.remove();
            }
        }
    }

    @Override
    public int getDefaultRetentionTime() {
        return 0;
    }

    @Override
    public void backup(ZipOutputStream out) {
        throw new UnsupportedOperationException();
    }
}

