/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.RowDataType;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.mvstore.type.LongDataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueLob;
import org.h2.value.VersionedValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MVPrimaryIndex
extends MVIndex<Long, SearchRow> {
    private final MVTable mvTable;
    private final String mapName;
    private final TransactionMap<Long, SearchRow> dataMap;
    private final AtomicLong lastKey = new AtomicLong();
    private int mainIndexColumn = -1;

    public MVPrimaryIndex(Database db, MVTable table, int id, IndexColumn[] columns, IndexType indexType) {
        super(table, id, table.getName() + "_DATA", columns, 0, indexType);
        this.mvTable = table;
        RowDataType valueType = table.getRowFactory().getRowDataType();
        this.mapName = "table." + this.getId();
        Transaction t = this.mvTable.getTransactionBegin();
        this.dataMap = t.openMap(this.mapName, LongDataType.INSTANCE, valueType);
        this.dataMap.map.setVolatile(!table.isPersistData() || !indexType.isPersistent());
        if (!db.isStarting()) {
            this.dataMap.clear();
        }
        t.commit();
        Long k = (Long)this.dataMap.map.lastKey();
        this.lastKey.set(k == null ? 0L : k);
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL(new StringBuilder(), 3).append(".tableScan").toString();
    }

    public void setMainIndexColumn(int mainIndexColumn) {
        this.mainIndexColumn = mainIndexColumn;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public void close(SessionLocal session) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void add(SessionLocal session, Row row) {
        if (this.mainIndexColumn == -1) {
            if (row.getKey() == 0L) {
                row.setKey(this.lastKey.incrementAndGet());
            }
        } else {
            c = row.getValue(this.mainIndexColumn).getLong();
            row.setKey(c);
        }
        if (this.mvTable.getContainsLargeObject()) {
            i = 0;
            len = row.getColumnCount();
            while (i < len) {
                v = row.getValue(i);
                if (v instanceof ValueLob) {
                    lob = ((ValueLob)v).copy(this.database, this.getId());
                    session.removeAtCommitStop(lob);
                    if (v != lob) {
                        row.setValue(i, lob);
                    }
                }
                ++i;
            }
        }
        map = this.getMap(session);
        rowKey = row.getKey();
        try {
            old = (Row)map.putIfAbsent(rowKey, row);
            if (old != null) {
                errorCode = 90131;
                if (map.getImmediate(rowKey) != null || map.getFromSnapshot(rowKey) != null) {
                    errorCode = 23505;
                }
                e = DbException.get(errorCode, this.getDuplicatePrimaryKeyMessage(this.mainIndexColumn).append(' ').append(old).toString());
                e.setSource(this);
                throw e;
            }
            ** GOTO lbl-1000
        }
        catch (MVStoreException e) {
            throw this.mvTable.convertException(e);
        }
        while (!this.lastKey.compareAndSet(last, rowKey)) lbl-1000:
        // 2 sources

        {
            if (rowKey > (last = this.lastKey.get())) continue;
        }
    }

    @Override
    public void remove(SessionLocal session, Row row) {
        if (this.mvTable.getContainsLargeObject()) {
            int i = 0;
            int len = row.getColumnCount();
            while (i < len) {
                Value v = row.getValue(i);
                if (v instanceof ValueLob) {
                    session.removeAtCommit((ValueLob)v);
                }
                ++i;
            }
        }
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        try {
            Row existing = (Row)map.remove(row.getKey());
            if (existing == null) {
                StringBuilder builder = new StringBuilder();
                this.getSQL(builder, 3).append(": ").append(row.getKey());
                throw DbException.get(90112, builder.toString());
            }
        }
        catch (MVStoreException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public void update(SessionLocal session, Row oldRow, Row newRow) {
        if (this.mainIndexColumn != -1) {
            long c = newRow.getValue(this.mainIndexColumn).getLong();
            newRow.setKey(c);
        }
        long key = oldRow.getKey();
        assert (this.mainIndexColumn != -1 || key != 0L);
        assert (key == newRow.getKey()) : key + " != " + newRow.getKey();
        if (this.mvTable.getContainsLargeObject()) {
            int i = 0;
            int len = oldRow.getColumnCount();
            while (i < len) {
                Value newValue;
                Value oldValue = oldRow.getValue(i);
                if (oldValue != (newValue = newRow.getValue(i))) {
                    if (oldValue instanceof ValueLob) {
                        session.removeAtCommit((ValueLob)oldValue);
                    }
                    if (newValue instanceof ValueLob) {
                        ValueLob lob = ((ValueLob)newValue).copy(this.database, this.getId());
                        session.removeAtCommitStop(lob);
                        if (newValue != lob) {
                            newRow.setValue(i, lob);
                        }
                    }
                }
                ++i;
            }
        }
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        try {
            Row existing = (Row)map.put(key, newRow);
            if (existing == null) {
                StringBuilder builder = new StringBuilder();
                this.getSQL(builder, 3).append(": ").append(key);
                throw DbException.get(90112, builder.toString());
            }
        }
        catch (MVStoreException e) {
            throw this.mvTable.convertException(e);
        }
        if (newRow.getKey() > this.lastKey.get()) {
            this.lastKey.set(newRow.getKey());
        }
    }

    Row lockRow(SessionLocal session, Row row, int timeoutMillis) {
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        long key = row.getKey();
        return this.lockRow(map, key, timeoutMillis);
    }

    private Row lockRow(TransactionMap<Long, SearchRow> map, long key, int timeoutMillis) {
        try {
            return MVPrimaryIndex.setRowKey((Row)map.lock(key, timeoutMillis), key);
        }
        catch (MVStoreException ex) {
            throw this.mvTable.convertLockException(ex);
        }
    }

    @Override
    public Cursor find(SessionLocal session, SearchRow first, SearchRow last, boolean reverse) {
        Long max;
        double d;
        Value v;
        Long min;
        if (first == null) {
            min = null;
        } else if (this.mainIndexColumn == -1 || (v = first.getValue(this.mainIndexColumn)) == null) {
            min = first.getKey();
        } else {
            switch (v.getValueType()) {
                case 0: {
                    return SingleRowCursor.EMPTY;
                }
                case 14: 
                case 15: {
                    d = v.getDouble();
                    if (Double.isNaN(d)) {
                        return SingleRowCursor.EMPTY;
                    }
                    min = (long)d;
                    break;
                }
                case 16: {
                    if (!((ValueDecfloat)v).isFinite()) {
                        if (v == ValueDecfloat.NEGATIVE_INFINITY) {
                            min = null;
                            break;
                        }
                        return SingleRowCursor.EMPTY;
                    }
                }
                case 13: {
                    BigDecimal bd = v.getBigDecimal();
                    if (bd.compareTo(Value.MAX_LONG_DECIMAL) > 0) {
                        return SingleRowCursor.EMPTY;
                    }
                    if (bd.compareTo(Value.MIN_LONG_DECIMAL) < 0) {
                        min = null;
                        break;
                    }
                    min = bd.longValue();
                    break;
                }
                default: {
                    min = v.getLong();
                }
            }
        }
        if (last == null) {
            max = null;
        } else if (this.mainIndexColumn == -1 || (v = last.getValue(this.mainIndexColumn)) == null) {
            max = last.getKey();
        } else {
            switch (v.getValueType()) {
                case 0: {
                    return SingleRowCursor.EMPTY;
                }
                case 14: 
                case 15: {
                    d = v.getDouble();
                    if (Double.isNaN(d)) {
                        max = null;
                        break;
                    }
                    max = (long)d;
                    break;
                }
                case 16: {
                    if (!((ValueDecfloat)v).isFinite()) {
                        if (v == ValueDecfloat.NEGATIVE_INFINITY) {
                            return SingleRowCursor.EMPTY;
                        }
                        max = null;
                        break;
                    }
                }
                case 13: {
                    BigDecimal bd = v.getBigDecimal();
                    if (bd.compareTo(Value.MAX_LONG_DECIMAL) > 0) {
                        max = null;
                        break;
                    }
                    if (bd.compareTo(Value.MIN_LONG_DECIMAL) < 0) {
                        return SingleRowCursor.EMPTY;
                    }
                    max = bd.longValue();
                    break;
                }
                default: {
                    max = v.getLong();
                }
            }
        }
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        if (min != null && max != null && min.longValue() == max.longValue()) {
            return new SingleRowCursor(MVPrimaryIndex.setRowKey((Row)map.getFromSnapshot(min), min));
        }
        return new MVStoreCursor(map.entryIterator(min, max, reverse));
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public Row getRow(SessionLocal session, long key) {
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        Row row = (Row)map.getFromSnapshot(key);
        if (row == null) {
            throw DbException.get(90143, this.getTraceSQL(), String.valueOf(key));
        }
        return MVPrimaryIndex.setRowKey(row, key);
    }

    @Override
    public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        try {
            return 10L * this.getCostRangeIndex(masks, this.dataMap.sizeAsLongMax(), filters, filter, sortOrder, true, allColumnsSet);
        }
        catch (MVStoreException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public int getColumnIndex(Column col) {
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return false;
    }

    @Override
    public void remove(SessionLocal session) {
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        if (!map.isClosed()) {
            Transaction t = session.getTransaction();
            t.removeMap(map);
        }
    }

    @Override
    public void truncate(SessionLocal session) {
        if (this.mvTable.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.getMap(session).clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(SessionLocal session, boolean first) {
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        Map.Entry<Long, SearchRow> entry = first ? map.firstEntry() : map.lastEntry();
        return entry != null ? new SingleRowCursor(MVPrimaryIndex.setRowKey((Row)entry.getValue(), entry.getKey())) : SingleRowCursor.EMPTY;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(SessionLocal session) {
        return this.getMap(session).sizeAsLong();
    }

    public long getRowCountMax() {
        return this.dataMap.sizeAsLongMax();
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return this.getRowCountMax();
    }

    public String getMapName() {
        return this.mapName;
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBufferedRows(List<String> bufferNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    TransactionMap<Long, SearchRow> getMap(SessionLocal session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction t = session.getTransaction();
        return this.dataMap.getInstance(t);
    }

    @Override
    public MVMap<Long, VersionedValue<SearchRow>> getMVMap() {
        return this.dataMap.map;
    }

    private static Row setRowKey(Row row, long key) {
        if (row != null && row.getKey() == 0L) {
            row.setKey(key);
        }
        return row;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class MVStoreCursor
    implements Cursor {
        private final TransactionMap.TMIterator<Long, SearchRow, Map.Entry<Long, SearchRow>> it;
        private Map.Entry<Long, SearchRow> current;
        private Row row;

        public MVStoreCursor(TransactionMap.TMIterator<Long, SearchRow, Map.Entry<Long, SearchRow>> it) {
            this.it = it;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                this.row = (Row)this.current.getValue();
                if (this.row.getKey() == 0L) {
                    this.row.setKey(this.current.getKey());
                }
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            this.current = this.it.fetchNext();
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

