/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.Arrays;
import java.util.BitSet;
import org.h2.engine.Database;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.db.MVTempResult;
import org.h2.mvstore.db.NullValueDataType;
import org.h2.mvstore.db.ValueDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.LongDataType;
import org.h2.result.ResultExternal;
import org.h2.result.RowFactory;
import org.h2.result.SortOrder;
import org.h2.value.TypeInfo;
import org.h2.value.Typed;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class MVSortedTempResult
extends MVTempResult {
    private final boolean distinct;
    private final int[] distinctIndexes;
    private final int[] indexes;
    private final MVMap<ValueRow, Long> map;
    private MVMap<ValueRow, Value> index;
    private ValueDataType orderedDistinctOnType;
    private Cursor<ValueRow, Long> cursor;
    private Value[] current;
    private long valueCount;

    private MVSortedTempResult(MVSortedTempResult parent) {
        super(parent);
        this.distinct = parent.distinct;
        this.distinctIndexes = parent.distinctIndexes;
        this.indexes = parent.indexes;
        this.map = parent.map;
        this.rowCount = parent.rowCount;
    }

    MVSortedTempResult(Database database, Expression[] expressions, boolean distinct, int[] distinctIndexes, int visibleColumnCount, int resultColumnCount, SortOrder sort) {
        int i;
        int i2;
        int[] indexes;
        int[] sortTypes;
        block17: {
            super(database, expressions, visibleColumnCount, resultColumnCount);
            this.distinct = distinct;
            this.distinctIndexes = distinctIndexes;
            sortTypes = new int[resultColumnCount];
            if (sort != null) {
                indexes = new int[resultColumnCount];
                int[] colIndex = sort.getQueryColumnIndexes();
                int len = colIndex.length;
                BitSet used = new BitSet();
                i2 = 0;
                while (i2 < len) {
                    int idx = colIndex[i2];
                    assert (!used.get(idx));
                    used.set(idx);
                    indexes[i2] = idx;
                    sortTypes[i2] = sort.getSortTypes()[i2];
                    ++i2;
                }
                int idx = 0;
                i = len;
                while (i < resultColumnCount) {
                    idx = used.nextClearBit(idx);
                    indexes[i] = idx++;
                    ++i;
                }
                i = 0;
                while (i < resultColumnCount) {
                    if (indexes[i] == i) {
                        ++i;
                        continue;
                    }
                    break block17;
                }
                indexes = null;
            } else {
                indexes = null;
            }
        }
        this.indexes = indexes;
        ValueDataType keyType = new ValueDataType(database, SortOrder.addNullOrdering(database, sortTypes));
        if (indexes != null) {
            int l = indexes.length;
            Typed[] types = new TypeInfo[l];
            i2 = 0;
            while (i2 < l) {
                types[i2] = expressions[indexes[i2]].getType();
                ++i2;
            }
            keyType.setRowFactory(RowFactory.DefaultRowFactory.INSTANCE.createRowFactory(database, database.getCompareMode(), database, types, null, false));
        } else {
            keyType.setRowFactory(RowFactory.DefaultRowFactory.INSTANCE.createRowFactory(database, database.getCompareMode(), database, expressions, null, false));
        }
        MVMap.BasicBuilder builder = ((MVMap.Builder)new MVMap.Builder().keyType((DataType)keyType)).valueType((DataType)LongDataType.INSTANCE);
        this.map = this.store.openMap("tmp", builder);
        if (distinct && resultColumnCount != visibleColumnCount || distinctIndexes != null) {
            DataType<Value> distinctValueType;
            Typed[] types;
            int count;
            if (distinctIndexes != null) {
                count = distinctIndexes.length;
                types = new TypeInfo[count];
                i = 0;
                while (i < count) {
                    types[i] = expressions[distinctIndexes[i]].getType();
                    ++i;
                }
            } else {
                count = visibleColumnCount;
                types = new TypeInfo[count];
                i = 0;
                while (i < count) {
                    types[i] = expressions[i].getType();
                    ++i;
                }
            }
            ValueDataType distinctType = new ValueDataType(database, new int[count]);
            distinctType.setRowFactory(RowFactory.DefaultRowFactory.INSTANCE.createRowFactory(database, database.getCompareMode(), database, types, null, false));
            if (distinctIndexes != null && sort != null) {
                this.orderedDistinctOnType = keyType;
                distinctValueType = this.orderedDistinctOnType;
            } else {
                distinctValueType = NullValueDataType.INSTANCE;
            }
            MVMap.BasicBuilder indexBuilder = ((MVMap.Builder)new MVMap.Builder().keyType((DataType)distinctType)).valueType(distinctValueType);
            this.index = this.store.openMap("idx", indexBuilder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int addRow(Value[] values) {
        assert (this.parent == null);
        ValueRow key = this.getKey(values);
        if (this.distinct || this.distinctIndexes != null) {
            ValueRow distinctRow;
            if (this.distinctIndexes != null) {
                int cnt = this.distinctIndexes.length;
                Value[] newValues = new Value[cnt];
                int i = 0;
                while (i < cnt) {
                    newValues[i] = values[this.distinctIndexes[i]];
                    ++i;
                }
                ValueRow distinctRow2 = ValueRow.get(newValues);
                if (this.orderedDistinctOnType == null) {
                    if (this.index.putIfAbsent(distinctRow2, ValueNull.INSTANCE) != null) {
                        return this.rowCount;
                    }
                } else {
                    ValueRow previous = (ValueRow)this.index.get(distinctRow2);
                    if (previous == null) {
                        this.index.put(distinctRow2, key);
                    } else {
                        if (this.orderedDistinctOnType.compare(previous, key) <= 0) return this.rowCount;
                        this.map.remove(previous);
                        --this.rowCount;
                        this.index.put(distinctRow2, key);
                    }
                }
            } else if (this.visibleColumnCount != this.resultColumnCount && this.index.putIfAbsent(distinctRow = ValueRow.get(Arrays.copyOf(values, this.visibleColumnCount)), ValueNull.INSTANCE) != null) {
                return this.rowCount;
            }
            if (this.map.putIfAbsent(key, 1L) != null) return this.rowCount;
            ++this.rowCount;
            return this.rowCount;
        } else {
            Long old = this.map.putIfAbsent(key, 1L);
            if (old != null) {
                this.map.put(key, old + 1L);
            }
            ++this.rowCount;
        }
        return this.rowCount;
    }

    @Override
    public boolean contains(Value[] values) {
        if (this.parent != null) {
            return this.parent.contains(values);
        }
        assert (this.distinct);
        if (this.visibleColumnCount != this.resultColumnCount) {
            return this.index.containsKey(ValueRow.get(values));
        }
        return this.map.containsKey(this.getKey(values));
    }

    @Override
    public synchronized ResultExternal createShallowCopy() {
        if (this.parent != null) {
            return this.parent.createShallowCopy();
        }
        if (this.closed) {
            return null;
        }
        ++this.childCount;
        return new MVSortedTempResult(this);
    }

    private ValueRow getKey(Value[] values) {
        if (this.indexes != null) {
            Value[] r = new Value[this.indexes.length];
            int i = 0;
            while (i < this.indexes.length) {
                r[i] = values[this.indexes[i]];
                ++i;
            }
            values = r;
        }
        return ValueRow.get(values);
    }

    private Value[] getValue(Value[] key) {
        if (this.indexes != null) {
            Value[] r = new Value[this.indexes.length];
            int i = 0;
            while (i < this.indexes.length) {
                r[this.indexes[i]] = key[i];
                ++i;
            }
            key = r;
        }
        return key;
    }

    @Override
    public Value[] next() {
        if (this.cursor == null) {
            this.cursor = this.map.cursor(null);
            this.current = null;
            this.valueCount = 0L;
        }
        if (--this.valueCount > 0L) {
            return this.current;
        }
        if (!this.cursor.hasNext()) {
            this.current = null;
            return null;
        }
        this.current = this.getValue(this.cursor.next().getList());
        this.valueCount = this.cursor.getValue();
        return this.current;
    }

    @Override
    public int removeRow(Value[] values) {
        assert (this.parent == null && this.distinct);
        if (this.visibleColumnCount != this.resultColumnCount) {
            throw DbException.getUnsupportedException("removeRow()");
        }
        if (this.map.remove(this.getKey(values)) != null) {
            --this.rowCount;
        }
        return this.rowCount;
    }

    @Override
    public void reset() {
        this.cursor = null;
        this.current = null;
        this.valueCount = 0L;
    }
}

