/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.Arrays;
import org.h2.engine.CastDataProvider;
import org.h2.mvstore.rtree.Spatial;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SpatialKey
extends Value
implements Spatial {
    private final long id;
    private final float[] minMax;

    public SpatialKey(long id, float ... minMax) {
        this.id = id;
        this.minMax = minMax;
    }

    public SpatialKey(long id, SpatialKey other) {
        this.id = id;
        this.minMax = (float[])other.minMax.clone();
    }

    @Override
    public float min(int dim) {
        return this.minMax[dim + dim];
    }

    @Override
    public void setMin(int dim, float x) {
        this.minMax[dim + dim] = x;
    }

    @Override
    public float max(int dim) {
        return this.minMax[dim + dim + 1];
    }

    @Override
    public void setMax(int dim, float x) {
        this.minMax[dim + dim + 1] = x;
    }

    @Override
    public Spatial clone(long id) {
        return new SpatialKey(id, this);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean isNull() {
        return this.minMax.length == 0;
    }

    @Override
    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return (int)(this.id >>> 32 ^ this.id);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SpatialKey)) {
            return false;
        }
        SpatialKey o = (SpatialKey)other;
        if (this.id != o.id) {
            return false;
        }
        return this.equalsIgnoringId(o);
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode, CastDataProvider provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equalsIgnoringId(Spatial o) {
        return Arrays.equals(this.minMax, ((SpatialKey)o).minMax);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        builder.append(this.id).append(": (");
        int i = 0;
        while (i < this.minMax.length) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.minMax[i]).append('/').append(this.minMax[i + 1]);
            i += 2;
        }
        builder.append(")");
        return builder;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_GEOMETRY;
    }

    @Override
    public int getValueType() {
        return 37;
    }

    @Override
    public String getString() {
        return this.getTraceSQL();
    }
}

