/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Database;
import org.h2.message.DbException;
import org.h2.mode.DefaultNullOrdering;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.MetaType;
import org.h2.mvstore.type.StatefulDataType;
import org.h2.result.RowFactory;
import org.h2.result.SearchRow;
import org.h2.store.DataHandler;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBinary;
import org.h2.value.ValueBlob;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueChar;
import org.h2.value.ValueClob;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueDouble;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueRow;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;
import org.h2.value.lob.LobData;
import org.h2.value.lob.LobDataDatabase;
import org.h2.value.lob.LobDataInMemory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueDataType
extends BasicDataType<Value>
implements StatefulDataType<Database> {
    private static final byte NULL = 0;
    private static final byte TINYINT = 2;
    private static final byte SMALLINT = 3;
    private static final byte INTEGER = 4;
    private static final byte BIGINT = 5;
    private static final byte NUMERIC = 6;
    private static final byte DOUBLE = 7;
    private static final byte REAL = 8;
    private static final byte TIME = 9;
    private static final byte DATE = 10;
    private static final byte TIMESTAMP = 11;
    private static final byte VARBINARY = 12;
    private static final byte VARCHAR = 13;
    private static final byte VARCHAR_IGNORECASE = 14;
    private static final byte BLOB = 15;
    private static final byte CLOB = 16;
    private static final byte ARRAY = 17;
    private static final byte JAVA_OBJECT = 19;
    private static final byte UUID = 20;
    private static final byte CHAR = 21;
    private static final byte GEOMETRY = 22;
    private static final byte TIMESTAMP_TZ_OLD = 24;
    private static final byte ENUM = 25;
    private static final byte INTERVAL = 26;
    private static final byte ROW = 27;
    private static final byte INT_0_15 = 32;
    private static final byte BIGINT_0_7 = 48;
    private static final byte NUMERIC_0_1 = 56;
    private static final byte NUMERIC_SMALL_0 = 58;
    private static final byte NUMERIC_SMALL = 59;
    private static final byte DOUBLE_0_1 = 60;
    private static final byte REAL_0_1 = 62;
    private static final byte BOOLEAN_FALSE = 64;
    private static final byte BOOLEAN_TRUE = 65;
    private static final byte INT_NEG = 66;
    private static final byte BIGINT_NEG = 67;
    private static final byte VARCHAR_0_31 = 68;
    private static final int VARBINARY_0_31 = 100;
    private static final int JSON = 134;
    private static final int TIMESTAMP_TZ = 135;
    private static final int TIME_TZ = 136;
    private static final int BINARY = 137;
    private static final int DECFLOAT = 138;
    final DataHandler handler;
    final CastDataProvider provider;
    final CompareMode compareMode;
    final int[] sortTypes;
    private RowFactory rowFactory;
    private static final Factory FACTORY = new Factory();

    public ValueDataType() {
        this(null, CompareMode.getInstance(null, 0), null, null);
    }

    public ValueDataType(Database database, int[] sortTypes) {
        this(database, database.getCompareMode(), database, sortTypes);
    }

    public ValueDataType(CastDataProvider provider, CompareMode compareMode, DataHandler handler, int[] sortTypes) {
        this.provider = provider;
        this.compareMode = compareMode;
        this.handler = handler;
        this.sortTypes = sortTypes;
    }

    public RowFactory getRowFactory() {
        return this.rowFactory;
    }

    public void setRowFactory(RowFactory rowFactory) {
        this.rowFactory = rowFactory;
    }

    public Value[] createStorage(int size) {
        return new Value[size];
    }

    @Override
    public int compare(Value a, Value b) {
        if (a == b) {
            return 0;
        }
        if (a instanceof SearchRow && b instanceof SearchRow) {
            return this.compare((SearchRow)a, (SearchRow)b);
        }
        if (a instanceof ValueCollectionBase && b instanceof ValueCollectionBase) {
            Value[] ax = ((ValueCollectionBase)a).getList();
            Value[] bx = ((ValueCollectionBase)b).getList();
            int al = ax.length;
            int bl = bx.length;
            int len = Math.min(al, bl);
            int i = 0;
            while (i < len) {
                int sortType = this.sortTypes == null ? 0 : this.sortTypes[i];
                Value one = ax[i];
                Value two = bx[i];
                if (one == null || two == null) {
                    return this.compareValues(ax[len - 1], bx[len - 1], 0);
                }
                int comp = this.compareValues(one, two, sortType);
                if (comp != 0) {
                    return comp;
                }
                ++i;
            }
            if (len < al) {
                return -1;
            }
            if (len < bl) {
                return 1;
            }
            return 0;
        }
        return this.compareValues(a, b, 0);
    }

    @Override
    private int compare(SearchRow a, SearchRow b) {
        if (a == b) {
            return 0;
        }
        int[] indexes = this.rowFactory.getIndexes();
        if (indexes == null) {
            int len = a.getColumnCount();
            assert (len == b.getColumnCount()) : len + " != " + b.getColumnCount();
            int i = 0;
            while (i < len) {
                int comp = this.compareValues(a.getValue(i), b.getValue(i), this.sortTypes[i]);
                if (comp != 0) {
                    return comp;
                }
                ++i;
            }
            return 0;
        }
        assert (this.sortTypes.length == indexes.length);
        int i = 0;
        while (i < indexes.length) {
            int index = indexes[i];
            Value v1 = a.getValue(index);
            Value v2 = b.getValue(index);
            if (v1 == null || v2 == null) break;
            int comp = this.compareValues(a.getValue(index), b.getValue(index), this.sortTypes[i]);
            if (comp != 0) {
                return comp;
            }
            ++i;
        }
        long aKey = a.getKey();
        long bKey = b.getKey();
        return aKey == SearchRow.MATCH_ALL_ROW_KEY || bKey == SearchRow.MATCH_ALL_ROW_KEY ? 0 : Long.compare(aKey, bKey);
    }

    public int compareValues(Value a, Value b, int sortType) {
        boolean aNull;
        if (a == b) {
            return 0;
        }
        boolean bl = aNull = a == ValueNull.INSTANCE;
        if (aNull || b == ValueNull.INSTANCE) {
            return DefaultNullOrdering.LOW.compareNull(aNull, sortType);
        }
        int comp = a.compareTo(b, this.provider, this.compareMode);
        if ((sortType & 1) != 0) {
            comp = -comp;
        }
        return comp;
    }

    @Override
    public int getMemory(Value v) {
        return v == null ? 0 : v.getMemory();
    }

    @Override
    public Value read(ByteBuffer buff) {
        return this.readValue(buff, null);
    }

    @Override
    public void write(WriteBuffer buff, Value v) {
        if (v == ValueNull.INSTANCE) {
            buff.put((byte)0);
            return;
        }
        int type = v.getValueType();
        switch (type) {
            case 8: {
                buff.put(v.getBoolean() ? (byte)65 : 64);
                break;
            }
            case 9: {
                buff.put((byte)2).put(v.getByte());
                break;
            }
            case 10: {
                buff.put((byte)3).putShort(v.getShort());
                break;
            }
            case 11: 
            case 36: {
                int x = v.getInt();
                if (x < 0) {
                    buff.put((byte)66).putVarInt(-x);
                    break;
                }
                if (x < 16) {
                    buff.put((byte)(32 + x));
                    break;
                }
                buff.put(type == 11 ? (byte)4 : 25).putVarInt(x);
                break;
            }
            case 12: {
                ValueDataType.writeLong(buff, v.getLong());
                break;
            }
            case 13: {
                BigDecimal x = v.getBigDecimal();
                if (BigDecimal.ZERO.equals(x)) {
                    buff.put((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(x)) {
                    buff.put((byte)57);
                    break;
                }
                int scale = x.scale();
                BigInteger b = x.unscaledValue();
                int bits = b.bitLength();
                if (bits <= 63) {
                    if (scale == 0) {
                        buff.put((byte)58).putVarLong(b.longValue());
                        break;
                    }
                    buff.put((byte)59).putVarInt(scale).putVarLong(b.longValue());
                    break;
                }
                byte[] bytes = b.toByteArray();
                buff.put((byte)6).putVarInt(scale).putVarInt(bytes.length).put(bytes);
                break;
            }
            case 16: {
                ValueDecfloat d = (ValueDecfloat)v;
                buff.put((byte)-118);
                if (d.isFinite()) {
                    BigDecimal x = d.getBigDecimal();
                    byte[] bytes = x.unscaledValue().toByteArray();
                    buff.putVarInt(x.scale()).putVarInt(bytes.length).put(bytes);
                    break;
                }
                int c = d == ValueDecfloat.NEGATIVE_INFINITY ? -3 : (d == ValueDecfloat.POSITIVE_INFINITY ? -2 : -1);
                buff.putVarInt(0).putVarInt(c);
                break;
            }
            case 18: {
                ValueDataType.writeTimestampTime(buff.put((byte)9), ((ValueTime)v).getNanos());
                break;
            }
            case 19: {
                ValueTimeTimeZone t = (ValueTimeTimeZone)v;
                long nanosOfDay = t.getNanos();
                buff.put((byte)-120).putVarInt((int)(nanosOfDay / 1000000000L)).putVarInt((int)(nanosOfDay % 1000000000L));
                ValueDataType.writeTimeZone(buff, t.getTimeZoneOffsetSeconds());
                break;
            }
            case 17: {
                buff.put((byte)10).putVarLong(((ValueDate)v).getDateValue());
                break;
            }
            case 20: {
                ValueTimestamp ts = (ValueTimestamp)v;
                buff.put((byte)11).putVarLong(ts.getDateValue());
                ValueDataType.writeTimestampTime(buff, ts.getTimeNanos());
                break;
            }
            case 21: {
                ValueTimestampTimeZone ts = (ValueTimestampTimeZone)v;
                buff.put((byte)-121).putVarLong(ts.getDateValue());
                ValueDataType.writeTimestampTime(buff, ts.getTimeNanos());
                ValueDataType.writeTimeZone(buff, ts.getTimeZoneOffsetSeconds());
                break;
            }
            case 35: {
                ValueDataType.writeBinary((byte)19, buff, v);
                break;
            }
            case 6: {
                byte[] b = v.getBytesNoCopy();
                int len = b.length;
                if (len < 32) {
                    buff.put((byte)(100 + len)).put(b);
                    break;
                }
                buff.put((byte)12).putVarInt(len).put(b);
                break;
            }
            case 5: {
                ValueDataType.writeBinary((byte)-119, buff, v);
                break;
            }
            case 39: {
                ValueUuid uuid = (ValueUuid)v;
                buff.put((byte)20).putLong(uuid.getHigh()).putLong(uuid.getLow());
                break;
            }
            case 2: {
                String s = v.getString();
                int len = s.length();
                if (len < 32) {
                    buff.put((byte)(68 + len)).putStringData(s, len);
                    break;
                }
                ValueDataType.writeString(buff.put((byte)13), s);
                break;
            }
            case 4: {
                ValueDataType.writeString(buff.put((byte)14), v.getString());
                break;
            }
            case 1: {
                ValueDataType.writeString(buff.put((byte)21), v.getString());
                break;
            }
            case 15: {
                double x = v.getDouble();
                if (x == 1.0) {
                    buff.put((byte)61);
                    break;
                }
                long d = Double.doubleToLongBits(x);
                if (d == 0L) {
                    buff.put((byte)60);
                    break;
                }
                buff.put((byte)7).putVarLong(Long.reverse(d));
                break;
            }
            case 14: {
                float x = v.getFloat();
                if (x == 1.0f) {
                    buff.put((byte)63);
                    break;
                }
                int f = Float.floatToIntBits(x);
                if (f == 0) {
                    buff.put((byte)62);
                    break;
                }
                buff.put((byte)8).putVarInt(Integer.reverse(f));
                break;
            }
            case 7: {
                buff.put((byte)15);
                ValueBlob lob = (ValueBlob)v;
                LobData lobData = lob.getLobData();
                if (lobData instanceof LobDataDatabase) {
                    LobDataDatabase lobDataDatabase = (LobDataDatabase)lobData;
                    buff.putVarInt(-3).putVarInt(lobDataDatabase.getTableId()).putVarLong(lobDataDatabase.getLobId()).putVarLong(lob.octetLength());
                    break;
                }
                byte[] small = ((LobDataInMemory)lobData).getSmall();
                buff.putVarInt(small.length).put(small);
                break;
            }
            case 3: {
                buff.put((byte)16);
                ValueClob lob = (ValueClob)v;
                LobData lobData = lob.getLobData();
                if (lobData instanceof LobDataDatabase) {
                    LobDataDatabase lobDataDatabase = (LobDataDatabase)lobData;
                    buff.putVarInt(-3).putVarInt(lobDataDatabase.getTableId()).putVarLong(lobDataDatabase.getLobId()).putVarLong(lob.octetLength()).putVarLong(lob.charLength());
                    break;
                }
                byte[] small = ((LobDataInMemory)lobData).getSmall();
                buff.putVarInt(small.length).put(small).putVarLong(lob.charLength());
                break;
            }
            case 40: 
            case 41: {
                Value[] list = ((ValueCollectionBase)v).getList();
                buff.put(type == 40 ? (byte)17 : 27).putVarInt(list.length);
                Value[] valueArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    Value x = valueArray[n2];
                    this.write(buff, x);
                    ++n2;
                }
                break;
            }
            case 37: {
                ValueDataType.writeBinary((byte)22, buff, v);
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                ValueInterval interval = (ValueInterval)v;
                int ordinal = type - 22;
                if (interval.isNegative()) {
                    ordinal ^= 0xFFFFFFFF;
                }
                buff.put((byte)26).put((byte)ordinal).putVarLong(interval.getLeading());
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                ValueInterval interval = (ValueInterval)v;
                int ordinal = type - 22;
                if (interval.isNegative()) {
                    ordinal ^= 0xFFFFFFFF;
                }
                buff.put((byte)26).put((byte)ordinal).putVarLong(interval.getLeading()).putVarLong(interval.getRemaining());
                break;
            }
            case 38: {
                ValueDataType.writeBinary((byte)-122, buff, v);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + v.getValueType());
            }
        }
    }

    private static void writeBinary(byte type, WriteBuffer buff, Value v) {
        byte[] b = v.getBytesNoCopy();
        buff.put(type).putVarInt(b.length).put(b);
    }

    public static void writeLong(WriteBuffer buff, long x) {
        if (x < 0L) {
            buff.put((byte)67).putVarLong(-x);
        } else if (x < 8L) {
            buff.put((byte)(48L + x));
        } else {
            buff.put((byte)5).putVarLong(x);
        }
    }

    private static void writeString(WriteBuffer buff, String s) {
        int len = s.length();
        buff.putVarInt(len).putStringData(s, len);
    }

    private static void writeTimestampTime(WriteBuffer buff, long nanos) {
        long millis = nanos / 1000000L;
        buff.putVarLong(millis).putVarInt((int)(nanos - millis * 1000000L));
    }

    private static void writeTimeZone(WriteBuffer buff, int timeZoneOffset) {
        if (timeZoneOffset % 900 == 0) {
            buff.put((byte)(timeZoneOffset / 900));
        } else if (timeZoneOffset > 0) {
            buff.put((byte)127).putVarInt(timeZoneOffset);
        } else {
            buff.put((byte)-128).putVarInt(-timeZoneOffset);
        }
    }

    Value readValue(ByteBuffer buff, TypeInfo columnType) {
        int type = buff.get() & 0xFF;
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.TRUE;
            }
            case 64: {
                return ValueBoolean.FALSE;
            }
            case 66: {
                return ValueInteger.get(-DataUtils.readVarInt(buff));
            }
            case 4: {
                return ValueInteger.get(DataUtils.readVarInt(buff));
            }
            case 67: {
                return ValueBigint.get(-DataUtils.readVarLong(buff));
            }
            case 5: {
                return ValueBigint.get(DataUtils.readVarLong(buff));
            }
            case 2: {
                return ValueTinyint.get(buff.get());
            }
            case 3: {
                return ValueSmallint.get(buff.getShort());
            }
            case 56: {
                return ValueNumeric.ZERO;
            }
            case 57: {
                return ValueNumeric.ONE;
            }
            case 58: {
                return ValueNumeric.get(BigDecimal.valueOf(DataUtils.readVarLong(buff)));
            }
            case 59: {
                int scale = DataUtils.readVarInt(buff);
                return ValueNumeric.get(BigDecimal.valueOf(DataUtils.readVarLong(buff), scale));
            }
            case 6: {
                int scale = DataUtils.readVarInt(buff);
                return ValueNumeric.get(new BigDecimal(new BigInteger(ValueDataType.readVarBytes(buff)), scale));
            }
            case 138: {
                int scale = DataUtils.readVarInt(buff);
                int len = DataUtils.readVarInt(buff);
                switch (len) {
                    case -3: {
                        return ValueDecfloat.NEGATIVE_INFINITY;
                    }
                    case -2: {
                        return ValueDecfloat.POSITIVE_INFINITY;
                    }
                    case -1: {
                        return ValueDecfloat.NAN;
                    }
                }
                byte[] b = Utils.newBytes(len);
                buff.get(b, 0, len);
                return ValueDecfloat.get(new BigDecimal(new BigInteger(b), scale));
            }
            case 10: {
                return ValueDate.fromDateValue(DataUtils.readVarLong(buff));
            }
            case 9: {
                return ValueTime.fromNanos(ValueDataType.readTimestampTime(buff));
            }
            case 136: {
                return ValueTimeTimeZone.fromNanos((long)DataUtils.readVarInt(buff) * 1000000000L + (long)DataUtils.readVarInt(buff), ValueDataType.readTimeZone(buff));
            }
            case 11: {
                return ValueTimestamp.fromDateValueAndNanos(DataUtils.readVarLong(buff), ValueDataType.readTimestampTime(buff));
            }
            case 24: {
                return ValueTimestampTimeZone.fromDateValueAndNanos(DataUtils.readVarLong(buff), ValueDataType.readTimestampTime(buff), DataUtils.readVarInt(buff) * 60);
            }
            case 135: {
                return ValueTimestampTimeZone.fromDateValueAndNanos(DataUtils.readVarLong(buff), ValueDataType.readTimestampTime(buff), ValueDataType.readTimeZone(buff));
            }
            case 12: {
                return ValueVarbinary.getNoCopy(ValueDataType.readVarBytes(buff));
            }
            case 137: {
                return ValueBinary.getNoCopy(ValueDataType.readVarBytes(buff));
            }
            case 19: {
                return ValueJavaObject.getNoCopy(ValueDataType.readVarBytes(buff));
            }
            case 20: {
                return ValueUuid.get(buff.getLong(), buff.getLong());
            }
            case 13: {
                return ValueVarchar.get(DataUtils.readString(buff));
            }
            case 14: {
                return ValueVarcharIgnoreCase.get(DataUtils.readString(buff));
            }
            case 21: {
                return ValueChar.get(DataUtils.readString(buff));
            }
            case 25: {
                int ordinal = DataUtils.readVarInt(buff);
                if (columnType != null) {
                    return ((ExtTypeInfoEnum)columnType.getExtTypeInfo()).getValue(ordinal, this.provider);
                }
                return ValueInteger.get(ordinal);
            }
            case 26: {
                boolean negative;
                int ordinal = buff.get();
                boolean bl = negative = ordinal < 0;
                if (negative) {
                    ordinal ^= 0xFFFFFFFF;
                }
                return ValueInterval.from(IntervalQualifier.valueOf(ordinal), negative, DataUtils.readVarLong(buff), ordinal < 5 ? 0L : DataUtils.readVarLong(buff));
            }
            case 62: {
                return ValueReal.ZERO;
            }
            case 63: {
                return ValueReal.ONE;
            }
            case 60: {
                return ValueDouble.ZERO;
            }
            case 61: {
                return ValueDouble.ONE;
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(DataUtils.readVarLong(buff))));
            }
            case 8: {
                return ValueReal.get(Float.intBitsToFloat(Integer.reverse(DataUtils.readVarInt(buff))));
            }
            case 15: {
                int smallLen = DataUtils.readVarInt(buff);
                if (smallLen >= 0) {
                    byte[] small = Utils.newBytes(smallLen);
                    buff.get(small, 0, smallLen);
                    return ValueBlob.createSmall(small);
                }
                if (smallLen == -3) {
                    return new ValueBlob(this.readLobDataDatabase(buff), DataUtils.readVarLong(buff));
                }
                throw DbException.get(90030, "lob type: " + smallLen);
            }
            case 16: {
                int smallLen = DataUtils.readVarInt(buff);
                if (smallLen >= 0) {
                    byte[] small = Utils.newBytes(smallLen);
                    buff.get(small, 0, smallLen);
                    return ValueClob.createSmall(small, DataUtils.readVarLong(buff));
                }
                if (smallLen == -3) {
                    return new ValueClob(this.readLobDataDatabase(buff), DataUtils.readVarLong(buff), DataUtils.readVarLong(buff));
                }
                throw DbException.get(90030, "lob type: " + smallLen);
            }
            case 17: {
                if (columnType != null) {
                    TypeInfo elementType = (TypeInfo)columnType.getExtTypeInfo();
                    return ValueArray.get(elementType, this.readArrayElements(buff, elementType), this.provider);
                }
                return ValueArray.get(this.readArrayElements(buff, null), this.provider);
            }
            case 27: {
                int len = DataUtils.readVarInt(buff);
                Value[] list = new Value[len];
                if (columnType != null) {
                    ExtTypeInfoRow extTypeInfoRow = (ExtTypeInfoRow)columnType.getExtTypeInfo();
                    Iterator<Map.Entry<String, TypeInfo>> fields = extTypeInfoRow.getFields().iterator();
                    int i = 0;
                    while (i < len) {
                        list[i] = this.readValue(buff, fields.next().getValue());
                        ++i;
                    }
                    return ValueRow.get(columnType, list);
                }
                TypeInfo[] columnTypes = this.rowFactory.getColumnTypes();
                int i = 0;
                while (i < len) {
                    list[i] = this.readValue(buff, columnTypes[i]);
                    ++i;
                }
                return ValueRow.get(list);
            }
            case 22: {
                return ValueGeometry.get(ValueDataType.readVarBytes(buff));
            }
            case 134: {
                return ValueJson.getInternal(ValueDataType.readVarBytes(buff));
            }
        }
        if (type >= 32 && type < 48) {
            int i = type - 32;
            if (columnType != null && columnType.getValueType() == 36) {
                return ((ExtTypeInfoEnum)columnType.getExtTypeInfo()).getValue(i, this.provider);
            }
            return ValueInteger.get(i);
        }
        if (type >= 48 && type < 56) {
            return ValueBigint.get(type - 48);
        }
        if (type >= 100 && type < 132) {
            int len = type - 100;
            byte[] b = Utils.newBytes(len);
            buff.get(b, 0, len);
            return ValueVarbinary.getNoCopy(b);
        }
        if (type >= 68 && type < 100) {
            return ValueVarchar.get(DataUtils.readString(buff, type - 68));
        }
        throw DbException.get(90030, "type: " + type);
    }

    private LobDataDatabase readLobDataDatabase(ByteBuffer buff) {
        int tableId = DataUtils.readVarInt(buff);
        long lobId = DataUtils.readVarLong(buff);
        LobDataDatabase lobData = new LobDataDatabase(this.handler, tableId, lobId);
        return lobData;
    }

    private Value[] readArrayElements(ByteBuffer buff, TypeInfo elementType) {
        int len = DataUtils.readVarInt(buff);
        Value[] list = new Value[len];
        int i = 0;
        while (i < len) {
            list[i] = this.readValue(buff, elementType);
            ++i;
        }
        return list;
    }

    private static byte[] readVarBytes(ByteBuffer buff) {
        int len = DataUtils.readVarInt(buff);
        byte[] b = Utils.newBytes(len);
        buff.get(b, 0, len);
        return b;
    }

    private static long readTimestampTime(ByteBuffer buff) {
        return DataUtils.readVarLong(buff) * 1000000L + (long)DataUtils.readVarInt(buff);
    }

    private static int readTimeZone(ByteBuffer buff) {
        byte b = buff.get();
        if (b == 127) {
            return DataUtils.readVarInt(buff);
        }
        if (b == -128) {
            return -DataUtils.readVarInt(buff);
        }
        return b * 900;
    }

    @Override
    public boolean equals(Object obj) {
        int[] indexes2;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueDataType)) {
            return false;
        }
        ValueDataType v = (ValueDataType)obj;
        if (!this.compareMode.equals(v.compareMode)) {
            return false;
        }
        int[] indexes = this.rowFactory == null ? null : this.rowFactory.getIndexes();
        int[] nArray = indexes2 = v.rowFactory == null ? null : v.rowFactory.getIndexes();
        return Arrays.equals(this.sortTypes, v.sortTypes) && Arrays.equals(indexes, indexes2);
    }

    @Override
    public int hashCode() {
        int[] indexes = this.rowFactory == null ? null : this.rowFactory.getIndexes();
        return super.hashCode() ^ Arrays.hashCode(indexes) ^ this.compareMode.hashCode() ^ Arrays.hashCode(this.sortTypes);
    }

    @Override
    public void save(WriteBuffer buff, MetaType<Database> metaType) {
        ValueDataType.writeIntArray(buff, this.sortTypes);
        int columnCount = this.rowFactory == null ? 0 : this.rowFactory.getColumnCount();
        buff.putVarInt(columnCount);
        int[] indexes = this.rowFactory == null ? null : this.rowFactory.getIndexes();
        ValueDataType.writeIntArray(buff, indexes);
        buff.put(this.rowFactory == null || this.rowFactory.getRowDataType().isStoreKeys() ? (byte)1 : 0);
    }

    private static void writeIntArray(WriteBuffer buff, int[] array) {
        if (array == null) {
            buff.putVarInt(0);
        } else {
            buff.putVarInt(array.length + 1);
            int[] nArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                buff.putVarInt(i);
                ++n2;
            }
        }
    }

    public Factory getFactory() {
        return FACTORY;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Factory
    implements StatefulDataType.Factory<Database> {
        @Override
        public DataType<?> create(ByteBuffer buff, MetaType<Database> metaType, Database database) {
            CompareMode compareMode;
            int[] sortTypes = Factory.readIntArray(buff);
            int columnCount = DataUtils.readVarInt(buff);
            int[] indexes = Factory.readIntArray(buff);
            boolean storeKeys = buff.get() != 0;
            CompareMode compareMode2 = compareMode = database == null ? CompareMode.getInstance(null, 0) : database.getCompareMode();
            if (database == null) {
                return new ValueDataType();
            }
            if (sortTypes == null) {
                return new ValueDataType(database, null);
            }
            RowFactory rowFactory = RowFactory.getDefaultRowFactory().createRowFactory(database, compareMode, database, sortTypes, indexes, null, columnCount, storeKeys);
            return rowFactory.getRowDataType();
        }

        private static int[] readIntArray(ByteBuffer buff) {
            int len = DataUtils.readVarInt(buff) - 1;
            if (len < 0) {
                return null;
            }
            int[] res = new int[len];
            int i = 0;
            while (i < res.length) {
                res[i] = DataUtils.readVarInt(buff);
                ++i;
            }
            return res;
        }
    }
}

