/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import org.h2.mvstore.MVMap;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.tx.VersionedValueCommitted;
import org.h2.value.VersionedValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class CommitDecisionMaker<V>
extends MVMap.DecisionMaker<VersionedValue<V>> {
    private long undoKey;
    private MVMap.Decision decision;

    CommitDecisionMaker() {
    }

    void setUndoKey(long undoKey) {
        this.undoKey = undoKey;
        this.reset();
    }

    @Override
    public MVMap.Decision decide(VersionedValue<V> existingValue, VersionedValue<V> providedValue) {
        assert (this.decision == null);
        this.decision = existingValue == null || existingValue.getOperationId() != this.undoKey ? MVMap.Decision.ABORT : (existingValue.getCurrentValue() == null ? MVMap.Decision.REMOVE : MVMap.Decision.PUT);
        return this.decision;
    }

    @Override
    public <T extends VersionedValue<V>> T selectValue(T existingValue, T providedValue) {
        assert (this.decision == MVMap.Decision.PUT);
        assert (existingValue != null);
        return (T)VersionedValueCommitted.getInstance(existingValue.getCurrentValue());
    }

    @Override
    public void reset() {
        this.decision = null;
    }

    public String toString() {
        return "commit " + TransactionStore.getTransactionId(this.undoKey);
    }
}

