/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import java.util.function.Function;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.tx.Record;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.tx.VersionedValueCommitted;
import org.h2.mvstore.tx.VersionedValueUncommitted;
import org.h2.mvstore.type.DataType;
import org.h2.value.VersionedValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class TxDecisionMaker<K, V>
extends MVMap.DecisionMaker<VersionedValue<V>> {
    private final int mapId;
    protected K key;
    private V value;
    private final Transaction transaction;
    private long undoKey;
    private long lastOperationId;
    private Transaction blockingTransaction;
    private MVMap.Decision decision;
    private V lastValue;

    TxDecisionMaker(int mapId, Transaction transaction) {
        this.mapId = mapId;
        this.transaction = transaction;
    }

    void initialize(K key, V value) {
        this.key = key;
        this.value = value;
        this.decision = null;
        this.reset();
    }

    @Override
    public MVMap.Decision decide(VersionedValue<V> existingValue, VersionedValue<V> providedValue) {
        int blockingId;
        long id;
        assert (this.decision == null);
        if (existingValue == null || (id = existingValue.getOperationId()) == 0L || this.isThisTransaction(blockingId = TransactionStore.getTransactionId(id))) {
            this.logAndDecideToPut(existingValue, existingValue == null ? null : (V)existingValue.getCommittedValue());
        } else if (this.isCommitted(blockingId)) {
            V currentValue = existingValue.getCurrentValue();
            this.logAndDecideToPut(currentValue == null ? null : VersionedValueCommitted.getInstance(currentValue), currentValue);
        } else if (this.getBlockingTransaction() != null) {
            this.lastValue = existingValue.getCurrentValue();
            this.decision = MVMap.Decision.ABORT;
        } else if (this.isRepeatedOperation(id)) {
            V committedValue = existingValue.getCommittedValue();
            this.logAndDecideToPut(committedValue == null ? null : VersionedValueCommitted.getInstance(committedValue), committedValue);
        } else {
            this.decision = MVMap.Decision.REPEAT;
        }
        return this.decision;
    }

    @Override
    public final void reset() {
        if (this.decision != MVMap.Decision.REPEAT) {
            this.lastOperationId = 0L;
            if (this.decision == MVMap.Decision.PUT) {
                this.transaction.logUndo();
            }
        }
        this.blockingTransaction = null;
        this.decision = null;
        this.lastValue = null;
    }

    @Override
    public <T extends VersionedValue<V>> T selectValue(T existingValue, T providedValue) {
        return (T)VersionedValueUncommitted.getInstance(this.undoKey, this.getNewValue(existingValue), this.lastValue);
    }

    V getNewValue(VersionedValue<V> existingValue) {
        return this.value;
    }

    MVMap.Decision logAndDecideToPut(VersionedValue<V> valueToLog, V lastValue) {
        this.undoKey = this.transaction.log(new Record<K, V>(this.mapId, this.key, valueToLog));
        this.lastValue = lastValue;
        return this.setDecision(MVMap.Decision.PUT);
    }

    final MVMap.Decision decideToAbort(V lastValue) {
        this.lastValue = lastValue;
        return this.setDecision(MVMap.Decision.ABORT);
    }

    final boolean allowNonRepeatableRead() {
        return this.transaction.allowNonRepeatableRead();
    }

    final MVMap.Decision getDecision() {
        return this.decision;
    }

    final Transaction getBlockingTransaction() {
        return this.blockingTransaction;
    }

    final V getLastValue() {
        return this.lastValue;
    }

    final boolean isThisTransaction(int transactionId) {
        return transactionId == this.transaction.transactionId;
    }

    final boolean isCommitted(int transactionId) {
        boolean result;
        Transaction blockingTx;
        TransactionStore store = this.transaction.store;
        do {
            blockingTx = store.getTransaction(transactionId);
            result = store.committingTransactions.get().get(transactionId);
        } while (blockingTx != store.getTransaction(transactionId));
        if (!result) {
            this.blockingTransaction = blockingTx;
        }
        return result;
    }

    final boolean isRepeatedOperation(long id) {
        if (id == this.lastOperationId) {
            return true;
        }
        this.lastOperationId = id;
        return false;
    }

    final MVMap.Decision setDecision(MVMap.Decision decision) {
        this.decision = decision;
        return this.decision;
    }

    public final String toString() {
        return "txdm " + this.transaction.transactionId;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class LockDecisionMaker<K, V>
    extends TxDecisionMaker<K, V> {
        LockDecisionMaker(int mapId, Transaction transaction) {
            super(mapId, transaction);
        }

        @Override
        public MVMap.Decision decide(VersionedValue<V> existingValue, VersionedValue<V> providedValue) {
            MVMap.Decision decision = super.decide(existingValue, providedValue);
            if (existingValue == null) {
                assert (decision == MVMap.Decision.PUT);
                decision = this.setDecision(MVMap.Decision.REMOVE);
            }
            return decision;
        }

        @Override
        V getNewValue(VersionedValue<V> existingValue) {
            return existingValue == null ? null : (V)existingValue.getCurrentValue();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class PutIfAbsentDecisionMaker<K, V>
    extends TxDecisionMaker<K, V> {
        private final Function<K, V> oldValueSupplier;

        PutIfAbsentDecisionMaker(int mapId, Transaction transaction, Function<K, V> oldValueSupplier) {
            super(mapId, transaction);
            this.oldValueSupplier = oldValueSupplier;
        }

        @Override
        public MVMap.Decision decide(VersionedValue<V> existingValue, VersionedValue<V> providedValue) {
            int blockingId;
            assert (this.getDecision() == null);
            if (existingValue == null) {
                V snapshotValue = this.getValueInSnapshot();
                if (snapshotValue != null) {
                    return this.decideToAbort(snapshotValue);
                }
                return this.logAndDecideToPut(null, null);
            }
            long id = existingValue.getOperationId();
            if (id == 0L || this.isThisTransaction(blockingId = TransactionStore.getTransactionId(id))) {
                V snapshotValue;
                if (existingValue.getCurrentValue() != null) {
                    return this.decideToAbort(existingValue.getCurrentValue());
                }
                if (id == 0L && (snapshotValue = this.getValueInSnapshot()) != null) {
                    return this.decideToAbort(snapshotValue);
                }
                return this.logAndDecideToPut(existingValue, existingValue.getCommittedValue());
            }
            if (this.isCommitted(blockingId)) {
                if (existingValue.getCurrentValue() != null) {
                    return this.decideToAbort(existingValue.getCurrentValue());
                }
                V snapshotValue = this.getValueInSnapshot();
                if (snapshotValue != null) {
                    return this.decideToAbort(snapshotValue);
                }
                return this.logAndDecideToPut(null, null);
            }
            if (this.getBlockingTransaction() != null) {
                return this.decideToAbort(existingValue.getCurrentValue());
            }
            if (this.isRepeatedOperation(id)) {
                V committedValue = existingValue.getCommittedValue();
                if (committedValue != null) {
                    return this.decideToAbort(committedValue);
                }
                return this.logAndDecideToPut(null, null);
            }
            return this.setDecision(MVMap.Decision.REPEAT);
        }

        private V getValueInSnapshot() {
            return this.allowNonRepeatableRead() ? null : (V)this.oldValueSupplier.apply(this.key);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class RepeatableReadLockDecisionMaker<K, V>
    extends LockDecisionMaker<K, V> {
        private final DataType<VersionedValue<V>> valueType;
        private final Function<K, V> snapshotValueSupplier;

        RepeatableReadLockDecisionMaker(int mapId, Transaction transaction, DataType<VersionedValue<V>> valueType, Function<K, V> snapshotValueSupplier) {
            super(mapId, transaction);
            this.valueType = valueType;
            this.snapshotValueSupplier = snapshotValueSupplier;
        }

        @Override
        MVMap.Decision logAndDecideToPut(VersionedValue<V> valueToLog, V value) {
            V snapshotValue = this.snapshotValueSupplier.apply(this.key);
            if (snapshotValue != null && (valueToLog == null || this.valueType.compare(VersionedValueCommitted.getInstance(snapshotValue), valueToLog) != 0)) {
                throw DataUtils.newMVStoreException(105, "", new Object[0]);
            }
            return super.logAndDecideToPut(valueToLog, value);
        }
    }
}

